/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.sns.model.SetEndpointAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class SetEndpointAttributesRequestMarshaller
implements Marshaller<Request<SetEndpointAttributesRequest>, SetEndpointAttributesRequest> {
    public Request<SetEndpointAttributesRequest> marshall(SetEndpointAttributesRequest setEndpointAttributesRequest) {
        if (setEndpointAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setEndpointAttributesRequest, "AmazonSNS");
        request.addParameter("Action", "SetEndpointAttributes");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (setEndpointAttributesRequest.getEndpointArn() != null) {
            request.addParameter("EndpointArn", StringUtils.fromString((String)setEndpointAttributesRequest.getEndpointArn()));
        }
        Map<String, String> attributes = setEndpointAttributesRequest.getAttributes();
        int attributesListIndex = 1;
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (entry.getKey() != null) {
                request.addParameter("Attributes.entry." + attributesListIndex + ".key", StringUtils.fromString((String)entry.getKey()));
            }
            if (entry.getValue() != null) {
                request.addParameter("Attributes.entry." + attributesListIndex + ".value", StringUtils.fromString((String)entry.getValue()));
            }
            ++attributesListIndex;
        }
        return request;
    }
}

