/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowdevicemanagement;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.snowdevicemanagement.AWSSnowDeviceManagementAsync;
import com.amazonaws.services.snowdevicemanagement.AWSSnowDeviceManagementAsyncClientBuilder;
import com.amazonaws.services.snowdevicemanagement.AWSSnowDeviceManagementClient;
import com.amazonaws.services.snowdevicemanagement.model.CancelTaskRequest;
import com.amazonaws.services.snowdevicemanagement.model.CancelTaskResult;
import com.amazonaws.services.snowdevicemanagement.model.CreateTaskRequest;
import com.amazonaws.services.snowdevicemanagement.model.CreateTaskResult;
import com.amazonaws.services.snowdevicemanagement.model.DescribeDeviceEc2InstancesRequest;
import com.amazonaws.services.snowdevicemanagement.model.DescribeDeviceEc2InstancesResult;
import com.amazonaws.services.snowdevicemanagement.model.DescribeDeviceRequest;
import com.amazonaws.services.snowdevicemanagement.model.DescribeDeviceResult;
import com.amazonaws.services.snowdevicemanagement.model.DescribeExecutionRequest;
import com.amazonaws.services.snowdevicemanagement.model.DescribeExecutionResult;
import com.amazonaws.services.snowdevicemanagement.model.DescribeTaskRequest;
import com.amazonaws.services.snowdevicemanagement.model.DescribeTaskResult;
import com.amazonaws.services.snowdevicemanagement.model.ListDeviceResourcesRequest;
import com.amazonaws.services.snowdevicemanagement.model.ListDeviceResourcesResult;
import com.amazonaws.services.snowdevicemanagement.model.ListDevicesRequest;
import com.amazonaws.services.snowdevicemanagement.model.ListDevicesResult;
import com.amazonaws.services.snowdevicemanagement.model.ListExecutionsRequest;
import com.amazonaws.services.snowdevicemanagement.model.ListExecutionsResult;
import com.amazonaws.services.snowdevicemanagement.model.ListTagsForResourceRequest;
import com.amazonaws.services.snowdevicemanagement.model.ListTagsForResourceResult;
import com.amazonaws.services.snowdevicemanagement.model.ListTasksRequest;
import com.amazonaws.services.snowdevicemanagement.model.ListTasksResult;
import com.amazonaws.services.snowdevicemanagement.model.TagResourceRequest;
import com.amazonaws.services.snowdevicemanagement.model.TagResourceResult;
import com.amazonaws.services.snowdevicemanagement.model.UntagResourceRequest;
import com.amazonaws.services.snowdevicemanagement.model.UntagResourceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSSnowDeviceManagementAsyncClient
extends AWSSnowDeviceManagementClient
implements AWSSnowDeviceManagementAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSSnowDeviceManagementAsyncClientBuilder asyncBuilder() {
        return AWSSnowDeviceManagementAsyncClientBuilder.standard();
    }

    AWSSnowDeviceManagementAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSSnowDeviceManagementAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CancelTaskResult> cancelTaskAsync(CancelTaskRequest request) {
        return this.cancelTaskAsync(request, null);
    }

    @Override
    public Future<CancelTaskResult> cancelTaskAsync(CancelTaskRequest request, final AsyncHandler<CancelTaskRequest, CancelTaskResult> asyncHandler) {
        final CancelTaskRequest finalRequest = (CancelTaskRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelTaskResult>(){

            @Override
            public CancelTaskResult call() throws Exception {
                CancelTaskResult result = null;
                try {
                    result = AWSSnowDeviceManagementAsyncClient.this.executeCancelTask(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTaskResult> createTaskAsync(CreateTaskRequest request) {
        return this.createTaskAsync(request, null);
    }

    @Override
    public Future<CreateTaskResult> createTaskAsync(CreateTaskRequest request, final AsyncHandler<CreateTaskRequest, CreateTaskResult> asyncHandler) {
        final CreateTaskRequest finalRequest = (CreateTaskRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateTaskResult>(){

            @Override
            public CreateTaskResult call() throws Exception {
                CreateTaskResult result = null;
                try {
                    result = AWSSnowDeviceManagementAsyncClient.this.executeCreateTask(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDeviceResult> describeDeviceAsync(DescribeDeviceRequest request) {
        return this.describeDeviceAsync(request, null);
    }

    @Override
    public Future<DescribeDeviceResult> describeDeviceAsync(DescribeDeviceRequest request, final AsyncHandler<DescribeDeviceRequest, DescribeDeviceResult> asyncHandler) {
        final DescribeDeviceRequest finalRequest = (DescribeDeviceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDeviceResult>(){

            @Override
            public DescribeDeviceResult call() throws Exception {
                DescribeDeviceResult result = null;
                try {
                    result = AWSSnowDeviceManagementAsyncClient.this.executeDescribeDevice(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDeviceEc2InstancesResult> describeDeviceEc2InstancesAsync(DescribeDeviceEc2InstancesRequest request) {
        return this.describeDeviceEc2InstancesAsync(request, null);
    }

    @Override
    public Future<DescribeDeviceEc2InstancesResult> describeDeviceEc2InstancesAsync(DescribeDeviceEc2InstancesRequest request, final AsyncHandler<DescribeDeviceEc2InstancesRequest, DescribeDeviceEc2InstancesResult> asyncHandler) {
        final DescribeDeviceEc2InstancesRequest finalRequest = (DescribeDeviceEc2InstancesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDeviceEc2InstancesResult>(){

            @Override
            public DescribeDeviceEc2InstancesResult call() throws Exception {
                DescribeDeviceEc2InstancesResult result = null;
                try {
                    result = AWSSnowDeviceManagementAsyncClient.this.executeDescribeDeviceEc2Instances(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeExecutionResult> describeExecutionAsync(DescribeExecutionRequest request) {
        return this.describeExecutionAsync(request, null);
    }

    @Override
    public Future<DescribeExecutionResult> describeExecutionAsync(DescribeExecutionRequest request, final AsyncHandler<DescribeExecutionRequest, DescribeExecutionResult> asyncHandler) {
        final DescribeExecutionRequest finalRequest = (DescribeExecutionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeExecutionResult>(){

            @Override
            public DescribeExecutionResult call() throws Exception {
                DescribeExecutionResult result = null;
                try {
                    result = AWSSnowDeviceManagementAsyncClient.this.executeDescribeExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTaskResult> describeTaskAsync(DescribeTaskRequest request) {
        return this.describeTaskAsync(request, null);
    }

    @Override
    public Future<DescribeTaskResult> describeTaskAsync(DescribeTaskRequest request, final AsyncHandler<DescribeTaskRequest, DescribeTaskResult> asyncHandler) {
        final DescribeTaskRequest finalRequest = (DescribeTaskRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTaskResult>(){

            @Override
            public DescribeTaskResult call() throws Exception {
                DescribeTaskResult result = null;
                try {
                    result = AWSSnowDeviceManagementAsyncClient.this.executeDescribeTask(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDeviceResourcesResult> listDeviceResourcesAsync(ListDeviceResourcesRequest request) {
        return this.listDeviceResourcesAsync(request, null);
    }

    @Override
    public Future<ListDeviceResourcesResult> listDeviceResourcesAsync(ListDeviceResourcesRequest request, final AsyncHandler<ListDeviceResourcesRequest, ListDeviceResourcesResult> asyncHandler) {
        final ListDeviceResourcesRequest finalRequest = (ListDeviceResourcesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDeviceResourcesResult>(){

            @Override
            public ListDeviceResourcesResult call() throws Exception {
                ListDeviceResourcesResult result = null;
                try {
                    result = AWSSnowDeviceManagementAsyncClient.this.executeListDeviceResources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDevicesResult> listDevicesAsync(ListDevicesRequest request) {
        return this.listDevicesAsync(request, null);
    }

    @Override
    public Future<ListDevicesResult> listDevicesAsync(ListDevicesRequest request, final AsyncHandler<ListDevicesRequest, ListDevicesResult> asyncHandler) {
        final ListDevicesRequest finalRequest = (ListDevicesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDevicesResult>(){

            @Override
            public ListDevicesResult call() throws Exception {
                ListDevicesResult result = null;
                try {
                    result = AWSSnowDeviceManagementAsyncClient.this.executeListDevices(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListExecutionsResult> listExecutionsAsync(ListExecutionsRequest request) {
        return this.listExecutionsAsync(request, null);
    }

    @Override
    public Future<ListExecutionsResult> listExecutionsAsync(ListExecutionsRequest request, final AsyncHandler<ListExecutionsRequest, ListExecutionsResult> asyncHandler) {
        final ListExecutionsRequest finalRequest = (ListExecutionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListExecutionsResult>(){

            @Override
            public ListExecutionsResult call() throws Exception {
                ListExecutionsResult result = null;
                try {
                    result = AWSSnowDeviceManagementAsyncClient.this.executeListExecutions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSSnowDeviceManagementAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTasksResult> listTasksAsync(ListTasksRequest request) {
        return this.listTasksAsync(request, null);
    }

    @Override
    public Future<ListTasksResult> listTasksAsync(ListTasksRequest request, final AsyncHandler<ListTasksRequest, ListTasksResult> asyncHandler) {
        final ListTasksRequest finalRequest = (ListTasksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTasksResult>(){

            @Override
            public ListTasksResult call() throws Exception {
                ListTasksResult result = null;
                try {
                    result = AWSSnowDeviceManagementAsyncClient.this.executeListTasks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSSnowDeviceManagementAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSSnowDeviceManagementAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

