/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.snowball.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateCluster" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateClusterRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The type of job for this cluster. Currently, the only job type supported for clusters is <code>LOCAL_USE</code>.
     * </p>
     * <p>
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
     * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
     * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
     * Capacity) in the <i>Snowcone User Guide</i>.
     * </p>
     */
    private String jobType;
    /**
     * <p>
     * The resources associated with the cluster job. These resources include Amazon S3 buckets and optional Lambda
     * functions written in the Python language.
     * </p>
     */
    private JobResource resources;
    /**
     * <p>
     * Specifies the service or services on the Snow Family device that your transferred data will be exported from or
     * imported into. Amazon Web Services Snow Family device clusters support Amazon S3 and NFS (Network File System).
     * </p>
     */
    private OnDeviceServiceConfiguration onDeviceServiceConfiguration;
    /**
     * <p>
     * An optional description of this specific cluster, for example <code>Environmental Data Cluster-01</code>.
     * </p>
     */
    private String description;
    /**
     * <p>
     * The ID for the address that you want the cluster shipped to.
     * </p>
     */
    private String addressId;
    /**
     * <p>
     * The <code>KmsKeyARN</code> value that you want to associate with this cluster. <code>KmsKeyARN</code> values are
     * created by using the <a
     * href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in Key
     * Management Service (KMS).
     * </p>
     */
    private String kmsKeyARN;
    /**
     * <p>
     * The <code>RoleARN</code> that you want to associate with this cluster. <code>RoleArn</code> values are created by
     * using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API
     * action in Identity and Access Management (IAM).
     * </p>
     */
    private String roleARN;
    /**
     * <p>
     * The type of Snow Family devices to use for this cluster.
     * </p>
     * <note>
     * <p>
     * For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device type.
     * </p>
     * </note>
     * <p>
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
     * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
     * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
     * Capacity) in the <i>Snowcone User Guide</i>.
     * </p>
     */
    private String snowballType;
    /**
     * <p>
     * The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each Snowball
     * Edge device, rather it represents how quickly each device moves to its destination while in transit. Regional
     * shipping speeds are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about
     * a day.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are
     * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically
     * takes less than a week, one way.
     * </p>
     * </li>
     * <li>
     * <p>
     * In India, Snow devices are delivered in one to seven days.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the United States of America (US), you have access to one-day shipping and two-day shipping.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * In Australia, you have access to express shipping. Typically, devices shipped express are delivered in about a
     * day.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are
     * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically
     * takes less than a week, one way.
     * </p>
     * </li>
     * <li>
     * <p>
     * In India, Snow devices are delivered in one to seven days.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the US, you have access to one-day shipping and two-day shipping.
     * </p>
     * </li>
     * </ul>
     */
    private String shippingOption;
    /**
     * <p>
     * The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.
     * </p>
     */
    private Notification notification;
    /**
     * <p>
     * The forwarding address ID for a cluster. This field is not supported in most regions.
     * </p>
     */
    private String forwardingAddressId;
    /**
     * <p>
     * The tax documents required in your Amazon Web Services Region.
     * </p>
     */
    private TaxDocuments taxDocuments;
    /**
     * <p>
     * Allows you to securely operate and manage Snow devices in a cluster remotely from outside of your internal
     * network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available when the
     * device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.
     * </p>
     */
    private String remoteManagement;
    /**
     * <p>
     * If provided, each job will be automatically created and associated with the new cluster. If not provided, will be
     * treated as 0.
     * </p>
     */
    private Integer initialClusterSize;
    /**
     * <p>
     * Force to create cluster when user attempts to overprovision or underprovision a cluster. A cluster is
     * overprovisioned or underprovisioned if the initial size of the cluster is more (overprovisioned) or less
     * (underprovisioned) than what needed to meet capacity requirement specified with
     * <code>OnDeviceServiceConfiguration</code>.
     * </p>
     */
    private Boolean forceCreateJobs;
    /**
     * <p>
     * Lists long-term pricing id that will be used to associate with jobs automatically created for the new cluster.
     * </p>
     */
    private java.util.List<String> longTermPricingIds;
    /**
     * <p>
     * If your job is being created in one of the US regions, you have the option of specifying what size Snow device
     * you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.
     * </p>
     * <p>
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
     * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
     * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
     * Capacity) in the <i>Snowcone User Guide</i>.
     * </p>
     */
    private String snowballCapacityPreference;

    /**
     * <p>
     * The type of job for this cluster. Currently, the only job type supported for clusters is <code>LOCAL_USE</code>.
     * </p>
     * <p>
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
     * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
     * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
     * Capacity) in the <i>Snowcone User Guide</i>.
     * </p>
     * 
     * @param jobType
     *        The type of job for this cluster. Currently, the only job type supported for clusters is
     *        <code>LOCAL_USE</code>.</p>
     *        <p>
     *        For more information, see
     *        "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices
     *        and Capacity) in the <i>Snowcone User Guide</i> or
     *        "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices
     *        and Capacity) in the <i>Snowcone User Guide</i>.
     * @see JobType
     */

    public void setJobType(String jobType) {
        this.jobType = jobType;
    }

    /**
     * <p>
     * The type of job for this cluster. Currently, the only job type supported for clusters is <code>LOCAL_USE</code>.
     * </p>
     * <p>
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
     * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
     * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
     * Capacity) in the <i>Snowcone User Guide</i>.
     * </p>
     * 
     * @return The type of job for this cluster. Currently, the only job type supported for clusters is
     *         <code>LOCAL_USE</code>.</p>
     *         <p>
     *         For more information, see
     *         "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices
     *         and Capacity) in the <i>Snowcone User Guide</i> or
     *         "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices
     *         and Capacity) in the <i>Snowcone User Guide</i>.
     * @see JobType
     */

    public String getJobType() {
        return this.jobType;
    }

    /**
     * <p>
     * The type of job for this cluster. Currently, the only job type supported for clusters is <code>LOCAL_USE</code>.
     * </p>
     * <p>
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
     * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
     * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
     * Capacity) in the <i>Snowcone User Guide</i>.
     * </p>
     * 
     * @param jobType
     *        The type of job for this cluster. Currently, the only job type supported for clusters is
     *        <code>LOCAL_USE</code>.</p>
     *        <p>
     *        For more information, see
     *        "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices
     *        and Capacity) in the <i>Snowcone User Guide</i> or
     *        "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices
     *        and Capacity) in the <i>Snowcone User Guide</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see JobType
     */

    public CreateClusterRequest withJobType(String jobType) {
        setJobType(jobType);
        return this;
    }

    /**
     * <p>
     * The type of job for this cluster. Currently, the only job type supported for clusters is <code>LOCAL_USE</code>.
     * </p>
     * <p>
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
     * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
     * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
     * Capacity) in the <i>Snowcone User Guide</i>.
     * </p>
     * 
     * @param jobType
     *        The type of job for this cluster. Currently, the only job type supported for clusters is
     *        <code>LOCAL_USE</code>.</p>
     *        <p>
     *        For more information, see
     *        "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices
     *        and Capacity) in the <i>Snowcone User Guide</i> or
     *        "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices
     *        and Capacity) in the <i>Snowcone User Guide</i>.
     * @see JobType
     */

    public void setJobType(JobType jobType) {
        withJobType(jobType);
    }

    /**
     * <p>
     * The type of job for this cluster. Currently, the only job type supported for clusters is <code>LOCAL_USE</code>.
     * </p>
     * <p>
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
     * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
     * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
     * Capacity) in the <i>Snowcone User Guide</i>.
     * </p>
     * 
     * @param jobType
     *        The type of job for this cluster. Currently, the only job type supported for clusters is
     *        <code>LOCAL_USE</code>.</p>
     *        <p>
     *        For more information, see
     *        "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices
     *        and Capacity) in the <i>Snowcone User Guide</i> or
     *        "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices
     *        and Capacity) in the <i>Snowcone User Guide</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see JobType
     */

    public CreateClusterRequest withJobType(JobType jobType) {
        this.jobType = jobType.toString();
        return this;
    }

    /**
     * <p>
     * The resources associated with the cluster job. These resources include Amazon S3 buckets and optional Lambda
     * functions written in the Python language.
     * </p>
     * 
     * @param resources
     *        The resources associated with the cluster job. These resources include Amazon S3 buckets and optional
     *        Lambda functions written in the Python language.
     */

    public void setResources(JobResource resources) {
        this.resources = resources;
    }

    /**
     * <p>
     * The resources associated with the cluster job. These resources include Amazon S3 buckets and optional Lambda
     * functions written in the Python language.
     * </p>
     * 
     * @return The resources associated with the cluster job. These resources include Amazon S3 buckets and optional
     *         Lambda functions written in the Python language.
     */

    public JobResource getResources() {
        return this.resources;
    }

    /**
     * <p>
     * The resources associated with the cluster job. These resources include Amazon S3 buckets and optional Lambda
     * functions written in the Python language.
     * </p>
     * 
     * @param resources
     *        The resources associated with the cluster job. These resources include Amazon S3 buckets and optional
     *        Lambda functions written in the Python language.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateClusterRequest withResources(JobResource resources) {
        setResources(resources);
        return this;
    }

    /**
     * <p>
     * Specifies the service or services on the Snow Family device that your transferred data will be exported from or
     * imported into. Amazon Web Services Snow Family device clusters support Amazon S3 and NFS (Network File System).
     * </p>
     * 
     * @param onDeviceServiceConfiguration
     *        Specifies the service or services on the Snow Family device that your transferred data will be exported
     *        from or imported into. Amazon Web Services Snow Family device clusters support Amazon S3 and NFS (Network
     *        File System).
     */

    public void setOnDeviceServiceConfiguration(OnDeviceServiceConfiguration onDeviceServiceConfiguration) {
        this.onDeviceServiceConfiguration = onDeviceServiceConfiguration;
    }

    /**
     * <p>
     * Specifies the service or services on the Snow Family device that your transferred data will be exported from or
     * imported into. Amazon Web Services Snow Family device clusters support Amazon S3 and NFS (Network File System).
     * </p>
     * 
     * @return Specifies the service or services on the Snow Family device that your transferred data will be exported
     *         from or imported into. Amazon Web Services Snow Family device clusters support Amazon S3 and NFS (Network
     *         File System).
     */

    public OnDeviceServiceConfiguration getOnDeviceServiceConfiguration() {
        return this.onDeviceServiceConfiguration;
    }

    /**
     * <p>
     * Specifies the service or services on the Snow Family device that your transferred data will be exported from or
     * imported into. Amazon Web Services Snow Family device clusters support Amazon S3 and NFS (Network File System).
     * </p>
     * 
     * @param onDeviceServiceConfiguration
     *        Specifies the service or services on the Snow Family device that your transferred data will be exported
     *        from or imported into. Amazon Web Services Snow Family device clusters support Amazon S3 and NFS (Network
     *        File System).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateClusterRequest withOnDeviceServiceConfiguration(OnDeviceServiceConfiguration onDeviceServiceConfiguration) {
        setOnDeviceServiceConfiguration(onDeviceServiceConfiguration);
        return this;
    }

    /**
     * <p>
     * An optional description of this specific cluster, for example <code>Environmental Data Cluster-01</code>.
     * </p>
     * 
     * @param description
     *        An optional description of this specific cluster, for example <code>Environmental Data Cluster-01</code>.
     */

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * <p>
     * An optional description of this specific cluster, for example <code>Environmental Data Cluster-01</code>.
     * </p>
     * 
     * @return An optional description of this specific cluster, for example <code>Environmental Data Cluster-01</code>.
     */

    public String getDescription() {
        return this.description;
    }

    /**
     * <p>
     * An optional description of this specific cluster, for example <code>Environmental Data Cluster-01</code>.
     * </p>
     * 
     * @param description
     *        An optional description of this specific cluster, for example <code>Environmental Data Cluster-01</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateClusterRequest withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * <p>
     * The ID for the address that you want the cluster shipped to.
     * </p>
     * 
     * @param addressId
     *        The ID for the address that you want the cluster shipped to.
     */

    public void setAddressId(String addressId) {
        this.addressId = addressId;
    }

    /**
     * <p>
     * The ID for the address that you want the cluster shipped to.
     * </p>
     * 
     * @return The ID for the address that you want the cluster shipped to.
     */

    public String getAddressId() {
        return this.addressId;
    }

    /**
     * <p>
     * The ID for the address that you want the cluster shipped to.
     * </p>
     * 
     * @param addressId
     *        The ID for the address that you want the cluster shipped to.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateClusterRequest withAddressId(String addressId) {
        setAddressId(addressId);
        return this;
    }

    /**
     * <p>
     * The <code>KmsKeyARN</code> value that you want to associate with this cluster. <code>KmsKeyARN</code> values are
     * created by using the <a
     * href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in Key
     * Management Service (KMS).
     * </p>
     * 
     * @param kmsKeyARN
     *        The <code>KmsKeyARN</code> value that you want to associate with this cluster. <code>KmsKeyARN</code>
     *        values are created by using the <a
     *        href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in
     *        Key Management Service (KMS).
     */

    public void setKmsKeyARN(String kmsKeyARN) {
        this.kmsKeyARN = kmsKeyARN;
    }

    /**
     * <p>
     * The <code>KmsKeyARN</code> value that you want to associate with this cluster. <code>KmsKeyARN</code> values are
     * created by using the <a
     * href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in Key
     * Management Service (KMS).
     * </p>
     * 
     * @return The <code>KmsKeyARN</code> value that you want to associate with this cluster. <code>KmsKeyARN</code>
     *         values are created by using the <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in
     *         Key Management Service (KMS).
     */

    public String getKmsKeyARN() {
        return this.kmsKeyARN;
    }

    /**
     * <p>
     * The <code>KmsKeyARN</code> value that you want to associate with this cluster. <code>KmsKeyARN</code> values are
     * created by using the <a
     * href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in Key
     * Management Service (KMS).
     * </p>
     * 
     * @param kmsKeyARN
     *        The <code>KmsKeyARN</code> value that you want to associate with this cluster. <code>KmsKeyARN</code>
     *        values are created by using the <a
     *        href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in
     *        Key Management Service (KMS).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateClusterRequest withKmsKeyARN(String kmsKeyARN) {
        setKmsKeyARN(kmsKeyARN);
        return this;
    }

    /**
     * <p>
     * The <code>RoleARN</code> that you want to associate with this cluster. <code>RoleArn</code> values are created by
     * using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API
     * action in Identity and Access Management (IAM).
     * </p>
     * 
     * @param roleARN
     *        The <code>RoleARN</code> that you want to associate with this cluster. <code>RoleArn</code> values are
     *        created by using the <a
     *        href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action
     *        in Identity and Access Management (IAM).
     */

    public void setRoleARN(String roleARN) {
        this.roleARN = roleARN;
    }

    /**
     * <p>
     * The <code>RoleARN</code> that you want to associate with this cluster. <code>RoleArn</code> values are created by
     * using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API
     * action in Identity and Access Management (IAM).
     * </p>
     * 
     * @return The <code>RoleARN</code> that you want to associate with this cluster. <code>RoleArn</code> values are
     *         created by using the <a
     *         href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action
     *         in Identity and Access Management (IAM).
     */

    public String getRoleARN() {
        return this.roleARN;
    }

    /**
     * <p>
     * The <code>RoleARN</code> that you want to associate with this cluster. <code>RoleArn</code> values are created by
     * using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API
     * action in Identity and Access Management (IAM).
     * </p>
     * 
     * @param roleARN
     *        The <code>RoleARN</code> that you want to associate with this cluster. <code>RoleArn</code> values are
     *        created by using the <a
     *        href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action
     *        in Identity and Access Management (IAM).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateClusterRequest withRoleARN(String roleARN) {
        setRoleARN(roleARN);
        return this;
    }

    /**
     * <p>
     * The type of Snow Family devices to use for this cluster.
     * </p>
     * <note>
     * <p>
     * For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device type.
     * </p>
     * </note>
     * <p>
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
     * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
     * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
     * Capacity) in the <i>Snowcone User Guide</i>.
     * </p>
     * 
     * @param snowballType
     *        The type of Snow Family devices to use for this cluster. </p> <note>
     *        <p>
     *        For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device
     *        type.
     *        </p>
     *        </note>
     *        <p>
     *        For more information, see
     *        "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices
     *        and Capacity) in the <i>Snowcone User Guide</i> or
     *        "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices
     *        and Capacity) in the <i>Snowcone User Guide</i>.
     * @see SnowballType
     */

    public void setSnowballType(String snowballType) {
        this.snowballType = snowballType;
    }

    /**
     * <p>
     * The type of Snow Family devices to use for this cluster.
     * </p>
     * <note>
     * <p>
     * For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device type.
     * </p>
     * </note>
     * <p>
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
     * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
     * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
     * Capacity) in the <i>Snowcone User Guide</i>.
     * </p>
     * 
     * @return The type of Snow Family devices to use for this cluster. </p> <note>
     *         <p>
     *         For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device
     *         type.
     *         </p>
     *         </note>
     *         <p>
     *         For more information, see
     *         "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices
     *         and Capacity) in the <i>Snowcone User Guide</i> or
     *         "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices
     *         and Capacity) in the <i>Snowcone User Guide</i>.
     * @see SnowballType
     */

    public String getSnowballType() {
        return this.snowballType;
    }

    /**
     * <p>
     * The type of Snow Family devices to use for this cluster.
     * </p>
     * <note>
     * <p>
     * For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device type.
     * </p>
     * </note>
     * <p>
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
     * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
     * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
     * Capacity) in the <i>Snowcone User Guide</i>.
     * </p>
     * 
     * @param snowballType
     *        The type of Snow Family devices to use for this cluster. </p> <note>
     *        <p>
     *        For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device
     *        type.
     *        </p>
     *        </note>
     *        <p>
     *        For more information, see
     *        "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices
     *        and Capacity) in the <i>Snowcone User Guide</i> or
     *        "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices
     *        and Capacity) in the <i>Snowcone User Guide</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SnowballType
     */

    public CreateClusterRequest withSnowballType(String snowballType) {
        setSnowballType(snowballType);
        return this;
    }

    /**
     * <p>
     * The type of Snow Family devices to use for this cluster.
     * </p>
     * <note>
     * <p>
     * For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device type.
     * </p>
     * </note>
     * <p>
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
     * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
     * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
     * Capacity) in the <i>Snowcone User Guide</i>.
     * </p>
     * 
     * @param snowballType
     *        The type of Snow Family devices to use for this cluster. </p> <note>
     *        <p>
     *        For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device
     *        type.
     *        </p>
     *        </note>
     *        <p>
     *        For more information, see
     *        "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices
     *        and Capacity) in the <i>Snowcone User Guide</i> or
     *        "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices
     *        and Capacity) in the <i>Snowcone User Guide</i>.
     * @see SnowballType
     */

    public void setSnowballType(SnowballType snowballType) {
        withSnowballType(snowballType);
    }

    /**
     * <p>
     * The type of Snow Family devices to use for this cluster.
     * </p>
     * <note>
     * <p>
     * For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device type.
     * </p>
     * </note>
     * <p>
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
     * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
     * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
     * Capacity) in the <i>Snowcone User Guide</i>.
     * </p>
     * 
     * @param snowballType
     *        The type of Snow Family devices to use for this cluster. </p> <note>
     *        <p>
     *        For cluster jobs, Amazon Web Services Snow Family currently supports only the <code>EDGE</code> device
     *        type.
     *        </p>
     *        </note>
     *        <p>
     *        For more information, see
     *        "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices
     *        and Capacity) in the <i>Snowcone User Guide</i> or
     *        "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices
     *        and Capacity) in the <i>Snowcone User Guide</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SnowballType
     */

    public CreateClusterRequest withSnowballType(SnowballType snowballType) {
        this.snowballType = snowballType.toString();
        return this;
    }

    /**
     * <p>
     * The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each Snowball
     * Edge device, rather it represents how quickly each device moves to its destination while in transit. Regional
     * shipping speeds are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about
     * a day.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are
     * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically
     * takes less than a week, one way.
     * </p>
     * </li>
     * <li>
     * <p>
     * In India, Snow devices are delivered in one to seven days.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the United States of America (US), you have access to one-day shipping and two-day shipping.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * In Australia, you have access to express shipping. Typically, devices shipped express are delivered in about a
     * day.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are
     * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically
     * takes less than a week, one way.
     * </p>
     * </li>
     * <li>
     * <p>
     * In India, Snow devices are delivered in one to seven days.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the US, you have access to one-day shipping and two-day shipping.
     * </p>
     * </li>
     * </ul>
     * 
     * @param shippingOption
     *        The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each
     *        Snowball Edge device, rather it represents how quickly each device moves to its destination while in
     *        transit. Regional shipping speeds are as follows: </p>
     *        <ul>
     *        <li>
     *        <p>
     *        In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered
     *        in about a day.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express
     *        are delivered in about a day. In addition, most countries in the EU have access to standard shipping,
     *        which typically takes less than a week, one way.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        In India, Snow devices are delivered in one to seven days.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        In the United States of America (US), you have access to one-day shipping and two-day shipping.
     *        </p>
     *        </li>
     *        </ul>
     *        <ul>
     *        <li>
     *        <p>
     *        In Australia, you have access to express shipping. Typically, devices shipped express are delivered in
     *        about a day.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express
     *        are delivered in about a day. In addition, most countries in the EU have access to standard shipping,
     *        which typically takes less than a week, one way.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        In India, Snow devices are delivered in one to seven days.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        In the US, you have access to one-day shipping and two-day shipping.
     *        </p>
     *        </li>
     * @see ShippingOption
     */

    public void setShippingOption(String shippingOption) {
        this.shippingOption = shippingOption;
    }

    /**
     * <p>
     * The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each Snowball
     * Edge device, rather it represents how quickly each device moves to its destination while in transit. Regional
     * shipping speeds are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about
     * a day.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are
     * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically
     * takes less than a week, one way.
     * </p>
     * </li>
     * <li>
     * <p>
     * In India, Snow devices are delivered in one to seven days.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the United States of America (US), you have access to one-day shipping and two-day shipping.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * In Australia, you have access to express shipping. Typically, devices shipped express are delivered in about a
     * day.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are
     * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically
     * takes less than a week, one way.
     * </p>
     * </li>
     * <li>
     * <p>
     * In India, Snow devices are delivered in one to seven days.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the US, you have access to one-day shipping and two-day shipping.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each
     *         Snowball Edge device, rather it represents how quickly each device moves to its destination while in
     *         transit. Regional shipping speeds are as follows: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered
     *         in about a day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express
     *         are delivered in about a day. In addition, most countries in the EU have access to standard shipping,
     *         which typically takes less than a week, one way.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In India, Snow devices are delivered in one to seven days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In the United States of America (US), you have access to one-day shipping and two-day shipping.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         In Australia, you have access to express shipping. Typically, devices shipped express are delivered in
     *         about a day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express
     *         are delivered in about a day. In addition, most countries in the EU have access to standard shipping,
     *         which typically takes less than a week, one way.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In India, Snow devices are delivered in one to seven days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In the US, you have access to one-day shipping and two-day shipping.
     *         </p>
     *         </li>
     * @see ShippingOption
     */

    public String getShippingOption() {
        return this.shippingOption;
    }

    /**
     * <p>
     * The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each Snowball
     * Edge device, rather it represents how quickly each device moves to its destination while in transit. Regional
     * shipping speeds are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about
     * a day.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are
     * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically
     * takes less than a week, one way.
     * </p>
     * </li>
     * <li>
     * <p>
     * In India, Snow devices are delivered in one to seven days.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the United States of America (US), you have access to one-day shipping and two-day shipping.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * In Australia, you have access to express shipping. Typically, devices shipped express are delivered in about a
     * day.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are
     * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically
     * takes less than a week, one way.
     * </p>
     * </li>
     * <li>
     * <p>
     * In India, Snow devices are delivered in one to seven days.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the US, you have access to one-day shipping and two-day shipping.
     * </p>
     * </li>
     * </ul>
     * 
     * @param shippingOption
     *        The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each
     *        Snowball Edge device, rather it represents how quickly each device moves to its destination while in
     *        transit. Regional shipping speeds are as follows: </p>
     *        <ul>
     *        <li>
     *        <p>
     *        In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered
     *        in about a day.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express
     *        are delivered in about a day. In addition, most countries in the EU have access to standard shipping,
     *        which typically takes less than a week, one way.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        In India, Snow devices are delivered in one to seven days.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        In the United States of America (US), you have access to one-day shipping and two-day shipping.
     *        </p>
     *        </li>
     *        </ul>
     *        <ul>
     *        <li>
     *        <p>
     *        In Australia, you have access to express shipping. Typically, devices shipped express are delivered in
     *        about a day.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express
     *        are delivered in about a day. In addition, most countries in the EU have access to standard shipping,
     *        which typically takes less than a week, one way.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        In India, Snow devices are delivered in one to seven days.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        In the US, you have access to one-day shipping and two-day shipping.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ShippingOption
     */

    public CreateClusterRequest withShippingOption(String shippingOption) {
        setShippingOption(shippingOption);
        return this;
    }

    /**
     * <p>
     * The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each Snowball
     * Edge device, rather it represents how quickly each device moves to its destination while in transit. Regional
     * shipping speeds are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about
     * a day.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are
     * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically
     * takes less than a week, one way.
     * </p>
     * </li>
     * <li>
     * <p>
     * In India, Snow devices are delivered in one to seven days.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the United States of America (US), you have access to one-day shipping and two-day shipping.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * In Australia, you have access to express shipping. Typically, devices shipped express are delivered in about a
     * day.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are
     * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically
     * takes less than a week, one way.
     * </p>
     * </li>
     * <li>
     * <p>
     * In India, Snow devices are delivered in one to seven days.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the US, you have access to one-day shipping and two-day shipping.
     * </p>
     * </li>
     * </ul>
     * 
     * @param shippingOption
     *        The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each
     *        Snowball Edge device, rather it represents how quickly each device moves to its destination while in
     *        transit. Regional shipping speeds are as follows: </p>
     *        <ul>
     *        <li>
     *        <p>
     *        In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered
     *        in about a day.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express
     *        are delivered in about a day. In addition, most countries in the EU have access to standard shipping,
     *        which typically takes less than a week, one way.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        In India, Snow devices are delivered in one to seven days.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        In the United States of America (US), you have access to one-day shipping and two-day shipping.
     *        </p>
     *        </li>
     *        </ul>
     *        <ul>
     *        <li>
     *        <p>
     *        In Australia, you have access to express shipping. Typically, devices shipped express are delivered in
     *        about a day.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express
     *        are delivered in about a day. In addition, most countries in the EU have access to standard shipping,
     *        which typically takes less than a week, one way.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        In India, Snow devices are delivered in one to seven days.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        In the US, you have access to one-day shipping and two-day shipping.
     *        </p>
     *        </li>
     * @see ShippingOption
     */

    public void setShippingOption(ShippingOption shippingOption) {
        withShippingOption(shippingOption);
    }

    /**
     * <p>
     * The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each Snowball
     * Edge device, rather it represents how quickly each device moves to its destination while in transit. Regional
     * shipping speeds are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about
     * a day.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are
     * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically
     * takes less than a week, one way.
     * </p>
     * </li>
     * <li>
     * <p>
     * In India, Snow devices are delivered in one to seven days.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the United States of America (US), you have access to one-day shipping and two-day shipping.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * In Australia, you have access to express shipping. Typically, devices shipped express are delivered in about a
     * day.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are
     * delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically
     * takes less than a week, one way.
     * </p>
     * </li>
     * <li>
     * <p>
     * In India, Snow devices are delivered in one to seven days.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the US, you have access to one-day shipping and two-day shipping.
     * </p>
     * </li>
     * </ul>
     * 
     * @param shippingOption
     *        The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each
     *        Snowball Edge device, rather it represents how quickly each device moves to its destination while in
     *        transit. Regional shipping speeds are as follows: </p>
     *        <ul>
     *        <li>
     *        <p>
     *        In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered
     *        in about a day.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express
     *        are delivered in about a day. In addition, most countries in the EU have access to standard shipping,
     *        which typically takes less than a week, one way.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        In India, Snow devices are delivered in one to seven days.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        In the United States of America (US), you have access to one-day shipping and two-day shipping.
     *        </p>
     *        </li>
     *        </ul>
     *        <ul>
     *        <li>
     *        <p>
     *        In Australia, you have access to express shipping. Typically, devices shipped express are delivered in
     *        about a day.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express
     *        are delivered in about a day. In addition, most countries in the EU have access to standard shipping,
     *        which typically takes less than a week, one way.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        In India, Snow devices are delivered in one to seven days.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        In the US, you have access to one-day shipping and two-day shipping.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ShippingOption
     */

    public CreateClusterRequest withShippingOption(ShippingOption shippingOption) {
        this.shippingOption = shippingOption.toString();
        return this;
    }

    /**
     * <p>
     * The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.
     * </p>
     * 
     * @param notification
     *        The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.
     */

    public void setNotification(Notification notification) {
        this.notification = notification;
    }

    /**
     * <p>
     * The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.
     * </p>
     * 
     * @return The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.
     */

    public Notification getNotification() {
        return this.notification;
    }

    /**
     * <p>
     * The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.
     * </p>
     * 
     * @param notification
     *        The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateClusterRequest withNotification(Notification notification) {
        setNotification(notification);
        return this;
    }

    /**
     * <p>
     * The forwarding address ID for a cluster. This field is not supported in most regions.
     * </p>
     * 
     * @param forwardingAddressId
     *        The forwarding address ID for a cluster. This field is not supported in most regions.
     */

    public void setForwardingAddressId(String forwardingAddressId) {
        this.forwardingAddressId = forwardingAddressId;
    }

    /**
     * <p>
     * The forwarding address ID for a cluster. This field is not supported in most regions.
     * </p>
     * 
     * @return The forwarding address ID for a cluster. This field is not supported in most regions.
     */

    public String getForwardingAddressId() {
        return this.forwardingAddressId;
    }

    /**
     * <p>
     * The forwarding address ID for a cluster. This field is not supported in most regions.
     * </p>
     * 
     * @param forwardingAddressId
     *        The forwarding address ID for a cluster. This field is not supported in most regions.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateClusterRequest withForwardingAddressId(String forwardingAddressId) {
        setForwardingAddressId(forwardingAddressId);
        return this;
    }

    /**
     * <p>
     * The tax documents required in your Amazon Web Services Region.
     * </p>
     * 
     * @param taxDocuments
     *        The tax documents required in your Amazon Web Services Region.
     */

    public void setTaxDocuments(TaxDocuments taxDocuments) {
        this.taxDocuments = taxDocuments;
    }

    /**
     * <p>
     * The tax documents required in your Amazon Web Services Region.
     * </p>
     * 
     * @return The tax documents required in your Amazon Web Services Region.
     */

    public TaxDocuments getTaxDocuments() {
        return this.taxDocuments;
    }

    /**
     * <p>
     * The tax documents required in your Amazon Web Services Region.
     * </p>
     * 
     * @param taxDocuments
     *        The tax documents required in your Amazon Web Services Region.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateClusterRequest withTaxDocuments(TaxDocuments taxDocuments) {
        setTaxDocuments(taxDocuments);
        return this;
    }

    /**
     * <p>
     * Allows you to securely operate and manage Snow devices in a cluster remotely from outside of your internal
     * network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available when the
     * device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.
     * </p>
     * 
     * @param remoteManagement
     *        Allows you to securely operate and manage Snow devices in a cluster remotely from outside of your internal
     *        network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available
     *        when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the
     *        device.
     * @see RemoteManagement
     */

    public void setRemoteManagement(String remoteManagement) {
        this.remoteManagement = remoteManagement;
    }

    /**
     * <p>
     * Allows you to securely operate and manage Snow devices in a cluster remotely from outside of your internal
     * network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available when the
     * device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.
     * </p>
     * 
     * @return Allows you to securely operate and manage Snow devices in a cluster remotely from outside of your
     *         internal network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be
     *         available when the device arrives at your location. Otherwise, you need to use the Snowball Client to
     *         manage the device.
     * @see RemoteManagement
     */

    public String getRemoteManagement() {
        return this.remoteManagement;
    }

    /**
     * <p>
     * Allows you to securely operate and manage Snow devices in a cluster remotely from outside of your internal
     * network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available when the
     * device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.
     * </p>
     * 
     * @param remoteManagement
     *        Allows you to securely operate and manage Snow devices in a cluster remotely from outside of your internal
     *        network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available
     *        when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the
     *        device.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see RemoteManagement
     */

    public CreateClusterRequest withRemoteManagement(String remoteManagement) {
        setRemoteManagement(remoteManagement);
        return this;
    }

    /**
     * <p>
     * Allows you to securely operate and manage Snow devices in a cluster remotely from outside of your internal
     * network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available when the
     * device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.
     * </p>
     * 
     * @param remoteManagement
     *        Allows you to securely operate and manage Snow devices in a cluster remotely from outside of your internal
     *        network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available
     *        when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the
     *        device.
     * @see RemoteManagement
     */

    public void setRemoteManagement(RemoteManagement remoteManagement) {
        withRemoteManagement(remoteManagement);
    }

    /**
     * <p>
     * Allows you to securely operate and manage Snow devices in a cluster remotely from outside of your internal
     * network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available when the
     * device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device.
     * </p>
     * 
     * @param remoteManagement
     *        Allows you to securely operate and manage Snow devices in a cluster remotely from outside of your internal
     *        network. When set to <code>INSTALLED_AUTOSTART</code>, remote management will automatically be available
     *        when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the
     *        device.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see RemoteManagement
     */

    public CreateClusterRequest withRemoteManagement(RemoteManagement remoteManagement) {
        this.remoteManagement = remoteManagement.toString();
        return this;
    }

    /**
     * <p>
     * If provided, each job will be automatically created and associated with the new cluster. If not provided, will be
     * treated as 0.
     * </p>
     * 
     * @param initialClusterSize
     *        If provided, each job will be automatically created and associated with the new cluster. If not provided,
     *        will be treated as 0.
     */

    public void setInitialClusterSize(Integer initialClusterSize) {
        this.initialClusterSize = initialClusterSize;
    }

    /**
     * <p>
     * If provided, each job will be automatically created and associated with the new cluster. If not provided, will be
     * treated as 0.
     * </p>
     * 
     * @return If provided, each job will be automatically created and associated with the new cluster. If not provided,
     *         will be treated as 0.
     */

    public Integer getInitialClusterSize() {
        return this.initialClusterSize;
    }

    /**
     * <p>
     * If provided, each job will be automatically created and associated with the new cluster. If not provided, will be
     * treated as 0.
     * </p>
     * 
     * @param initialClusterSize
     *        If provided, each job will be automatically created and associated with the new cluster. If not provided,
     *        will be treated as 0.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateClusterRequest withInitialClusterSize(Integer initialClusterSize) {
        setInitialClusterSize(initialClusterSize);
        return this;
    }

    /**
     * <p>
     * Force to create cluster when user attempts to overprovision or underprovision a cluster. A cluster is
     * overprovisioned or underprovisioned if the initial size of the cluster is more (overprovisioned) or less
     * (underprovisioned) than what needed to meet capacity requirement specified with
     * <code>OnDeviceServiceConfiguration</code>.
     * </p>
     * 
     * @param forceCreateJobs
     *        Force to create cluster when user attempts to overprovision or underprovision a cluster. A cluster is
     *        overprovisioned or underprovisioned if the initial size of the cluster is more (overprovisioned) or less
     *        (underprovisioned) than what needed to meet capacity requirement specified with
     *        <code>OnDeviceServiceConfiguration</code>.
     */

    public void setForceCreateJobs(Boolean forceCreateJobs) {
        this.forceCreateJobs = forceCreateJobs;
    }

    /**
     * <p>
     * Force to create cluster when user attempts to overprovision or underprovision a cluster. A cluster is
     * overprovisioned or underprovisioned if the initial size of the cluster is more (overprovisioned) or less
     * (underprovisioned) than what needed to meet capacity requirement specified with
     * <code>OnDeviceServiceConfiguration</code>.
     * </p>
     * 
     * @return Force to create cluster when user attempts to overprovision or underprovision a cluster. A cluster is
     *         overprovisioned or underprovisioned if the initial size of the cluster is more (overprovisioned) or less
     *         (underprovisioned) than what needed to meet capacity requirement specified with
     *         <code>OnDeviceServiceConfiguration</code>.
     */

    public Boolean getForceCreateJobs() {
        return this.forceCreateJobs;
    }

    /**
     * <p>
     * Force to create cluster when user attempts to overprovision or underprovision a cluster. A cluster is
     * overprovisioned or underprovisioned if the initial size of the cluster is more (overprovisioned) or less
     * (underprovisioned) than what needed to meet capacity requirement specified with
     * <code>OnDeviceServiceConfiguration</code>.
     * </p>
     * 
     * @param forceCreateJobs
     *        Force to create cluster when user attempts to overprovision or underprovision a cluster. A cluster is
     *        overprovisioned or underprovisioned if the initial size of the cluster is more (overprovisioned) or less
     *        (underprovisioned) than what needed to meet capacity requirement specified with
     *        <code>OnDeviceServiceConfiguration</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateClusterRequest withForceCreateJobs(Boolean forceCreateJobs) {
        setForceCreateJobs(forceCreateJobs);
        return this;
    }

    /**
     * <p>
     * Force to create cluster when user attempts to overprovision or underprovision a cluster. A cluster is
     * overprovisioned or underprovisioned if the initial size of the cluster is more (overprovisioned) or less
     * (underprovisioned) than what needed to meet capacity requirement specified with
     * <code>OnDeviceServiceConfiguration</code>.
     * </p>
     * 
     * @return Force to create cluster when user attempts to overprovision or underprovision a cluster. A cluster is
     *         overprovisioned or underprovisioned if the initial size of the cluster is more (overprovisioned) or less
     *         (underprovisioned) than what needed to meet capacity requirement specified with
     *         <code>OnDeviceServiceConfiguration</code>.
     */

    public Boolean isForceCreateJobs() {
        return this.forceCreateJobs;
    }

    /**
     * <p>
     * Lists long-term pricing id that will be used to associate with jobs automatically created for the new cluster.
     * </p>
     * 
     * @return Lists long-term pricing id that will be used to associate with jobs automatically created for the new
     *         cluster.
     */

    public java.util.List<String> getLongTermPricingIds() {
        return longTermPricingIds;
    }

    /**
     * <p>
     * Lists long-term pricing id that will be used to associate with jobs automatically created for the new cluster.
     * </p>
     * 
     * @param longTermPricingIds
     *        Lists long-term pricing id that will be used to associate with jobs automatically created for the new
     *        cluster.
     */

    public void setLongTermPricingIds(java.util.Collection<String> longTermPricingIds) {
        if (longTermPricingIds == null) {
            this.longTermPricingIds = null;
            return;
        }

        this.longTermPricingIds = new java.util.ArrayList<String>(longTermPricingIds);
    }

    /**
     * <p>
     * Lists long-term pricing id that will be used to associate with jobs automatically created for the new cluster.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setLongTermPricingIds(java.util.Collection)} or {@link #withLongTermPricingIds(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param longTermPricingIds
     *        Lists long-term pricing id that will be used to associate with jobs automatically created for the new
     *        cluster.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateClusterRequest withLongTermPricingIds(String... longTermPricingIds) {
        if (this.longTermPricingIds == null) {
            setLongTermPricingIds(new java.util.ArrayList<String>(longTermPricingIds.length));
        }
        for (String ele : longTermPricingIds) {
            this.longTermPricingIds.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Lists long-term pricing id that will be used to associate with jobs automatically created for the new cluster.
     * </p>
     * 
     * @param longTermPricingIds
     *        Lists long-term pricing id that will be used to associate with jobs automatically created for the new
     *        cluster.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateClusterRequest withLongTermPricingIds(java.util.Collection<String> longTermPricingIds) {
        setLongTermPricingIds(longTermPricingIds);
        return this;
    }

    /**
     * <p>
     * If your job is being created in one of the US regions, you have the option of specifying what size Snow device
     * you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.
     * </p>
     * <p>
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
     * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
     * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
     * Capacity) in the <i>Snowcone User Guide</i>.
     * </p>
     * 
     * @param snowballCapacityPreference
     *        If your job is being created in one of the US regions, you have the option of specifying what size Snow
     *        device you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.</p>
     *        <p>
     *        For more information, see
     *        "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices
     *        and Capacity) in the <i>Snowcone User Guide</i> or
     *        "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices
     *        and Capacity) in the <i>Snowcone User Guide</i>.
     * @see SnowballCapacity
     */

    public void setSnowballCapacityPreference(String snowballCapacityPreference) {
        this.snowballCapacityPreference = snowballCapacityPreference;
    }

    /**
     * <p>
     * If your job is being created in one of the US regions, you have the option of specifying what size Snow device
     * you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.
     * </p>
     * <p>
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
     * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
     * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
     * Capacity) in the <i>Snowcone User Guide</i>.
     * </p>
     * 
     * @return If your job is being created in one of the US regions, you have the option of specifying what size Snow
     *         device you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.</p>
     *         <p>
     *         For more information, see
     *         "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices
     *         and Capacity) in the <i>Snowcone User Guide</i> or
     *         "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices
     *         and Capacity) in the <i>Snowcone User Guide</i>.
     * @see SnowballCapacity
     */

    public String getSnowballCapacityPreference() {
        return this.snowballCapacityPreference;
    }

    /**
     * <p>
     * If your job is being created in one of the US regions, you have the option of specifying what size Snow device
     * you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.
     * </p>
     * <p>
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
     * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
     * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
     * Capacity) in the <i>Snowcone User Guide</i>.
     * </p>
     * 
     * @param snowballCapacityPreference
     *        If your job is being created in one of the US regions, you have the option of specifying what size Snow
     *        device you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.</p>
     *        <p>
     *        For more information, see
     *        "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices
     *        and Capacity) in the <i>Snowcone User Guide</i> or
     *        "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices
     *        and Capacity) in the <i>Snowcone User Guide</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SnowballCapacity
     */

    public CreateClusterRequest withSnowballCapacityPreference(String snowballCapacityPreference) {
        setSnowballCapacityPreference(snowballCapacityPreference);
        return this;
    }

    /**
     * <p>
     * If your job is being created in one of the US regions, you have the option of specifying what size Snow device
     * you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.
     * </p>
     * <p>
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
     * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
     * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
     * Capacity) in the <i>Snowcone User Guide</i>.
     * </p>
     * 
     * @param snowballCapacityPreference
     *        If your job is being created in one of the US regions, you have the option of specifying what size Snow
     *        device you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.</p>
     *        <p>
     *        For more information, see
     *        "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices
     *        and Capacity) in the <i>Snowcone User Guide</i> or
     *        "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices
     *        and Capacity) in the <i>Snowcone User Guide</i>.
     * @see SnowballCapacity
     */

    public void setSnowballCapacityPreference(SnowballCapacity snowballCapacityPreference) {
        withSnowballCapacityPreference(snowballCapacityPreference);
    }

    /**
     * <p>
     * If your job is being created in one of the US regions, you have the option of specifying what size Snow device
     * you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.
     * </p>
     * <p>
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
     * (Snow Family Devices and Capacity) in the <i>Snowcone User Guide</i> or
     * "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and
     * Capacity) in the <i>Snowcone User Guide</i>.
     * </p>
     * 
     * @param snowballCapacityPreference
     *        If your job is being created in one of the US regions, you have the option of specifying what size Snow
     *        device you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.</p>
     *        <p>
     *        For more information, see
     *        "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices
     *        and Capacity) in the <i>Snowcone User Guide</i> or
     *        "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices
     *        and Capacity) in the <i>Snowcone User Guide</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SnowballCapacity
     */

    public CreateClusterRequest withSnowballCapacityPreference(SnowballCapacity snowballCapacityPreference) {
        this.snowballCapacityPreference = snowballCapacityPreference.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getJobType() != null)
            sb.append("JobType: ").append(getJobType()).append(",");
        if (getResources() != null)
            sb.append("Resources: ").append(getResources()).append(",");
        if (getOnDeviceServiceConfiguration() != null)
            sb.append("OnDeviceServiceConfiguration: ").append(getOnDeviceServiceConfiguration()).append(",");
        if (getDescription() != null)
            sb.append("Description: ").append(getDescription()).append(",");
        if (getAddressId() != null)
            sb.append("AddressId: ").append(getAddressId()).append(",");
        if (getKmsKeyARN() != null)
            sb.append("KmsKeyARN: ").append(getKmsKeyARN()).append(",");
        if (getRoleARN() != null)
            sb.append("RoleARN: ").append(getRoleARN()).append(",");
        if (getSnowballType() != null)
            sb.append("SnowballType: ").append(getSnowballType()).append(",");
        if (getShippingOption() != null)
            sb.append("ShippingOption: ").append(getShippingOption()).append(",");
        if (getNotification() != null)
            sb.append("Notification: ").append(getNotification()).append(",");
        if (getForwardingAddressId() != null)
            sb.append("ForwardingAddressId: ").append(getForwardingAddressId()).append(",");
        if (getTaxDocuments() != null)
            sb.append("TaxDocuments: ").append(getTaxDocuments()).append(",");
        if (getRemoteManagement() != null)
            sb.append("RemoteManagement: ").append(getRemoteManagement()).append(",");
        if (getInitialClusterSize() != null)
            sb.append("InitialClusterSize: ").append(getInitialClusterSize()).append(",");
        if (getForceCreateJobs() != null)
            sb.append("ForceCreateJobs: ").append(getForceCreateJobs()).append(",");
        if (getLongTermPricingIds() != null)
            sb.append("LongTermPricingIds: ").append(getLongTermPricingIds()).append(",");
        if (getSnowballCapacityPreference() != null)
            sb.append("SnowballCapacityPreference: ").append(getSnowballCapacityPreference());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateClusterRequest == false)
            return false;
        CreateClusterRequest other = (CreateClusterRequest) obj;
        if (other.getJobType() == null ^ this.getJobType() == null)
            return false;
        if (other.getJobType() != null && other.getJobType().equals(this.getJobType()) == false)
            return false;
        if (other.getResources() == null ^ this.getResources() == null)
            return false;
        if (other.getResources() != null && other.getResources().equals(this.getResources()) == false)
            return false;
        if (other.getOnDeviceServiceConfiguration() == null ^ this.getOnDeviceServiceConfiguration() == null)
            return false;
        if (other.getOnDeviceServiceConfiguration() != null && other.getOnDeviceServiceConfiguration().equals(this.getOnDeviceServiceConfiguration()) == false)
            return false;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getAddressId() == null ^ this.getAddressId() == null)
            return false;
        if (other.getAddressId() != null && other.getAddressId().equals(this.getAddressId()) == false)
            return false;
        if (other.getKmsKeyARN() == null ^ this.getKmsKeyARN() == null)
            return false;
        if (other.getKmsKeyARN() != null && other.getKmsKeyARN().equals(this.getKmsKeyARN()) == false)
            return false;
        if (other.getRoleARN() == null ^ this.getRoleARN() == null)
            return false;
        if (other.getRoleARN() != null && other.getRoleARN().equals(this.getRoleARN()) == false)
            return false;
        if (other.getSnowballType() == null ^ this.getSnowballType() == null)
            return false;
        if (other.getSnowballType() != null && other.getSnowballType().equals(this.getSnowballType()) == false)
            return false;
        if (other.getShippingOption() == null ^ this.getShippingOption() == null)
            return false;
        if (other.getShippingOption() != null && other.getShippingOption().equals(this.getShippingOption()) == false)
            return false;
        if (other.getNotification() == null ^ this.getNotification() == null)
            return false;
        if (other.getNotification() != null && other.getNotification().equals(this.getNotification()) == false)
            return false;
        if (other.getForwardingAddressId() == null ^ this.getForwardingAddressId() == null)
            return false;
        if (other.getForwardingAddressId() != null && other.getForwardingAddressId().equals(this.getForwardingAddressId()) == false)
            return false;
        if (other.getTaxDocuments() == null ^ this.getTaxDocuments() == null)
            return false;
        if (other.getTaxDocuments() != null && other.getTaxDocuments().equals(this.getTaxDocuments()) == false)
            return false;
        if (other.getRemoteManagement() == null ^ this.getRemoteManagement() == null)
            return false;
        if (other.getRemoteManagement() != null && other.getRemoteManagement().equals(this.getRemoteManagement()) == false)
            return false;
        if (other.getInitialClusterSize() == null ^ this.getInitialClusterSize() == null)
            return false;
        if (other.getInitialClusterSize() != null && other.getInitialClusterSize().equals(this.getInitialClusterSize()) == false)
            return false;
        if (other.getForceCreateJobs() == null ^ this.getForceCreateJobs() == null)
            return false;
        if (other.getForceCreateJobs() != null && other.getForceCreateJobs().equals(this.getForceCreateJobs()) == false)
            return false;
        if (other.getLongTermPricingIds() == null ^ this.getLongTermPricingIds() == null)
            return false;
        if (other.getLongTermPricingIds() != null && other.getLongTermPricingIds().equals(this.getLongTermPricingIds()) == false)
            return false;
        if (other.getSnowballCapacityPreference() == null ^ this.getSnowballCapacityPreference() == null)
            return false;
        if (other.getSnowballCapacityPreference() != null && other.getSnowballCapacityPreference().equals(this.getSnowballCapacityPreference()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getJobType() == null) ? 0 : getJobType().hashCode());
        hashCode = prime * hashCode + ((getResources() == null) ? 0 : getResources().hashCode());
        hashCode = prime * hashCode + ((getOnDeviceServiceConfiguration() == null) ? 0 : getOnDeviceServiceConfiguration().hashCode());
        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode + ((getAddressId() == null) ? 0 : getAddressId().hashCode());
        hashCode = prime * hashCode + ((getKmsKeyARN() == null) ? 0 : getKmsKeyARN().hashCode());
        hashCode = prime * hashCode + ((getRoleARN() == null) ? 0 : getRoleARN().hashCode());
        hashCode = prime * hashCode + ((getSnowballType() == null) ? 0 : getSnowballType().hashCode());
        hashCode = prime * hashCode + ((getShippingOption() == null) ? 0 : getShippingOption().hashCode());
        hashCode = prime * hashCode + ((getNotification() == null) ? 0 : getNotification().hashCode());
        hashCode = prime * hashCode + ((getForwardingAddressId() == null) ? 0 : getForwardingAddressId().hashCode());
        hashCode = prime * hashCode + ((getTaxDocuments() == null) ? 0 : getTaxDocuments().hashCode());
        hashCode = prime * hashCode + ((getRemoteManagement() == null) ? 0 : getRemoteManagement().hashCode());
        hashCode = prime * hashCode + ((getInitialClusterSize() == null) ? 0 : getInitialClusterSize().hashCode());
        hashCode = prime * hashCode + ((getForceCreateJobs() == null) ? 0 : getForceCreateJobs().hashCode());
        hashCode = prime * hashCode + ((getLongTermPricingIds() == null) ? 0 : getLongTermPricingIds().hashCode());
        hashCode = prime * hashCode + ((getSnowballCapacityPreference() == null) ? 0 : getSnowballCapacityPreference().hashCode());
        return hashCode;
    }

    @Override
    public CreateClusterRequest clone() {
        return (CreateClusterRequest) super.clone();
    }

}
