/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.snowball.model.Ec2AmiResource;
import com.amazonaws.services.snowball.model.LambdaResource;
import com.amazonaws.services.snowball.model.S3Resource;
import com.amazonaws.services.snowball.model.transform.JobResourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JobResource
implements Serializable,
Cloneable,
StructuredPojo {
    private List<S3Resource> s3Resources;
    private List<LambdaResource> lambdaResources;
    private List<Ec2AmiResource> ec2AmiResources;

    public List<S3Resource> getS3Resources() {
        return this.s3Resources;
    }

    public void setS3Resources(Collection<S3Resource> s3Resources) {
        if (s3Resources == null) {
            this.s3Resources = null;
            return;
        }
        this.s3Resources = new ArrayList<S3Resource>(s3Resources);
    }

    public JobResource withS3Resources(S3Resource ... s3Resources) {
        if (this.s3Resources == null) {
            this.setS3Resources(new ArrayList<S3Resource>(s3Resources.length));
        }
        for (S3Resource ele : s3Resources) {
            this.s3Resources.add(ele);
        }
        return this;
    }

    public JobResource withS3Resources(Collection<S3Resource> s3Resources) {
        this.setS3Resources(s3Resources);
        return this;
    }

    public List<LambdaResource> getLambdaResources() {
        return this.lambdaResources;
    }

    public void setLambdaResources(Collection<LambdaResource> lambdaResources) {
        if (lambdaResources == null) {
            this.lambdaResources = null;
            return;
        }
        this.lambdaResources = new ArrayList<LambdaResource>(lambdaResources);
    }

    public JobResource withLambdaResources(LambdaResource ... lambdaResources) {
        if (this.lambdaResources == null) {
            this.setLambdaResources(new ArrayList<LambdaResource>(lambdaResources.length));
        }
        for (LambdaResource ele : lambdaResources) {
            this.lambdaResources.add(ele);
        }
        return this;
    }

    public JobResource withLambdaResources(Collection<LambdaResource> lambdaResources) {
        this.setLambdaResources(lambdaResources);
        return this;
    }

    public List<Ec2AmiResource> getEc2AmiResources() {
        return this.ec2AmiResources;
    }

    public void setEc2AmiResources(Collection<Ec2AmiResource> ec2AmiResources) {
        if (ec2AmiResources == null) {
            this.ec2AmiResources = null;
            return;
        }
        this.ec2AmiResources = new ArrayList<Ec2AmiResource>(ec2AmiResources);
    }

    public JobResource withEc2AmiResources(Ec2AmiResource ... ec2AmiResources) {
        if (this.ec2AmiResources == null) {
            this.setEc2AmiResources(new ArrayList<Ec2AmiResource>(ec2AmiResources.length));
        }
        for (Ec2AmiResource ele : ec2AmiResources) {
            this.ec2AmiResources.add(ele);
        }
        return this;
    }

    public JobResource withEc2AmiResources(Collection<Ec2AmiResource> ec2AmiResources) {
        this.setEc2AmiResources(ec2AmiResources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getS3Resources() != null) {
            sb.append("S3Resources: ").append(this.getS3Resources()).append(",");
        }
        if (this.getLambdaResources() != null) {
            sb.append("LambdaResources: ").append(this.getLambdaResources()).append(",");
        }
        if (this.getEc2AmiResources() != null) {
            sb.append("Ec2AmiResources: ").append(this.getEc2AmiResources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobResource)) {
            return false;
        }
        JobResource other = (JobResource)obj;
        if (other.getS3Resources() == null ^ this.getS3Resources() == null) {
            return false;
        }
        if (other.getS3Resources() != null && !other.getS3Resources().equals(this.getS3Resources())) {
            return false;
        }
        if (other.getLambdaResources() == null ^ this.getLambdaResources() == null) {
            return false;
        }
        if (other.getLambdaResources() != null && !other.getLambdaResources().equals(this.getLambdaResources())) {
            return false;
        }
        if (other.getEc2AmiResources() == null ^ this.getEc2AmiResources() == null) {
            return false;
        }
        return other.getEc2AmiResources() == null || other.getEc2AmiResources().equals(this.getEc2AmiResources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getS3Resources() == null ? 0 : this.getS3Resources().hashCode());
        hashCode = 31 * hashCode + (this.getLambdaResources() == null ? 0 : this.getLambdaResources().hashCode());
        hashCode = 31 * hashCode + (this.getEc2AmiResources() == null ? 0 : this.getEc2AmiResources().hashCode());
        return hashCode;
    }

    public JobResource clone() {
        try {
            return (JobResource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

