/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflowClientBuilder;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflowClientConfigurationFactory;
import com.amazonaws.services.simpleworkflow.model.ActivityTask;
import com.amazonaws.services.simpleworkflow.model.ActivityTaskStatus;
import com.amazonaws.services.simpleworkflow.model.ActivityTypeDetail;
import com.amazonaws.services.simpleworkflow.model.ActivityTypeInfos;
import com.amazonaws.services.simpleworkflow.model.AmazonSimpleWorkflowException;
import com.amazonaws.services.simpleworkflow.model.CountClosedWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.CountOpenWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.CountPendingActivityTasksRequest;
import com.amazonaws.services.simpleworkflow.model.CountPendingDecisionTasksRequest;
import com.amazonaws.services.simpleworkflow.model.DecisionTask;
import com.amazonaws.services.simpleworkflow.model.DeprecateActivityTypeRequest;
import com.amazonaws.services.simpleworkflow.model.DeprecateDomainRequest;
import com.amazonaws.services.simpleworkflow.model.DeprecateWorkflowTypeRequest;
import com.amazonaws.services.simpleworkflow.model.DescribeActivityTypeRequest;
import com.amazonaws.services.simpleworkflow.model.DescribeDomainRequest;
import com.amazonaws.services.simpleworkflow.model.DescribeWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.DescribeWorkflowTypeRequest;
import com.amazonaws.services.simpleworkflow.model.DomainDetail;
import com.amazonaws.services.simpleworkflow.model.DomainInfos;
import com.amazonaws.services.simpleworkflow.model.GetWorkflowExecutionHistoryRequest;
import com.amazonaws.services.simpleworkflow.model.History;
import com.amazonaws.services.simpleworkflow.model.ListActivityTypesRequest;
import com.amazonaws.services.simpleworkflow.model.ListClosedWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.ListDomainsRequest;
import com.amazonaws.services.simpleworkflow.model.ListOpenWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.ListTagsForResourceOutput;
import com.amazonaws.services.simpleworkflow.model.ListTagsForResourceRequest;
import com.amazonaws.services.simpleworkflow.model.ListWorkflowTypesRequest;
import com.amazonaws.services.simpleworkflow.model.PendingTaskCount;
import com.amazonaws.services.simpleworkflow.model.PollForActivityTaskRequest;
import com.amazonaws.services.simpleworkflow.model.PollForDecisionTaskRequest;
import com.amazonaws.services.simpleworkflow.model.RecordActivityTaskHeartbeatRequest;
import com.amazonaws.services.simpleworkflow.model.RegisterActivityTypeRequest;
import com.amazonaws.services.simpleworkflow.model.RegisterDomainRequest;
import com.amazonaws.services.simpleworkflow.model.RegisterWorkflowTypeRequest;
import com.amazonaws.services.simpleworkflow.model.RequestCancelWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskCanceledRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskCompletedRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskFailedRequest;
import com.amazonaws.services.simpleworkflow.model.RespondDecisionTaskCompletedRequest;
import com.amazonaws.services.simpleworkflow.model.Run;
import com.amazonaws.services.simpleworkflow.model.SignalWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.StartWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.TagResourceRequest;
import com.amazonaws.services.simpleworkflow.model.TerminateWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.UndeprecateActivityTypeRequest;
import com.amazonaws.services.simpleworkflow.model.UndeprecateDomainRequest;
import com.amazonaws.services.simpleworkflow.model.UndeprecateWorkflowTypeRequest;
import com.amazonaws.services.simpleworkflow.model.UntagResourceRequest;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionCount;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionDetail;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionInfos;
import com.amazonaws.services.simpleworkflow.model.WorkflowTypeDetail;
import com.amazonaws.services.simpleworkflow.model.WorkflowTypeInfos;
import com.amazonaws.services.simpleworkflow.model.transform.ActivityTaskJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ActivityTaskStatusJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ActivityTypeDetailJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ActivityTypeInfosJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.CountClosedWorkflowExecutionsRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.CountOpenWorkflowExecutionsRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.CountPendingActivityTasksRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.CountPendingDecisionTasksRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DecisionTaskJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DefaultUndefinedExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DeprecateActivityTypeRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DeprecateDomainRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DeprecateWorkflowTypeRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DescribeActivityTypeRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DescribeDomainRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DescribeWorkflowExecutionRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DescribeWorkflowTypeRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DomainAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DomainDeprecatedExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DomainDetailJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DomainInfosJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.GetWorkflowExecutionHistoryRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.HistoryJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ListActivityTypesRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ListClosedWorkflowExecutionsRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ListDomainsRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ListOpenWorkflowExecutionsRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ListTagsForResourceOutputJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ListWorkflowTypesRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.OperationNotPermittedExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.PendingTaskCountJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.PollForActivityTaskRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.PollForDecisionTaskRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RecordActivityTaskHeartbeatRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RegisterActivityTypeRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RegisterDomainRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RegisterWorkflowTypeRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RequestCancelWorkflowExecutionRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RespondActivityTaskCanceledRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RespondActivityTaskCompletedRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RespondActivityTaskFailedRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RespondDecisionTaskCompletedRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RunJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.SignalWorkflowExecutionRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.StartWorkflowExecutionRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.TerminateWorkflowExecutionRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.TooManyTagsExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.TypeAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.TypeDeprecatedExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.UndeprecateActivityTypeRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.UndeprecateDomainRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.UndeprecateWorkflowTypeRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.UnknownResourceExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowExecutionAlreadyStartedExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowExecutionCountJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowExecutionDetailJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowExecutionInfosJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowTypeDetailJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowTypeInfosJsonUnmarshaller;
import com.amazonaws.transform.JsonBaseExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonSimpleWorkflowClient
extends AmazonWebServiceClient
implements AmazonSimpleWorkflow {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonSimpleWorkflow.class);
    private static final String DEFAULT_SIGNING_NAME = "swf";
    protected static final AmazonSimpleWorkflowClientConfigurationFactory configFactory = new AmazonSimpleWorkflowClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.0").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DomainAlreadyExistsFault").withExceptionUnmarshaller((JsonErrorUnmarshaller)DomainAlreadyExistsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TypeAlreadyExistsFault").withExceptionUnmarshaller((JsonErrorUnmarshaller)TypeAlreadyExistsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OperationNotPermittedFault").withExceptionUnmarshaller((JsonErrorUnmarshaller)OperationNotPermittedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TypeDeprecatedFault").withExceptionUnmarshaller((JsonErrorUnmarshaller)TypeDeprecatedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededFault").withExceptionUnmarshaller((JsonErrorUnmarshaller)LimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("WorkflowExecutionAlreadyStartedFault").withExceptionUnmarshaller((JsonErrorUnmarshaller)WorkflowExecutionAlreadyStartedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyTagsFault").withExceptionUnmarshaller((JsonErrorUnmarshaller)TooManyTagsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnknownResourceFault").withExceptionUnmarshaller((JsonErrorUnmarshaller)UnknownResourceExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DomainDeprecatedFault").withExceptionUnmarshaller((JsonErrorUnmarshaller)DomainDeprecatedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DefaultUndefinedFault").withExceptionUnmarshaller((JsonErrorUnmarshaller)DefaultUndefinedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode(null).withExceptionUnmarshaller((JsonErrorUnmarshaller)new JsonBaseExceptionUnmarshaller(AmazonSimpleWorkflowException.class))));

    @Deprecated
    public AmazonSimpleWorkflowClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AmazonSimpleWorkflowClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AmazonSimpleWorkflowClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AmazonSimpleWorkflowClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    @Deprecated
    public AmazonSimpleWorkflowClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AmazonSimpleWorkflowClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AmazonSimpleWorkflowClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.advancedConfig = AdvancedConfig.EMPTY;
        this.init();
    }

    public static AmazonSimpleWorkflowClientBuilder builder() {
        return AmazonSimpleWorkflowClientBuilder.standard();
    }

    AmazonSimpleWorkflowClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonSimpleWorkflowClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("swf.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/simpleworkflow/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/simpleworkflow/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public WorkflowExecutionCount countClosedWorkflowExecutions(CountClosedWorkflowExecutionsRequest request) {
        request = (CountClosedWorkflowExecutionsRequest)this.beforeClientExecution(request);
        return this.executeCountClosedWorkflowExecutions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final WorkflowExecutionCount executeCountClosedWorkflowExecutions(CountClosedWorkflowExecutionsRequest countClosedWorkflowExecutionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(countClosedWorkflowExecutionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CountClosedWorkflowExecutionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CountClosedWorkflowExecutionsRequestProtocolMarshaller(protocolFactory).marshall((CountClosedWorkflowExecutionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)countClosedWorkflowExecutionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CountClosedWorkflowExecutions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new WorkflowExecutionCountJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            WorkflowExecutionCount workflowExecutionCount = (WorkflowExecutionCount)response.getAwsResponse();
            return workflowExecutionCount;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public WorkflowExecutionCount countOpenWorkflowExecutions(CountOpenWorkflowExecutionsRequest request) {
        request = (CountOpenWorkflowExecutionsRequest)this.beforeClientExecution(request);
        return this.executeCountOpenWorkflowExecutions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final WorkflowExecutionCount executeCountOpenWorkflowExecutions(CountOpenWorkflowExecutionsRequest countOpenWorkflowExecutionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(countOpenWorkflowExecutionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CountOpenWorkflowExecutionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CountOpenWorkflowExecutionsRequestProtocolMarshaller(protocolFactory).marshall((CountOpenWorkflowExecutionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)countOpenWorkflowExecutionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CountOpenWorkflowExecutions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new WorkflowExecutionCountJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            WorkflowExecutionCount workflowExecutionCount = (WorkflowExecutionCount)response.getAwsResponse();
            return workflowExecutionCount;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PendingTaskCount countPendingActivityTasks(CountPendingActivityTasksRequest request) {
        request = (CountPendingActivityTasksRequest)this.beforeClientExecution(request);
        return this.executeCountPendingActivityTasks(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PendingTaskCount executeCountPendingActivityTasks(CountPendingActivityTasksRequest countPendingActivityTasksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(countPendingActivityTasksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CountPendingActivityTasksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CountPendingActivityTasksRequestProtocolMarshaller(protocolFactory).marshall((CountPendingActivityTasksRequest)super.beforeMarshalling((AmazonWebServiceRequest)countPendingActivityTasksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CountPendingActivityTasks");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PendingTaskCountJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PendingTaskCount pendingTaskCount = (PendingTaskCount)response.getAwsResponse();
            return pendingTaskCount;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PendingTaskCount countPendingDecisionTasks(CountPendingDecisionTasksRequest request) {
        request = (CountPendingDecisionTasksRequest)this.beforeClientExecution(request);
        return this.executeCountPendingDecisionTasks(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PendingTaskCount executeCountPendingDecisionTasks(CountPendingDecisionTasksRequest countPendingDecisionTasksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(countPendingDecisionTasksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CountPendingDecisionTasksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CountPendingDecisionTasksRequestProtocolMarshaller(protocolFactory).marshall((CountPendingDecisionTasksRequest)super.beforeMarshalling((AmazonWebServiceRequest)countPendingDecisionTasksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CountPendingDecisionTasks");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PendingTaskCountJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PendingTaskCount pendingTaskCount = (PendingTaskCount)response.getAwsResponse();
            return pendingTaskCount;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public void deprecateActivityType(DeprecateActivityTypeRequest request) {
        request = (DeprecateActivityTypeRequest)this.beforeClientExecution(request);
        this.executeDeprecateActivityType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final void executeDeprecateActivityType(DeprecateActivityTypeRequest deprecateActivityTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deprecateActivityTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeprecateActivityTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeprecateActivityTypeRequestProtocolMarshaller(protocolFactory).marshall((DeprecateActivityTypeRequest)super.beforeMarshalling((AmazonWebServiceRequest)deprecateActivityTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeprecateActivityType");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public void deprecateDomain(DeprecateDomainRequest request) {
        request = (DeprecateDomainRequest)this.beforeClientExecution(request);
        this.executeDeprecateDomain(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final void executeDeprecateDomain(DeprecateDomainRequest deprecateDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deprecateDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeprecateDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeprecateDomainRequestProtocolMarshaller(protocolFactory).marshall((DeprecateDomainRequest)super.beforeMarshalling((AmazonWebServiceRequest)deprecateDomainRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeprecateDomain");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public void deprecateWorkflowType(DeprecateWorkflowTypeRequest request) {
        request = (DeprecateWorkflowTypeRequest)this.beforeClientExecution(request);
        this.executeDeprecateWorkflowType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final void executeDeprecateWorkflowType(DeprecateWorkflowTypeRequest deprecateWorkflowTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deprecateWorkflowTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeprecateWorkflowTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeprecateWorkflowTypeRequestProtocolMarshaller(protocolFactory).marshall((DeprecateWorkflowTypeRequest)super.beforeMarshalling((AmazonWebServiceRequest)deprecateWorkflowTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeprecateWorkflowType");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ActivityTypeDetail describeActivityType(DescribeActivityTypeRequest request) {
        request = (DescribeActivityTypeRequest)this.beforeClientExecution(request);
        return this.executeDescribeActivityType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ActivityTypeDetail executeDescribeActivityType(DescribeActivityTypeRequest describeActivityTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeActivityTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeActivityTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeActivityTypeRequestProtocolMarshaller(protocolFactory).marshall((DescribeActivityTypeRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeActivityTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeActivityType");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ActivityTypeDetailJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ActivityTypeDetail activityTypeDetail = (ActivityTypeDetail)response.getAwsResponse();
            return activityTypeDetail;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DomainDetail describeDomain(DescribeDomainRequest request) {
        request = (DescribeDomainRequest)this.beforeClientExecution(request);
        return this.executeDescribeDomain(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DomainDetail executeDescribeDomain(DescribeDomainRequest describeDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDomainRequestProtocolMarshaller(protocolFactory).marshall((DescribeDomainRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeDomainRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeDomain");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DomainDetailJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DomainDetail domainDetail = (DomainDetail)response.getAwsResponse();
            return domainDetail;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public WorkflowExecutionDetail describeWorkflowExecution(DescribeWorkflowExecutionRequest request) {
        request = (DescribeWorkflowExecutionRequest)this.beforeClientExecution(request);
        return this.executeDescribeWorkflowExecution(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final WorkflowExecutionDetail executeDescribeWorkflowExecution(DescribeWorkflowExecutionRequest describeWorkflowExecutionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeWorkflowExecutionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeWorkflowExecutionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeWorkflowExecutionRequestProtocolMarshaller(protocolFactory).marshall((DescribeWorkflowExecutionRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeWorkflowExecutionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeWorkflowExecution");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new WorkflowExecutionDetailJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            WorkflowExecutionDetail workflowExecutionDetail = (WorkflowExecutionDetail)response.getAwsResponse();
            return workflowExecutionDetail;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public WorkflowTypeDetail describeWorkflowType(DescribeWorkflowTypeRequest request) {
        request = (DescribeWorkflowTypeRequest)this.beforeClientExecution(request);
        return this.executeDescribeWorkflowType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final WorkflowTypeDetail executeDescribeWorkflowType(DescribeWorkflowTypeRequest describeWorkflowTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeWorkflowTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeWorkflowTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeWorkflowTypeRequestProtocolMarshaller(protocolFactory).marshall((DescribeWorkflowTypeRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeWorkflowTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeWorkflowType");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new WorkflowTypeDetailJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            WorkflowTypeDetail workflowTypeDetail = (WorkflowTypeDetail)response.getAwsResponse();
            return workflowTypeDetail;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public History getWorkflowExecutionHistory(GetWorkflowExecutionHistoryRequest request) {
        request = (GetWorkflowExecutionHistoryRequest)this.beforeClientExecution(request);
        return this.executeGetWorkflowExecutionHistory(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final History executeGetWorkflowExecutionHistory(GetWorkflowExecutionHistoryRequest getWorkflowExecutionHistoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getWorkflowExecutionHistoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetWorkflowExecutionHistoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetWorkflowExecutionHistoryRequestProtocolMarshaller(protocolFactory).marshall((GetWorkflowExecutionHistoryRequest)super.beforeMarshalling((AmazonWebServiceRequest)getWorkflowExecutionHistoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetWorkflowExecutionHistory");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new HistoryJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            History history = (History)response.getAwsResponse();
            return history;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ActivityTypeInfos listActivityTypes(ListActivityTypesRequest request) {
        request = (ListActivityTypesRequest)this.beforeClientExecution(request);
        return this.executeListActivityTypes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ActivityTypeInfos executeListActivityTypes(ListActivityTypesRequest listActivityTypesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listActivityTypesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListActivityTypesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListActivityTypesRequestProtocolMarshaller(protocolFactory).marshall((ListActivityTypesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listActivityTypesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListActivityTypes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ActivityTypeInfosJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ActivityTypeInfos activityTypeInfos = (ActivityTypeInfos)response.getAwsResponse();
            return activityTypeInfos;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public WorkflowExecutionInfos listClosedWorkflowExecutions(ListClosedWorkflowExecutionsRequest request) {
        request = (ListClosedWorkflowExecutionsRequest)this.beforeClientExecution(request);
        return this.executeListClosedWorkflowExecutions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final WorkflowExecutionInfos executeListClosedWorkflowExecutions(ListClosedWorkflowExecutionsRequest listClosedWorkflowExecutionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listClosedWorkflowExecutionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListClosedWorkflowExecutionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListClosedWorkflowExecutionsRequestProtocolMarshaller(protocolFactory).marshall((ListClosedWorkflowExecutionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listClosedWorkflowExecutionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListClosedWorkflowExecutions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new WorkflowExecutionInfosJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            WorkflowExecutionInfos workflowExecutionInfos = (WorkflowExecutionInfos)response.getAwsResponse();
            return workflowExecutionInfos;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DomainInfos listDomains(ListDomainsRequest request) {
        request = (ListDomainsRequest)this.beforeClientExecution(request);
        return this.executeListDomains(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DomainInfos executeListDomains(ListDomainsRequest listDomainsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDomainsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDomainsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDomainsRequestProtocolMarshaller(protocolFactory).marshall((ListDomainsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDomainsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDomains");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DomainInfosJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DomainInfos domainInfos = (DomainInfos)response.getAwsResponse();
            return domainInfos;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public WorkflowExecutionInfos listOpenWorkflowExecutions(ListOpenWorkflowExecutionsRequest request) {
        request = (ListOpenWorkflowExecutionsRequest)this.beforeClientExecution(request);
        return this.executeListOpenWorkflowExecutions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final WorkflowExecutionInfos executeListOpenWorkflowExecutions(ListOpenWorkflowExecutionsRequest listOpenWorkflowExecutionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listOpenWorkflowExecutionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListOpenWorkflowExecutionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListOpenWorkflowExecutionsRequestProtocolMarshaller(protocolFactory).marshall((ListOpenWorkflowExecutionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listOpenWorkflowExecutionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListOpenWorkflowExecutions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new WorkflowExecutionInfosJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            WorkflowExecutionInfos workflowExecutionInfos = (WorkflowExecutionInfos)response.getAwsResponse();
            return workflowExecutionInfos;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceOutput listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceOutput executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceOutputJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceOutput listTagsForResourceOutput = (ListTagsForResourceOutput)response.getAwsResponse();
            return listTagsForResourceOutput;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public WorkflowTypeInfos listWorkflowTypes(ListWorkflowTypesRequest request) {
        request = (ListWorkflowTypesRequest)this.beforeClientExecution(request);
        return this.executeListWorkflowTypes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final WorkflowTypeInfos executeListWorkflowTypes(ListWorkflowTypesRequest listWorkflowTypesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listWorkflowTypesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListWorkflowTypesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListWorkflowTypesRequestProtocolMarshaller(protocolFactory).marshall((ListWorkflowTypesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listWorkflowTypesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListWorkflowTypes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new WorkflowTypeInfosJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            WorkflowTypeInfos workflowTypeInfos = (WorkflowTypeInfos)response.getAwsResponse();
            return workflowTypeInfos;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ActivityTask pollForActivityTask(PollForActivityTaskRequest request) {
        request = (PollForActivityTaskRequest)this.beforeClientExecution(request);
        return this.executePollForActivityTask(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ActivityTask executePollForActivityTask(PollForActivityTaskRequest pollForActivityTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(pollForActivityTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PollForActivityTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PollForActivityTaskRequestProtocolMarshaller(protocolFactory).marshall((PollForActivityTaskRequest)super.beforeMarshalling((AmazonWebServiceRequest)pollForActivityTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PollForActivityTask");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ActivityTaskJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ActivityTask activityTask = (ActivityTask)response.getAwsResponse();
            return activityTask;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DecisionTask pollForDecisionTask(PollForDecisionTaskRequest request) {
        request = (PollForDecisionTaskRequest)this.beforeClientExecution(request);
        return this.executePollForDecisionTask(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DecisionTask executePollForDecisionTask(PollForDecisionTaskRequest pollForDecisionTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(pollForDecisionTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PollForDecisionTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PollForDecisionTaskRequestProtocolMarshaller(protocolFactory).marshall((PollForDecisionTaskRequest)super.beforeMarshalling((AmazonWebServiceRequest)pollForDecisionTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PollForDecisionTask");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DecisionTaskJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DecisionTask decisionTask = (DecisionTask)response.getAwsResponse();
            return decisionTask;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ActivityTaskStatus recordActivityTaskHeartbeat(RecordActivityTaskHeartbeatRequest request) {
        request = (RecordActivityTaskHeartbeatRequest)this.beforeClientExecution(request);
        return this.executeRecordActivityTaskHeartbeat(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ActivityTaskStatus executeRecordActivityTaskHeartbeat(RecordActivityTaskHeartbeatRequest recordActivityTaskHeartbeatRequest) {
        ExecutionContext executionContext = this.createExecutionContext(recordActivityTaskHeartbeatRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RecordActivityTaskHeartbeatRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RecordActivityTaskHeartbeatRequestProtocolMarshaller(protocolFactory).marshall((RecordActivityTaskHeartbeatRequest)super.beforeMarshalling((AmazonWebServiceRequest)recordActivityTaskHeartbeatRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RecordActivityTaskHeartbeat");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ActivityTaskStatusJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ActivityTaskStatus activityTaskStatus = (ActivityTaskStatus)response.getAwsResponse();
            return activityTaskStatus;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public void registerActivityType(RegisterActivityTypeRequest request) {
        request = (RegisterActivityTypeRequest)this.beforeClientExecution(request);
        this.executeRegisterActivityType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final void executeRegisterActivityType(RegisterActivityTypeRequest registerActivityTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerActivityTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterActivityTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterActivityTypeRequestProtocolMarshaller(protocolFactory).marshall((RegisterActivityTypeRequest)super.beforeMarshalling((AmazonWebServiceRequest)registerActivityTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RegisterActivityType");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public void registerDomain(RegisterDomainRequest request) {
        request = (RegisterDomainRequest)this.beforeClientExecution(request);
        this.executeRegisterDomain(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final void executeRegisterDomain(RegisterDomainRequest registerDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterDomainRequestProtocolMarshaller(protocolFactory).marshall((RegisterDomainRequest)super.beforeMarshalling((AmazonWebServiceRequest)registerDomainRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RegisterDomain");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public void registerWorkflowType(RegisterWorkflowTypeRequest request) {
        request = (RegisterWorkflowTypeRequest)this.beforeClientExecution(request);
        this.executeRegisterWorkflowType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final void executeRegisterWorkflowType(RegisterWorkflowTypeRequest registerWorkflowTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerWorkflowTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterWorkflowTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterWorkflowTypeRequestProtocolMarshaller(protocolFactory).marshall((RegisterWorkflowTypeRequest)super.beforeMarshalling((AmazonWebServiceRequest)registerWorkflowTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RegisterWorkflowType");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public void requestCancelWorkflowExecution(RequestCancelWorkflowExecutionRequest request) {
        request = (RequestCancelWorkflowExecutionRequest)this.beforeClientExecution(request);
        this.executeRequestCancelWorkflowExecution(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final void executeRequestCancelWorkflowExecution(RequestCancelWorkflowExecutionRequest requestCancelWorkflowExecutionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(requestCancelWorkflowExecutionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RequestCancelWorkflowExecutionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RequestCancelWorkflowExecutionRequestProtocolMarshaller(protocolFactory).marshall((RequestCancelWorkflowExecutionRequest)super.beforeMarshalling((AmazonWebServiceRequest)requestCancelWorkflowExecutionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RequestCancelWorkflowExecution");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public void respondActivityTaskCanceled(RespondActivityTaskCanceledRequest request) {
        request = (RespondActivityTaskCanceledRequest)this.beforeClientExecution(request);
        this.executeRespondActivityTaskCanceled(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final void executeRespondActivityTaskCanceled(RespondActivityTaskCanceledRequest respondActivityTaskCanceledRequest) {
        ExecutionContext executionContext = this.createExecutionContext(respondActivityTaskCanceledRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RespondActivityTaskCanceledRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RespondActivityTaskCanceledRequestProtocolMarshaller(protocolFactory).marshall((RespondActivityTaskCanceledRequest)super.beforeMarshalling((AmazonWebServiceRequest)respondActivityTaskCanceledRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RespondActivityTaskCanceled");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public void respondActivityTaskCompleted(RespondActivityTaskCompletedRequest request) {
        request = (RespondActivityTaskCompletedRequest)this.beforeClientExecution(request);
        this.executeRespondActivityTaskCompleted(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final void executeRespondActivityTaskCompleted(RespondActivityTaskCompletedRequest respondActivityTaskCompletedRequest) {
        ExecutionContext executionContext = this.createExecutionContext(respondActivityTaskCompletedRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RespondActivityTaskCompletedRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RespondActivityTaskCompletedRequestProtocolMarshaller(protocolFactory).marshall((RespondActivityTaskCompletedRequest)super.beforeMarshalling((AmazonWebServiceRequest)respondActivityTaskCompletedRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RespondActivityTaskCompleted");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public void respondActivityTaskFailed(RespondActivityTaskFailedRequest request) {
        request = (RespondActivityTaskFailedRequest)this.beforeClientExecution(request);
        this.executeRespondActivityTaskFailed(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final void executeRespondActivityTaskFailed(RespondActivityTaskFailedRequest respondActivityTaskFailedRequest) {
        ExecutionContext executionContext = this.createExecutionContext(respondActivityTaskFailedRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RespondActivityTaskFailedRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RespondActivityTaskFailedRequestProtocolMarshaller(protocolFactory).marshall((RespondActivityTaskFailedRequest)super.beforeMarshalling((AmazonWebServiceRequest)respondActivityTaskFailedRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RespondActivityTaskFailed");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public void respondDecisionTaskCompleted(RespondDecisionTaskCompletedRequest request) {
        request = (RespondDecisionTaskCompletedRequest)this.beforeClientExecution(request);
        this.executeRespondDecisionTaskCompleted(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final void executeRespondDecisionTaskCompleted(RespondDecisionTaskCompletedRequest respondDecisionTaskCompletedRequest) {
        ExecutionContext executionContext = this.createExecutionContext(respondDecisionTaskCompletedRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RespondDecisionTaskCompletedRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RespondDecisionTaskCompletedRequestProtocolMarshaller(protocolFactory).marshall((RespondDecisionTaskCompletedRequest)super.beforeMarshalling((AmazonWebServiceRequest)respondDecisionTaskCompletedRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RespondDecisionTaskCompleted");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public void signalWorkflowExecution(SignalWorkflowExecutionRequest request) {
        request = (SignalWorkflowExecutionRequest)this.beforeClientExecution(request);
        this.executeSignalWorkflowExecution(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final void executeSignalWorkflowExecution(SignalWorkflowExecutionRequest signalWorkflowExecutionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(signalWorkflowExecutionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SignalWorkflowExecutionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SignalWorkflowExecutionRequestProtocolMarshaller(protocolFactory).marshall((SignalWorkflowExecutionRequest)super.beforeMarshalling((AmazonWebServiceRequest)signalWorkflowExecutionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"SignalWorkflowExecution");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public Run startWorkflowExecution(StartWorkflowExecutionRequest request) {
        request = (StartWorkflowExecutionRequest)this.beforeClientExecution(request);
        return this.executeStartWorkflowExecution(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final Run executeStartWorkflowExecution(StartWorkflowExecutionRequest startWorkflowExecutionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startWorkflowExecutionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartWorkflowExecutionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartWorkflowExecutionRequestProtocolMarshaller(protocolFactory).marshall((StartWorkflowExecutionRequest)super.beforeMarshalling((AmazonWebServiceRequest)startWorkflowExecutionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartWorkflowExecution");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RunJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            Run run = (Run)response.getAwsResponse();
            return run;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public void tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final void executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public void terminateWorkflowExecution(TerminateWorkflowExecutionRequest request) {
        request = (TerminateWorkflowExecutionRequest)this.beforeClientExecution(request);
        this.executeTerminateWorkflowExecution(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final void executeTerminateWorkflowExecution(TerminateWorkflowExecutionRequest terminateWorkflowExecutionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(terminateWorkflowExecutionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TerminateWorkflowExecutionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TerminateWorkflowExecutionRequestProtocolMarshaller(protocolFactory).marshall((TerminateWorkflowExecutionRequest)super.beforeMarshalling((AmazonWebServiceRequest)terminateWorkflowExecutionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TerminateWorkflowExecution");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public void undeprecateActivityType(UndeprecateActivityTypeRequest request) {
        request = (UndeprecateActivityTypeRequest)this.beforeClientExecution(request);
        this.executeUndeprecateActivityType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final void executeUndeprecateActivityType(UndeprecateActivityTypeRequest undeprecateActivityTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(undeprecateActivityTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UndeprecateActivityTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UndeprecateActivityTypeRequestProtocolMarshaller(protocolFactory).marshall((UndeprecateActivityTypeRequest)super.beforeMarshalling((AmazonWebServiceRequest)undeprecateActivityTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UndeprecateActivityType");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public void undeprecateDomain(UndeprecateDomainRequest request) {
        request = (UndeprecateDomainRequest)this.beforeClientExecution(request);
        this.executeUndeprecateDomain(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final void executeUndeprecateDomain(UndeprecateDomainRequest undeprecateDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(undeprecateDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UndeprecateDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UndeprecateDomainRequestProtocolMarshaller(protocolFactory).marshall((UndeprecateDomainRequest)super.beforeMarshalling((AmazonWebServiceRequest)undeprecateDomainRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UndeprecateDomain");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public void undeprecateWorkflowType(UndeprecateWorkflowTypeRequest request) {
        request = (UndeprecateWorkflowTypeRequest)this.beforeClientExecution(request);
        this.executeUndeprecateWorkflowType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final void executeUndeprecateWorkflowType(UndeprecateWorkflowTypeRequest undeprecateWorkflowTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(undeprecateWorkflowTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UndeprecateWorkflowTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UndeprecateWorkflowTypeRequestProtocolMarshaller(protocolFactory).marshall((UndeprecateWorkflowTypeRequest)super.beforeMarshalling((AmazonWebServiceRequest)undeprecateWorkflowTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UndeprecateWorkflowType");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public void untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final void executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SWF");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), null);
            this.invoke(request, responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

