/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.simpledb.model.ListDomainsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListDomainsRequestMarshaller
implements Marshaller<Request<ListDomainsRequest>, ListDomainsRequest> {
    public Request<ListDomainsRequest> marshall(ListDomainsRequest listDomainsRequest) {
        if (listDomainsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listDomainsRequest, "AmazonSimpleDB");
        request.addParameter("Action", "ListDomains");
        request.addParameter("Version", "2009-04-15");
        if (listDomainsRequest.getMaxNumberOfDomains() != null) {
            request.addParameter("MaxNumberOfDomains", StringUtils.fromInteger((Integer)listDomainsRequest.getMaxNumberOfDomains()));
        }
        if (listDomainsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)listDomainsRequest.getNextToken()));
        }
        return request;
    }
}

