/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.signer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.signer.model.S3SignedObject;

@SdkInternalApi
public class S3SignedObjectMarshaller {
    private static final MarshallingInfo<String> BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucketName").build();
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("key").build();
    private static final S3SignedObjectMarshaller instance = new S3SignedObjectMarshaller();

    public static S3SignedObjectMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3SignedObject s3SignedObject, ProtocolMarshaller protocolMarshaller) {
        if (s3SignedObject == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3SignedObject.getBucketName(), BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)s3SignedObject.getKey(), KEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

