/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.shield.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.shield.model.TimeRange;

public class TimeRangeJsonMarshaller {
    private static TimeRangeJsonMarshaller instance;

    public void marshall(TimeRange timeRange, StructuredJsonGenerator jsonGenerator) {
        if (timeRange == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (timeRange.getFromInclusive() != null) {
                jsonGenerator.writeFieldName("FromInclusive").writeValue(timeRange.getFromInclusive());
            }
            if (timeRange.getToExclusive() != null) {
                jsonGenerator.writeFieldName("ToExclusive").writeValue(timeRange.getToExclusive());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TimeRangeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TimeRangeJsonMarshaller();
        }
        return instance;
    }
}

