/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.shield.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.shield.model.Subscription;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class SubscriptionMarshaller {
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Long> TIMECOMMITMENTINSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeCommitmentInSeconds").build();
    private static final MarshallingInfo<String> AUTORENEW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoRenew").build();
    private static final MarshallingInfo<List> LIMITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Limits").build();
    private static final MarshallingInfo<String> PROACTIVEENGAGEMENTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProactiveEngagementStatus").build();
    private static final MarshallingInfo<StructuredPojo> SUBSCRIPTIONLIMITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubscriptionLimits").build();
    private static final SubscriptionMarshaller instance = new SubscriptionMarshaller();

    public static SubscriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(Subscription subscription, ProtocolMarshaller protocolMarshaller) {
        if (subscription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)subscription.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)subscription.getEndTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)subscription.getTimeCommitmentInSeconds(), TIMECOMMITMENTINSECONDS_BINDING);
            protocolMarshaller.marshall((Object)subscription.getAutoRenew(), AUTORENEW_BINDING);
            protocolMarshaller.marshall(subscription.getLimits(), LIMITS_BINDING);
            protocolMarshaller.marshall((Object)subscription.getProactiveEngagementStatus(), PROACTIVEENGAGEMENTSTATUS_BINDING);
            protocolMarshaller.marshall((Object)subscription.getSubscriptionLimits(), SUBSCRIPTIONLIMITS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

