/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.shield.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.shield.model.AutoRenew;
import com.amazonaws.services.shield.model.Limit;
import com.amazonaws.services.shield.model.ProactiveEngagementStatus;
import com.amazonaws.services.shield.model.transform.SubscriptionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Subscription
implements Serializable,
Cloneable,
StructuredPojo {
    private Date startTime;
    private Date endTime;
    private Long timeCommitmentInSeconds;
    private String autoRenew;
    private List<Limit> limits;
    private String proactiveEngagementStatus;

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Subscription withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Subscription withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setTimeCommitmentInSeconds(Long timeCommitmentInSeconds) {
        this.timeCommitmentInSeconds = timeCommitmentInSeconds;
    }

    public Long getTimeCommitmentInSeconds() {
        return this.timeCommitmentInSeconds;
    }

    public Subscription withTimeCommitmentInSeconds(Long timeCommitmentInSeconds) {
        this.setTimeCommitmentInSeconds(timeCommitmentInSeconds);
        return this;
    }

    public void setAutoRenew(String autoRenew) {
        this.autoRenew = autoRenew;
    }

    public String getAutoRenew() {
        return this.autoRenew;
    }

    public Subscription withAutoRenew(String autoRenew) {
        this.setAutoRenew(autoRenew);
        return this;
    }

    public Subscription withAutoRenew(AutoRenew autoRenew) {
        this.autoRenew = autoRenew.toString();
        return this;
    }

    public List<Limit> getLimits() {
        return this.limits;
    }

    public void setLimits(Collection<Limit> limits) {
        if (limits == null) {
            this.limits = null;
            return;
        }
        this.limits = new ArrayList<Limit>(limits);
    }

    public Subscription withLimits(Limit ... limits) {
        if (this.limits == null) {
            this.setLimits(new ArrayList<Limit>(limits.length));
        }
        for (Limit ele : limits) {
            this.limits.add(ele);
        }
        return this;
    }

    public Subscription withLimits(Collection<Limit> limits) {
        this.setLimits(limits);
        return this;
    }

    public void setProactiveEngagementStatus(String proactiveEngagementStatus) {
        this.proactiveEngagementStatus = proactiveEngagementStatus;
    }

    public String getProactiveEngagementStatus() {
        return this.proactiveEngagementStatus;
    }

    public Subscription withProactiveEngagementStatus(String proactiveEngagementStatus) {
        this.setProactiveEngagementStatus(proactiveEngagementStatus);
        return this;
    }

    public Subscription withProactiveEngagementStatus(ProactiveEngagementStatus proactiveEngagementStatus) {
        this.proactiveEngagementStatus = proactiveEngagementStatus.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getTimeCommitmentInSeconds() != null) {
            sb.append("TimeCommitmentInSeconds: ").append(this.getTimeCommitmentInSeconds()).append(",");
        }
        if (this.getAutoRenew() != null) {
            sb.append("AutoRenew: ").append(this.getAutoRenew()).append(",");
        }
        if (this.getLimits() != null) {
            sb.append("Limits: ").append(this.getLimits()).append(",");
        }
        if (this.getProactiveEngagementStatus() != null) {
            sb.append("ProactiveEngagementStatus: ").append(this.getProactiveEngagementStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription)obj;
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getTimeCommitmentInSeconds() == null ^ this.getTimeCommitmentInSeconds() == null) {
            return false;
        }
        if (other.getTimeCommitmentInSeconds() != null && !other.getTimeCommitmentInSeconds().equals(this.getTimeCommitmentInSeconds())) {
            return false;
        }
        if (other.getAutoRenew() == null ^ this.getAutoRenew() == null) {
            return false;
        }
        if (other.getAutoRenew() != null && !other.getAutoRenew().equals(this.getAutoRenew())) {
            return false;
        }
        if (other.getLimits() == null ^ this.getLimits() == null) {
            return false;
        }
        if (other.getLimits() != null && !other.getLimits().equals(this.getLimits())) {
            return false;
        }
        if (other.getProactiveEngagementStatus() == null ^ this.getProactiveEngagementStatus() == null) {
            return false;
        }
        return other.getProactiveEngagementStatus() == null || other.getProactiveEngagementStatus().equals(this.getProactiveEngagementStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getTimeCommitmentInSeconds() == null ? 0 : this.getTimeCommitmentInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getAutoRenew() == null ? 0 : this.getAutoRenew().hashCode());
        hashCode = 31 * hashCode + (this.getLimits() == null ? 0 : this.getLimits().hashCode());
        hashCode = 31 * hashCode + (this.getProactiveEngagementStatus() == null ? 0 : this.getProactiveEngagementStatus().hashCode());
        return hashCode;
    }

    public Subscription clone() {
        try {
            return (Subscription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SubscriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

