/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.shield.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.shield.model.SubResourceSummary;
import com.amazonaws.services.shield.model.SummarizedAttackVector;
import com.amazonaws.services.shield.model.SummarizedCounter;
import com.amazonaws.services.shield.model.transform.SummarizedAttackVectorJsonMarshaller;
import com.amazonaws.services.shield.model.transform.SummarizedCounterJsonMarshaller;
import java.util.List;

public class SubResourceSummaryJsonMarshaller {
    private static SubResourceSummaryJsonMarshaller instance;

    public void marshall(SubResourceSummary subResourceSummary, StructuredJsonGenerator jsonGenerator) {
        if (subResourceSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<SummarizedCounter> countersList;
            List<SummarizedAttackVector> attackVectorsList;
            jsonGenerator.writeStartObject();
            if (subResourceSummary.getType() != null) {
                jsonGenerator.writeFieldName("Type").writeValue(subResourceSummary.getType());
            }
            if (subResourceSummary.getId() != null) {
                jsonGenerator.writeFieldName("Id").writeValue(subResourceSummary.getId());
            }
            if ((attackVectorsList = subResourceSummary.getAttackVectors()) != null) {
                jsonGenerator.writeFieldName("AttackVectors");
                jsonGenerator.writeStartArray();
                for (SummarizedAttackVector attackVectorsListValue : attackVectorsList) {
                    if (attackVectorsListValue == null) continue;
                    SummarizedAttackVectorJsonMarshaller.getInstance().marshall(attackVectorsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((countersList = subResourceSummary.getCounters()) != null) {
                jsonGenerator.writeFieldName("Counters");
                jsonGenerator.writeStartArray();
                for (SummarizedCounter countersListValue : countersList) {
                    if (countersListValue == null) continue;
                    SummarizedCounterJsonMarshaller.getInstance().marshall(countersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SubResourceSummaryJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SubResourceSummaryJsonMarshaller();
        }
        return instance;
    }
}

