/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.shield;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.shield.AWSShield;
import com.amazonaws.services.shield.model.AWSShieldException;
import com.amazonaws.services.shield.model.CreateProtectionRequest;
import com.amazonaws.services.shield.model.CreateProtectionResult;
import com.amazonaws.services.shield.model.CreateSubscriptionRequest;
import com.amazonaws.services.shield.model.CreateSubscriptionResult;
import com.amazonaws.services.shield.model.DeleteProtectionRequest;
import com.amazonaws.services.shield.model.DeleteProtectionResult;
import com.amazonaws.services.shield.model.DeleteSubscriptionRequest;
import com.amazonaws.services.shield.model.DeleteSubscriptionResult;
import com.amazonaws.services.shield.model.DescribeAttackRequest;
import com.amazonaws.services.shield.model.DescribeAttackResult;
import com.amazonaws.services.shield.model.DescribeProtectionRequest;
import com.amazonaws.services.shield.model.DescribeProtectionResult;
import com.amazonaws.services.shield.model.DescribeSubscriptionRequest;
import com.amazonaws.services.shield.model.DescribeSubscriptionResult;
import com.amazonaws.services.shield.model.InternalErrorException;
import com.amazonaws.services.shield.model.InvalidOperationException;
import com.amazonaws.services.shield.model.InvalidParameterException;
import com.amazonaws.services.shield.model.InvalidResourceException;
import com.amazonaws.services.shield.model.LimitsExceededException;
import com.amazonaws.services.shield.model.ListAttacksRequest;
import com.amazonaws.services.shield.model.ListAttacksResult;
import com.amazonaws.services.shield.model.ListProtectionsRequest;
import com.amazonaws.services.shield.model.ListProtectionsResult;
import com.amazonaws.services.shield.model.LockedSubscriptionException;
import com.amazonaws.services.shield.model.OptimisticLockException;
import com.amazonaws.services.shield.model.ResourceAlreadyExistsException;
import com.amazonaws.services.shield.model.ResourceNotFoundException;
import com.amazonaws.services.shield.model.transform.CreateProtectionRequestMarshaller;
import com.amazonaws.services.shield.model.transform.CreateProtectionResultJsonUnmarshaller;
import com.amazonaws.services.shield.model.transform.CreateSubscriptionRequestMarshaller;
import com.amazonaws.services.shield.model.transform.CreateSubscriptionResultJsonUnmarshaller;
import com.amazonaws.services.shield.model.transform.DeleteProtectionRequestMarshaller;
import com.amazonaws.services.shield.model.transform.DeleteProtectionResultJsonUnmarshaller;
import com.amazonaws.services.shield.model.transform.DeleteSubscriptionRequestMarshaller;
import com.amazonaws.services.shield.model.transform.DeleteSubscriptionResultJsonUnmarshaller;
import com.amazonaws.services.shield.model.transform.DescribeAttackRequestMarshaller;
import com.amazonaws.services.shield.model.transform.DescribeAttackResultJsonUnmarshaller;
import com.amazonaws.services.shield.model.transform.DescribeProtectionRequestMarshaller;
import com.amazonaws.services.shield.model.transform.DescribeProtectionResultJsonUnmarshaller;
import com.amazonaws.services.shield.model.transform.DescribeSubscriptionRequestMarshaller;
import com.amazonaws.services.shield.model.transform.DescribeSubscriptionResultJsonUnmarshaller;
import com.amazonaws.services.shield.model.transform.ListAttacksRequestMarshaller;
import com.amazonaws.services.shield.model.transform.ListAttacksResultJsonUnmarshaller;
import com.amazonaws.services.shield.model.transform.ListProtectionsRequestMarshaller;
import com.amazonaws.services.shield.model.transform.ListProtectionsResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSShieldClient
extends AmazonWebServiceClient
implements AWSShield {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSShield.class);
    private static final String DEFAULT_SIGNING_NAME = "shield";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OptimisticLockException").withModeledClass(OptimisticLockException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LockedSubscriptionException").withModeledClass(LockedSubscriptionException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidResourceException").withModeledClass(InvalidResourceException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withModeledClass(InvalidParameterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidOperationException").withModeledClass(InvalidOperationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceAlreadyExistsException").withModeledClass(ResourceAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalErrorException").withModeledClass(InternalErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitsExceededException").withModeledClass(LimitsExceededException.class)).withBaseServiceExceptionClass(AWSShieldException.class));

    public AWSShieldClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    public AWSShieldClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    public AWSShieldClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    public AWSShieldClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSShieldClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    public AWSShieldClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AWSShieldClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    AWSShieldClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("shield.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/shield/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/shield/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateProtectionResult createProtection(CreateProtectionRequest createProtectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createProtectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateProtectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateProtectionRequestMarshaller(this.protocolFactory).marshall((CreateProtectionRequest)super.beforeMarshalling((AmazonWebServiceRequest)createProtectionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateProtectionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateProtectionResult createProtectionResult = (CreateProtectionResult)response.getAwsResponse();
            return createProtectionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSubscriptionResult createSubscription(CreateSubscriptionRequest createSubscriptionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createSubscriptionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateSubscriptionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateSubscriptionRequestMarshaller(this.protocolFactory).marshall((CreateSubscriptionRequest)super.beforeMarshalling((AmazonWebServiceRequest)createSubscriptionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateSubscriptionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateSubscriptionResult createSubscriptionResult = (CreateSubscriptionResult)response.getAwsResponse();
            return createSubscriptionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteProtectionResult deleteProtection(DeleteProtectionRequest deleteProtectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteProtectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteProtectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteProtectionRequestMarshaller(this.protocolFactory).marshall((DeleteProtectionRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteProtectionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteProtectionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteProtectionResult deleteProtectionResult = (DeleteProtectionResult)response.getAwsResponse();
            return deleteProtectionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSubscriptionResult deleteSubscription(DeleteSubscriptionRequest deleteSubscriptionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSubscriptionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSubscriptionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSubscriptionRequestMarshaller(this.protocolFactory).marshall((DeleteSubscriptionRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteSubscriptionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteSubscriptionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSubscriptionResult deleteSubscriptionResult = (DeleteSubscriptionResult)response.getAwsResponse();
            return deleteSubscriptionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAttackResult describeAttack(DescribeAttackRequest describeAttackRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAttackRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAttackRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAttackRequestMarshaller(this.protocolFactory).marshall((DescribeAttackRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAttackRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAttackResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAttackResult describeAttackResult = (DescribeAttackResult)response.getAwsResponse();
            return describeAttackResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeProtectionResult describeProtection(DescribeProtectionRequest describeProtectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeProtectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeProtectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeProtectionRequestMarshaller(this.protocolFactory).marshall((DescribeProtectionRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeProtectionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeProtectionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeProtectionResult describeProtectionResult = (DescribeProtectionResult)response.getAwsResponse();
            return describeProtectionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSubscriptionResult describeSubscription(DescribeSubscriptionRequest describeSubscriptionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeSubscriptionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeSubscriptionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeSubscriptionRequestMarshaller(this.protocolFactory).marshall((DescribeSubscriptionRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeSubscriptionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeSubscriptionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeSubscriptionResult describeSubscriptionResult = (DescribeSubscriptionResult)response.getAwsResponse();
            return describeSubscriptionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAttacksResult listAttacks(ListAttacksRequest listAttacksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAttacksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAttacksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAttacksRequestMarshaller(this.protocolFactory).marshall((ListAttacksRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAttacksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAttacksResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAttacksResult listAttacksResult = (ListAttacksResult)response.getAwsResponse();
            return listAttacksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListProtectionsResult listProtections(ListProtectionsRequest listProtectionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listProtectionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListProtectionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListProtectionsRequestMarshaller(this.protocolFactory).marshall((ListProtectionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listProtectionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListProtectionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListProtectionsResult listProtectionsResult = (ListProtectionsResult)response.getAwsResponse();
            return listProtectionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

