/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.simpleemail.model.AddHeaderAction;
import com.amazonaws.services.simpleemail.model.BounceAction;
import com.amazonaws.services.simpleemail.model.CreateReceiptRuleRequest;
import com.amazonaws.services.simpleemail.model.LambdaAction;
import com.amazonaws.services.simpleemail.model.ReceiptAction;
import com.amazonaws.services.simpleemail.model.ReceiptRule;
import com.amazonaws.services.simpleemail.model.S3Action;
import com.amazonaws.services.simpleemail.model.SNSAction;
import com.amazonaws.services.simpleemail.model.StopAction;
import com.amazonaws.services.simpleemail.model.WorkmailAction;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateReceiptRuleRequestMarshaller
implements Marshaller<Request<CreateReceiptRuleRequest>, CreateReceiptRuleRequest> {
    public Request<CreateReceiptRuleRequest> marshall(CreateReceiptRuleRequest createReceiptRuleRequest) {
        ReceiptRule receiptRuleRule;
        if (createReceiptRuleRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createReceiptRuleRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "CreateReceiptRule");
        request.addParameter("Version", "2010-12-01");
        if (createReceiptRuleRequest.getRuleSetName() != null) {
            request.addParameter("RuleSetName", StringUtils.fromString((String)createReceiptRuleRequest.getRuleSetName()));
        }
        if (createReceiptRuleRequest.getAfter() != null) {
            request.addParameter("After", StringUtils.fromString((String)createReceiptRuleRequest.getAfter()));
        }
        if ((receiptRuleRule = createReceiptRuleRequest.getRule()) != null) {
            if (receiptRuleRule.getName() != null) {
                request.addParameter("Rule.Name", StringUtils.fromString((String)receiptRuleRule.getName()));
            }
            if (receiptRuleRule.isEnabled() != null) {
                request.addParameter("Rule.Enabled", StringUtils.fromBoolean((Boolean)receiptRuleRule.isEnabled()));
            }
            if (receiptRuleRule.getTlsPolicy() != null) {
                request.addParameter("Rule.TlsPolicy", StringUtils.fromString((String)receiptRuleRule.getTlsPolicy()));
            }
            List<String> recipientsList = receiptRuleRule.getRecipients();
            int recipientsListIndex = 1;
            for (String recipientsListValue : recipientsList) {
                if (recipientsListValue != null) {
                    request.addParameter("Rule.Recipients.member." + recipientsListIndex, StringUtils.fromString((String)recipientsListValue));
                }
                ++recipientsListIndex;
            }
            List<ReceiptAction> actionsList = receiptRuleRule.getActions();
            int actionsListIndex = 1;
            for (ReceiptAction actionsListValue : actionsList) {
                ReceiptAction receiptActionMember = actionsListValue;
                if (receiptActionMember != null) {
                    SNSAction sNSActionSNSAction;
                    AddHeaderAction addHeaderActionAddHeaderAction;
                    StopAction stopActionStopAction;
                    LambdaAction lambdaActionLambdaAction;
                    WorkmailAction workmailActionWorkmailAction;
                    BounceAction bounceActionBounceAction;
                    S3Action s3ActionS3Action = receiptActionMember.getS3Action();
                    if (s3ActionS3Action != null) {
                        if (s3ActionS3Action.getTopicArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".S3Action.TopicArn", StringUtils.fromString((String)s3ActionS3Action.getTopicArn()));
                        }
                        if (s3ActionS3Action.getBucketName() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".S3Action.BucketName", StringUtils.fromString((String)s3ActionS3Action.getBucketName()));
                        }
                        if (s3ActionS3Action.getObjectKeyPrefix() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".S3Action.ObjectKeyPrefix", StringUtils.fromString((String)s3ActionS3Action.getObjectKeyPrefix()));
                        }
                        if (s3ActionS3Action.getKmsKeyArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".S3Action.KmsKeyArn", StringUtils.fromString((String)s3ActionS3Action.getKmsKeyArn()));
                        }
                    }
                    if ((bounceActionBounceAction = receiptActionMember.getBounceAction()) != null) {
                        if (bounceActionBounceAction.getTopicArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.TopicArn", StringUtils.fromString((String)bounceActionBounceAction.getTopicArn()));
                        }
                        if (bounceActionBounceAction.getSmtpReplyCode() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.SmtpReplyCode", StringUtils.fromString((String)bounceActionBounceAction.getSmtpReplyCode()));
                        }
                        if (bounceActionBounceAction.getStatusCode() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.StatusCode", StringUtils.fromString((String)bounceActionBounceAction.getStatusCode()));
                        }
                        if (bounceActionBounceAction.getMessage() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.Message", StringUtils.fromString((String)bounceActionBounceAction.getMessage()));
                        }
                        if (bounceActionBounceAction.getSender() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.Sender", StringUtils.fromString((String)bounceActionBounceAction.getSender()));
                        }
                    }
                    if ((workmailActionWorkmailAction = receiptActionMember.getWorkmailAction()) != null) {
                        if (workmailActionWorkmailAction.getTopicArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".WorkmailAction.TopicArn", StringUtils.fromString((String)workmailActionWorkmailAction.getTopicArn()));
                        }
                        if (workmailActionWorkmailAction.getOrganizationArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".WorkmailAction.OrganizationArn", StringUtils.fromString((String)workmailActionWorkmailAction.getOrganizationArn()));
                        }
                    }
                    if ((lambdaActionLambdaAction = receiptActionMember.getLambdaAction()) != null) {
                        if (lambdaActionLambdaAction.getTopicArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".LambdaAction.TopicArn", StringUtils.fromString((String)lambdaActionLambdaAction.getTopicArn()));
                        }
                        if (lambdaActionLambdaAction.getFunctionArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".LambdaAction.FunctionArn", StringUtils.fromString((String)lambdaActionLambdaAction.getFunctionArn()));
                        }
                        if (lambdaActionLambdaAction.getInvocationType() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".LambdaAction.InvocationType", StringUtils.fromString((String)lambdaActionLambdaAction.getInvocationType()));
                        }
                    }
                    if ((stopActionStopAction = receiptActionMember.getStopAction()) != null) {
                        if (stopActionStopAction.getScope() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".StopAction.Scope", StringUtils.fromString((String)stopActionStopAction.getScope()));
                        }
                        if (stopActionStopAction.getTopicArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".StopAction.TopicArn", StringUtils.fromString((String)stopActionStopAction.getTopicArn()));
                        }
                    }
                    if ((addHeaderActionAddHeaderAction = receiptActionMember.getAddHeaderAction()) != null) {
                        if (addHeaderActionAddHeaderAction.getHeaderName() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".AddHeaderAction.HeaderName", StringUtils.fromString((String)addHeaderActionAddHeaderAction.getHeaderName()));
                        }
                        if (addHeaderActionAddHeaderAction.getHeaderValue() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".AddHeaderAction.HeaderValue", StringUtils.fromString((String)addHeaderActionAddHeaderAction.getHeaderValue()));
                        }
                    }
                    if ((sNSActionSNSAction = receiptActionMember.getSNSAction()) != null && sNSActionSNSAction.getTopicArn() != null) {
                        request.addParameter("Rule.Actions.member." + actionsListIndex + ".SNSAction.TopicArn", StringUtils.fromString((String)sNSActionSNSAction.getTopicArn()));
                    }
                }
                ++actionsListIndex;
            }
            if (receiptRuleRule.isScanEnabled() != null) {
                request.addParameter("Rule.ScanEnabled", StringUtils.fromBoolean((Boolean)receiptRuleRule.isScanEnabled()));
            }
        }
        return request;
    }
}

