/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicediscovery.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.servicediscovery.model.HttpInstanceSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DiscoverInstancesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<HttpInstanceSummary> instances;
    private Long instancesRevision;

    public List<HttpInstanceSummary> getInstances() {
        return this.instances;
    }

    public void setInstances(Collection<HttpInstanceSummary> instances) {
        if (instances == null) {
            this.instances = null;
            return;
        }
        this.instances = new ArrayList<HttpInstanceSummary>(instances);
    }

    public DiscoverInstancesResult withInstances(HttpInstanceSummary ... instances) {
        if (this.instances == null) {
            this.setInstances(new ArrayList<HttpInstanceSummary>(instances.length));
        }
        for (HttpInstanceSummary ele : instances) {
            this.instances.add(ele);
        }
        return this;
    }

    public DiscoverInstancesResult withInstances(Collection<HttpInstanceSummary> instances) {
        this.setInstances(instances);
        return this;
    }

    public void setInstancesRevision(Long instancesRevision) {
        this.instancesRevision = instancesRevision;
    }

    public Long getInstancesRevision() {
        return this.instancesRevision;
    }

    public DiscoverInstancesResult withInstancesRevision(Long instancesRevision) {
        this.setInstancesRevision(instancesRevision);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstances() != null) {
            sb.append("Instances: ").append(this.getInstances()).append(",");
        }
        if (this.getInstancesRevision() != null) {
            sb.append("InstancesRevision: ").append(this.getInstancesRevision());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoverInstancesResult)) {
            return false;
        }
        DiscoverInstancesResult other = (DiscoverInstancesResult)obj;
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        if (other.getInstances() != null && !other.getInstances().equals(this.getInstances())) {
            return false;
        }
        if (other.getInstancesRevision() == null ^ this.getInstancesRevision() == null) {
            return false;
        }
        return other.getInstancesRevision() == null || other.getInstancesRevision().equals(this.getInstancesRevision());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : this.getInstances().hashCode());
        hashCode = 31 * hashCode + (this.getInstancesRevision() == null ? 0 : this.getInstancesRevision().hashCode());
        return hashCode;
    }

    public DiscoverInstancesResult clone() {
        try {
            return (DiscoverInstancesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

