/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.servicecatalog.model.ListLaunchPathsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListLaunchPathsRequestMarshaller
implements Marshaller<Request<ListLaunchPathsRequest>, ListLaunchPathsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListLaunchPathsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListLaunchPathsRequest> marshall(ListLaunchPathsRequest listLaunchPathsRequest) {
        if (listLaunchPathsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listLaunchPathsRequest, "AWSServiceCatalog");
        request.addHeader("X-Amz-Target", "AWS242ServiceCatalogService.ListLaunchPaths");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listLaunchPathsRequest.getAcceptLanguage() != null) {
                jsonGenerator.writeFieldName("AcceptLanguage").writeValue(listLaunchPathsRequest.getAcceptLanguage());
            }
            if (listLaunchPathsRequest.getProductId() != null) {
                jsonGenerator.writeFieldName("ProductId").writeValue(listLaunchPathsRequest.getProductId());
            }
            if (listLaunchPathsRequest.getPageSize() != null) {
                jsonGenerator.writeFieldName("PageSize").writeValue(listLaunchPathsRequest.getPageSize().intValue());
            }
            if (listLaunchPathsRequest.getPageToken() != null) {
                jsonGenerator.writeFieldName("PageToken").writeValue(listLaunchPathsRequest.getPageToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

