/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.servicecatalog.model.ListConstraintsForPortfolioRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListConstraintsForPortfolioRequestMarshaller
implements Marshaller<Request<ListConstraintsForPortfolioRequest>, ListConstraintsForPortfolioRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListConstraintsForPortfolioRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListConstraintsForPortfolioRequest> marshall(ListConstraintsForPortfolioRequest listConstraintsForPortfolioRequest) {
        if (listConstraintsForPortfolioRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listConstraintsForPortfolioRequest, "AWSServiceCatalog");
        request.addHeader("X-Amz-Target", "AWS242ServiceCatalogService.ListConstraintsForPortfolio");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listConstraintsForPortfolioRequest.getAcceptLanguage() != null) {
                jsonGenerator.writeFieldName("AcceptLanguage").writeValue(listConstraintsForPortfolioRequest.getAcceptLanguage());
            }
            if (listConstraintsForPortfolioRequest.getPortfolioId() != null) {
                jsonGenerator.writeFieldName("PortfolioId").writeValue(listConstraintsForPortfolioRequest.getPortfolioId());
            }
            if (listConstraintsForPortfolioRequest.getProductId() != null) {
                jsonGenerator.writeFieldName("ProductId").writeValue(listConstraintsForPortfolioRequest.getProductId());
            }
            if (listConstraintsForPortfolioRequest.getPageSize() != null) {
                jsonGenerator.writeFieldName("PageSize").writeValue(listConstraintsForPortfolioRequest.getPageSize().intValue());
            }
            if (listConstraintsForPortfolioRequest.getPageToken() != null) {
                jsonGenerator.writeFieldName("PageToken").writeValue(listConstraintsForPortfolioRequest.getPageToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

