/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servermigration.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.servermigration.model.LaunchDetails;
import java.util.Date;

@SdkInternalApi
public class LaunchDetailsMarshaller {
    private static final MarshallingInfo<Date> LATESTLAUNCHTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("latestLaunchTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> STACKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stackName").build();
    private static final MarshallingInfo<String> STACKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stackId").build();
    private static final LaunchDetailsMarshaller instance = new LaunchDetailsMarshaller();

    public static LaunchDetailsMarshaller getInstance() {
        return instance;
    }

    public void marshall(LaunchDetails launchDetails, ProtocolMarshaller protocolMarshaller) {
        if (launchDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)launchDetails.getLatestLaunchTime(), LATESTLAUNCHTIME_BINDING);
            protocolMarshaller.marshall((Object)launchDetails.getStackName(), STACKNAME_BINDING);
            protocolMarshaller.marshall((Object)launchDetails.getStackId(), STACKID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

