/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.serverlessapplicationrepository.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.serverlessapplicationrepository.model.VersionSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListApplicationVersionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<VersionSummary> versions;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListApplicationVersionsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<VersionSummary> getVersions() {
        return this.versions;
    }

    public void setVersions(Collection<VersionSummary> versions) {
        if (versions == null) {
            this.versions = null;
            return;
        }
        this.versions = new ArrayList<VersionSummary>(versions);
    }

    public ListApplicationVersionsResult withVersions(VersionSummary ... versions) {
        if (this.versions == null) {
            this.setVersions(new ArrayList<VersionSummary>(versions.length));
        }
        for (VersionSummary ele : versions) {
            this.versions.add(ele);
        }
        return this;
    }

    public ListApplicationVersionsResult withVersions(Collection<VersionSummary> versions) {
        this.setVersions(versions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getVersions() != null) {
            sb.append("Versions: ").append(this.getVersions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationVersionsResult)) {
            return false;
        }
        ListApplicationVersionsResult other = (ListApplicationVersionsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getVersions() == null ^ this.getVersions() == null) {
            return false;
        }
        return other.getVersions() == null || other.getVersions().equals(this.getVersions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getVersions() == null ? 0 : this.getVersions().hashCode());
        return hashCode;
    }

    public ListApplicationVersionsResult clone() {
        try {
            return (ListApplicationVersionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

