/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.serverlessapplicationrepository.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.serverlessapplicationrepository.model.ParameterDefinition;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.VersionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Version
implements Serializable,
Cloneable,
StructuredPojo {
    private String applicationId;
    private String creationTime;
    private List<ParameterDefinition> parameterDefinitions;
    private String semanticVersion;
    private String sourceCodeUrl;
    private String templateUrl;

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public Version withApplicationId(String applicationId) {
        this.setApplicationId(applicationId);
        return this;
    }

    public void setCreationTime(String creationTime) {
        this.creationTime = creationTime;
    }

    public String getCreationTime() {
        return this.creationTime;
    }

    public Version withCreationTime(String creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public List<ParameterDefinition> getParameterDefinitions() {
        return this.parameterDefinitions;
    }

    public void setParameterDefinitions(Collection<ParameterDefinition> parameterDefinitions) {
        if (parameterDefinitions == null) {
            this.parameterDefinitions = null;
            return;
        }
        this.parameterDefinitions = new ArrayList<ParameterDefinition>(parameterDefinitions);
    }

    public Version withParameterDefinitions(ParameterDefinition ... parameterDefinitions) {
        if (this.parameterDefinitions == null) {
            this.setParameterDefinitions(new ArrayList<ParameterDefinition>(parameterDefinitions.length));
        }
        for (ParameterDefinition ele : parameterDefinitions) {
            this.parameterDefinitions.add(ele);
        }
        return this;
    }

    public Version withParameterDefinitions(Collection<ParameterDefinition> parameterDefinitions) {
        this.setParameterDefinitions(parameterDefinitions);
        return this;
    }

    public void setSemanticVersion(String semanticVersion) {
        this.semanticVersion = semanticVersion;
    }

    public String getSemanticVersion() {
        return this.semanticVersion;
    }

    public Version withSemanticVersion(String semanticVersion) {
        this.setSemanticVersion(semanticVersion);
        return this;
    }

    public void setSourceCodeUrl(String sourceCodeUrl) {
        this.sourceCodeUrl = sourceCodeUrl;
    }

    public String getSourceCodeUrl() {
        return this.sourceCodeUrl;
    }

    public Version withSourceCodeUrl(String sourceCodeUrl) {
        this.setSourceCodeUrl(sourceCodeUrl);
        return this;
    }

    public void setTemplateUrl(String templateUrl) {
        this.templateUrl = templateUrl;
    }

    public String getTemplateUrl() {
        return this.templateUrl;
    }

    public Version withTemplateUrl(String templateUrl) {
        this.setTemplateUrl(templateUrl);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationId() != null) {
            sb.append("ApplicationId: ").append(this.getApplicationId()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getParameterDefinitions() != null) {
            sb.append("ParameterDefinitions: ").append(this.getParameterDefinitions()).append(",");
        }
        if (this.getSemanticVersion() != null) {
            sb.append("SemanticVersion: ").append(this.getSemanticVersion()).append(",");
        }
        if (this.getSourceCodeUrl() != null) {
            sb.append("SourceCodeUrl: ").append(this.getSourceCodeUrl()).append(",");
        }
        if (this.getTemplateUrl() != null) {
            sb.append("TemplateUrl: ").append(this.getTemplateUrl());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        Version other = (Version)obj;
        if (other.getApplicationId() == null ^ this.getApplicationId() == null) {
            return false;
        }
        if (other.getApplicationId() != null && !other.getApplicationId().equals(this.getApplicationId())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getParameterDefinitions() == null ^ this.getParameterDefinitions() == null) {
            return false;
        }
        if (other.getParameterDefinitions() != null && !other.getParameterDefinitions().equals(this.getParameterDefinitions())) {
            return false;
        }
        if (other.getSemanticVersion() == null ^ this.getSemanticVersion() == null) {
            return false;
        }
        if (other.getSemanticVersion() != null && !other.getSemanticVersion().equals(this.getSemanticVersion())) {
            return false;
        }
        if (other.getSourceCodeUrl() == null ^ this.getSourceCodeUrl() == null) {
            return false;
        }
        if (other.getSourceCodeUrl() != null && !other.getSourceCodeUrl().equals(this.getSourceCodeUrl())) {
            return false;
        }
        if (other.getTemplateUrl() == null ^ this.getTemplateUrl() == null) {
            return false;
        }
        return other.getTemplateUrl() == null || other.getTemplateUrl().equals(this.getTemplateUrl());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationId() == null ? 0 : this.getApplicationId().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getParameterDefinitions() == null ? 0 : this.getParameterDefinitions().hashCode());
        hashCode = 31 * hashCode + (this.getSemanticVersion() == null ? 0 : this.getSemanticVersion().hashCode());
        hashCode = 31 * hashCode + (this.getSourceCodeUrl() == null ? 0 : this.getSourceCodeUrl().hashCode());
        hashCode = 31 * hashCode + (this.getTemplateUrl() == null ? 0 : this.getTemplateUrl().hashCode());
        return hashCode;
    }

    public Version clone() {
        try {
            return (Version)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

