/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitylake.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securitylake.model.DataLakeSourceStatus;
import com.amazonaws.services.securitylake.model.transform.DataLakeSourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DataLakeSource
implements Serializable,
Cloneable,
StructuredPojo {
    private String account;
    private List<String> eventClasses;
    private String sourceName;
    private List<DataLakeSourceStatus> sourceStatuses;

    public void setAccount(String account) {
        this.account = account;
    }

    public String getAccount() {
        return this.account;
    }

    public DataLakeSource withAccount(String account) {
        this.setAccount(account);
        return this;
    }

    public List<String> getEventClasses() {
        return this.eventClasses;
    }

    public void setEventClasses(Collection<String> eventClasses) {
        if (eventClasses == null) {
            this.eventClasses = null;
            return;
        }
        this.eventClasses = new ArrayList<String>(eventClasses);
    }

    public DataLakeSource withEventClasses(String ... eventClasses) {
        if (this.eventClasses == null) {
            this.setEventClasses(new ArrayList<String>(eventClasses.length));
        }
        for (String ele : eventClasses) {
            this.eventClasses.add(ele);
        }
        return this;
    }

    public DataLakeSource withEventClasses(Collection<String> eventClasses) {
        this.setEventClasses(eventClasses);
        return this;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public DataLakeSource withSourceName(String sourceName) {
        this.setSourceName(sourceName);
        return this;
    }

    public List<DataLakeSourceStatus> getSourceStatuses() {
        return this.sourceStatuses;
    }

    public void setSourceStatuses(Collection<DataLakeSourceStatus> sourceStatuses) {
        if (sourceStatuses == null) {
            this.sourceStatuses = null;
            return;
        }
        this.sourceStatuses = new ArrayList<DataLakeSourceStatus>(sourceStatuses);
    }

    public DataLakeSource withSourceStatuses(DataLakeSourceStatus ... sourceStatuses) {
        if (this.sourceStatuses == null) {
            this.setSourceStatuses(new ArrayList<DataLakeSourceStatus>(sourceStatuses.length));
        }
        for (DataLakeSourceStatus ele : sourceStatuses) {
            this.sourceStatuses.add(ele);
        }
        return this;
    }

    public DataLakeSource withSourceStatuses(Collection<DataLakeSourceStatus> sourceStatuses) {
        this.setSourceStatuses(sourceStatuses);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccount() != null) {
            sb.append("Account: ").append(this.getAccount()).append(",");
        }
        if (this.getEventClasses() != null) {
            sb.append("EventClasses: ").append(this.getEventClasses()).append(",");
        }
        if (this.getSourceName() != null) {
            sb.append("SourceName: ").append(this.getSourceName()).append(",");
        }
        if (this.getSourceStatuses() != null) {
            sb.append("SourceStatuses: ").append(this.getSourceStatuses());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeSource)) {
            return false;
        }
        DataLakeSource other = (DataLakeSource)obj;
        if (other.getAccount() == null ^ this.getAccount() == null) {
            return false;
        }
        if (other.getAccount() != null && !other.getAccount().equals(this.getAccount())) {
            return false;
        }
        if (other.getEventClasses() == null ^ this.getEventClasses() == null) {
            return false;
        }
        if (other.getEventClasses() != null && !other.getEventClasses().equals(this.getEventClasses())) {
            return false;
        }
        if (other.getSourceName() == null ^ this.getSourceName() == null) {
            return false;
        }
        if (other.getSourceName() != null && !other.getSourceName().equals(this.getSourceName())) {
            return false;
        }
        if (other.getSourceStatuses() == null ^ this.getSourceStatuses() == null) {
            return false;
        }
        return other.getSourceStatuses() == null || other.getSourceStatuses().equals(this.getSourceStatuses());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccount() == null ? 0 : this.getAccount().hashCode());
        hashCode = 31 * hashCode + (this.getEventClasses() == null ? 0 : this.getEventClasses().hashCode());
        hashCode = 31 * hashCode + (this.getSourceName() == null ? 0 : this.getSourceName().hashCode());
        hashCode = 31 * hashCode + (this.getSourceStatuses() == null ? 0 : this.getSourceStatuses().hashCode());
        return hashCode;
    }

    public DataLakeSource clone() {
        try {
            return (DataLakeSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataLakeSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

