/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securitylake.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/CreateDataLake" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateDataLakeRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * Specify the Region or Regions that will contribute data to the rollup region.
     * </p>
     */
    private java.util.List<DataLakeConfiguration> configurations;
    /**
     * <p>
     * The Amazon Resource Name (ARN) used to create and update the Glue table. This table contains partitions generated
     * by the ingestion and normalization of Amazon Web Services log sources and custom sources.
     * </p>
     */
    private String metaStoreManagerRoleArn;
    /**
     * <p>
     * An array of objects, one for each tag to associate with the data lake configuration. For each tag, you must
     * specify both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.
     * </p>
     */
    private java.util.List<Tag> tags;

    /**
     * <p>
     * Specify the Region or Regions that will contribute data to the rollup region.
     * </p>
     * 
     * @return Specify the Region or Regions that will contribute data to the rollup region.
     */

    public java.util.List<DataLakeConfiguration> getConfigurations() {
        return configurations;
    }

    /**
     * <p>
     * Specify the Region or Regions that will contribute data to the rollup region.
     * </p>
     * 
     * @param configurations
     *        Specify the Region or Regions that will contribute data to the rollup region.
     */

    public void setConfigurations(java.util.Collection<DataLakeConfiguration> configurations) {
        if (configurations == null) {
            this.configurations = null;
            return;
        }

        this.configurations = new java.util.ArrayList<DataLakeConfiguration>(configurations);
    }

    /**
     * <p>
     * Specify the Region or Regions that will contribute data to the rollup region.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setConfigurations(java.util.Collection)} or {@link #withConfigurations(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param configurations
     *        Specify the Region or Regions that will contribute data to the rollup region.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateDataLakeRequest withConfigurations(DataLakeConfiguration... configurations) {
        if (this.configurations == null) {
            setConfigurations(new java.util.ArrayList<DataLakeConfiguration>(configurations.length));
        }
        for (DataLakeConfiguration ele : configurations) {
            this.configurations.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Specify the Region or Regions that will contribute data to the rollup region.
     * </p>
     * 
     * @param configurations
     *        Specify the Region or Regions that will contribute data to the rollup region.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateDataLakeRequest withConfigurations(java.util.Collection<DataLakeConfiguration> configurations) {
        setConfigurations(configurations);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) used to create and update the Glue table. This table contains partitions generated
     * by the ingestion and normalization of Amazon Web Services log sources and custom sources.
     * </p>
     * 
     * @param metaStoreManagerRoleArn
     *        The Amazon Resource Name (ARN) used to create and update the Glue table. This table contains partitions
     *        generated by the ingestion and normalization of Amazon Web Services log sources and custom sources.
     */

    public void setMetaStoreManagerRoleArn(String metaStoreManagerRoleArn) {
        this.metaStoreManagerRoleArn = metaStoreManagerRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) used to create and update the Glue table. This table contains partitions generated
     * by the ingestion and normalization of Amazon Web Services log sources and custom sources.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) used to create and update the Glue table. This table contains partitions
     *         generated by the ingestion and normalization of Amazon Web Services log sources and custom sources.
     */

    public String getMetaStoreManagerRoleArn() {
        return this.metaStoreManagerRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) used to create and update the Glue table. This table contains partitions generated
     * by the ingestion and normalization of Amazon Web Services log sources and custom sources.
     * </p>
     * 
     * @param metaStoreManagerRoleArn
     *        The Amazon Resource Name (ARN) used to create and update the Glue table. This table contains partitions
     *        generated by the ingestion and normalization of Amazon Web Services log sources and custom sources.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateDataLakeRequest withMetaStoreManagerRoleArn(String metaStoreManagerRoleArn) {
        setMetaStoreManagerRoleArn(metaStoreManagerRoleArn);
        return this;
    }

    /**
     * <p>
     * An array of objects, one for each tag to associate with the data lake configuration. For each tag, you must
     * specify both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.
     * </p>
     * 
     * @return An array of objects, one for each tag to associate with the data lake configuration. For each tag, you
     *         must specify both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.
     */

    public java.util.List<Tag> getTags() {
        return tags;
    }

    /**
     * <p>
     * An array of objects, one for each tag to associate with the data lake configuration. For each tag, you must
     * specify both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.
     * </p>
     * 
     * @param tags
     *        An array of objects, one for each tag to associate with the data lake configuration. For each tag, you
     *        must specify both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.
     */

    public void setTags(java.util.Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }

        this.tags = new java.util.ArrayList<Tag>(tags);
    }

    /**
     * <p>
     * An array of objects, one for each tag to associate with the data lake configuration. For each tag, you must
     * specify both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTags(java.util.Collection)} or {@link #withTags(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param tags
     *        An array of objects, one for each tag to associate with the data lake configuration. For each tag, you
     *        must specify both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateDataLakeRequest withTags(Tag... tags) {
        if (this.tags == null) {
            setTags(new java.util.ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * An array of objects, one for each tag to associate with the data lake configuration. For each tag, you must
     * specify both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.
     * </p>
     * 
     * @param tags
     *        An array of objects, one for each tag to associate with the data lake configuration. For each tag, you
     *        must specify both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateDataLakeRequest withTags(java.util.Collection<Tag> tags) {
        setTags(tags);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getConfigurations() != null)
            sb.append("Configurations: ").append(getConfigurations()).append(",");
        if (getMetaStoreManagerRoleArn() != null)
            sb.append("MetaStoreManagerRoleArn: ").append(getMetaStoreManagerRoleArn()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateDataLakeRequest == false)
            return false;
        CreateDataLakeRequest other = (CreateDataLakeRequest) obj;
        if (other.getConfigurations() == null ^ this.getConfigurations() == null)
            return false;
        if (other.getConfigurations() != null && other.getConfigurations().equals(this.getConfigurations()) == false)
            return false;
        if (other.getMetaStoreManagerRoleArn() == null ^ this.getMetaStoreManagerRoleArn() == null)
            return false;
        if (other.getMetaStoreManagerRoleArn() != null && other.getMetaStoreManagerRoleArn().equals(this.getMetaStoreManagerRoleArn()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getConfigurations() == null) ? 0 : getConfigurations().hashCode());
        hashCode = prime * hashCode + ((getMetaStoreManagerRoleArn() == null) ? 0 : getMetaStoreManagerRoleArn().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        return hashCode;
    }

    @Override
    public CreateDataLakeRequest clone() {
        return (CreateDataLakeRequest) super.clone();
    }

}
