/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitylake.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.securitylake.model.DataLakeConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateDataLakeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<DataLakeConfiguration> configurations;
    private String metaStoreManagerRoleArn;

    public List<DataLakeConfiguration> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(Collection<DataLakeConfiguration> configurations) {
        if (configurations == null) {
            this.configurations = null;
            return;
        }
        this.configurations = new ArrayList<DataLakeConfiguration>(configurations);
    }

    public CreateDataLakeRequest withConfigurations(DataLakeConfiguration ... configurations) {
        if (this.configurations == null) {
            this.setConfigurations(new ArrayList<DataLakeConfiguration>(configurations.length));
        }
        for (DataLakeConfiguration ele : configurations) {
            this.configurations.add(ele);
        }
        return this;
    }

    public CreateDataLakeRequest withConfigurations(Collection<DataLakeConfiguration> configurations) {
        this.setConfigurations(configurations);
        return this;
    }

    public void setMetaStoreManagerRoleArn(String metaStoreManagerRoleArn) {
        this.metaStoreManagerRoleArn = metaStoreManagerRoleArn;
    }

    public String getMetaStoreManagerRoleArn() {
        return this.metaStoreManagerRoleArn;
    }

    public CreateDataLakeRequest withMetaStoreManagerRoleArn(String metaStoreManagerRoleArn) {
        this.setMetaStoreManagerRoleArn(metaStoreManagerRoleArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConfigurations() != null) {
            sb.append("Configurations: ").append(this.getConfigurations()).append(",");
        }
        if (this.getMetaStoreManagerRoleArn() != null) {
            sb.append("MetaStoreManagerRoleArn: ").append(this.getMetaStoreManagerRoleArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataLakeRequest)) {
            return false;
        }
        CreateDataLakeRequest other = (CreateDataLakeRequest)obj;
        if (other.getConfigurations() == null ^ this.getConfigurations() == null) {
            return false;
        }
        if (other.getConfigurations() != null && !other.getConfigurations().equals(this.getConfigurations())) {
            return false;
        }
        if (other.getMetaStoreManagerRoleArn() == null ^ this.getMetaStoreManagerRoleArn() == null) {
            return false;
        }
        return other.getMetaStoreManagerRoleArn() == null || other.getMetaStoreManagerRoleArn().equals(this.getMetaStoreManagerRoleArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConfigurations() == null ? 0 : this.getConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getMetaStoreManagerRoleArn() == null ? 0 : this.getMetaStoreManagerRoleArn().hashCode());
        return hashCode;
    }

    public CreateDataLakeRequest clone() {
        return (CreateDataLakeRequest)super.clone();
    }
}

