/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securityhub.model.SecurityControlsConfiguration;
import com.amazonaws.services.securityhub.model.transform.SecurityHubPolicyMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SecurityHubPolicy
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean serviceEnabled;
    private List<String> enabledStandardIdentifiers;
    private SecurityControlsConfiguration securityControlsConfiguration;

    public void setServiceEnabled(Boolean serviceEnabled) {
        this.serviceEnabled = serviceEnabled;
    }

    public Boolean getServiceEnabled() {
        return this.serviceEnabled;
    }

    public SecurityHubPolicy withServiceEnabled(Boolean serviceEnabled) {
        this.setServiceEnabled(serviceEnabled);
        return this;
    }

    public Boolean isServiceEnabled() {
        return this.serviceEnabled;
    }

    public List<String> getEnabledStandardIdentifiers() {
        return this.enabledStandardIdentifiers;
    }

    public void setEnabledStandardIdentifiers(Collection<String> enabledStandardIdentifiers) {
        if (enabledStandardIdentifiers == null) {
            this.enabledStandardIdentifiers = null;
            return;
        }
        this.enabledStandardIdentifiers = new ArrayList<String>(enabledStandardIdentifiers);
    }

    public SecurityHubPolicy withEnabledStandardIdentifiers(String ... enabledStandardIdentifiers) {
        if (this.enabledStandardIdentifiers == null) {
            this.setEnabledStandardIdentifiers(new ArrayList<String>(enabledStandardIdentifiers.length));
        }
        for (String ele : enabledStandardIdentifiers) {
            this.enabledStandardIdentifiers.add(ele);
        }
        return this;
    }

    public SecurityHubPolicy withEnabledStandardIdentifiers(Collection<String> enabledStandardIdentifiers) {
        this.setEnabledStandardIdentifiers(enabledStandardIdentifiers);
        return this;
    }

    public void setSecurityControlsConfiguration(SecurityControlsConfiguration securityControlsConfiguration) {
        this.securityControlsConfiguration = securityControlsConfiguration;
    }

    public SecurityControlsConfiguration getSecurityControlsConfiguration() {
        return this.securityControlsConfiguration;
    }

    public SecurityHubPolicy withSecurityControlsConfiguration(SecurityControlsConfiguration securityControlsConfiguration) {
        this.setSecurityControlsConfiguration(securityControlsConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getServiceEnabled() != null) {
            sb.append("ServiceEnabled: ").append(this.getServiceEnabled()).append(",");
        }
        if (this.getEnabledStandardIdentifiers() != null) {
            sb.append("EnabledStandardIdentifiers: ").append(this.getEnabledStandardIdentifiers()).append(",");
        }
        if (this.getSecurityControlsConfiguration() != null) {
            sb.append("SecurityControlsConfiguration: ").append(this.getSecurityControlsConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityHubPolicy)) {
            return false;
        }
        SecurityHubPolicy other = (SecurityHubPolicy)obj;
        if (other.getServiceEnabled() == null ^ this.getServiceEnabled() == null) {
            return false;
        }
        if (other.getServiceEnabled() != null && !other.getServiceEnabled().equals(this.getServiceEnabled())) {
            return false;
        }
        if (other.getEnabledStandardIdentifiers() == null ^ this.getEnabledStandardIdentifiers() == null) {
            return false;
        }
        if (other.getEnabledStandardIdentifiers() != null && !other.getEnabledStandardIdentifiers().equals(this.getEnabledStandardIdentifiers())) {
            return false;
        }
        if (other.getSecurityControlsConfiguration() == null ^ this.getSecurityControlsConfiguration() == null) {
            return false;
        }
        return other.getSecurityControlsConfiguration() == null || other.getSecurityControlsConfiguration().equals(this.getSecurityControlsConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getServiceEnabled() == null ? 0 : this.getServiceEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getEnabledStandardIdentifiers() == null ? 0 : this.getEnabledStandardIdentifiers().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityControlsConfiguration() == null ? 0 : this.getSecurityControlsConfiguration().hashCode());
        return hashCode;
    }

    public SecurityHubPolicy clone() {
        try {
            return (SecurityHubPolicy)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SecurityHubPolicyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

