/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securityhub.model.Adjustment;
import com.amazonaws.services.securityhub.model.transform.CvssMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Cvss
implements Serializable,
Cloneable,
StructuredPojo {
    private String version;
    private Double baseScore;
    private String baseVector;
    private String source;
    private List<Adjustment> adjustments;

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public Cvss withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public void setBaseScore(Double baseScore) {
        this.baseScore = baseScore;
    }

    public Double getBaseScore() {
        return this.baseScore;
    }

    public Cvss withBaseScore(Double baseScore) {
        this.setBaseScore(baseScore);
        return this;
    }

    public void setBaseVector(String baseVector) {
        this.baseVector = baseVector;
    }

    public String getBaseVector() {
        return this.baseVector;
    }

    public Cvss withBaseVector(String baseVector) {
        this.setBaseVector(baseVector);
        return this;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public Cvss withSource(String source) {
        this.setSource(source);
        return this;
    }

    public List<Adjustment> getAdjustments() {
        return this.adjustments;
    }

    public void setAdjustments(Collection<Adjustment> adjustments) {
        if (adjustments == null) {
            this.adjustments = null;
            return;
        }
        this.adjustments = new ArrayList<Adjustment>(adjustments);
    }

    public Cvss withAdjustments(Adjustment ... adjustments) {
        if (this.adjustments == null) {
            this.setAdjustments(new ArrayList<Adjustment>(adjustments.length));
        }
        for (Adjustment ele : adjustments) {
            this.adjustments.add(ele);
        }
        return this;
    }

    public Cvss withAdjustments(Collection<Adjustment> adjustments) {
        this.setAdjustments(adjustments);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getBaseScore() != null) {
            sb.append("BaseScore: ").append(this.getBaseScore()).append(",");
        }
        if (this.getBaseVector() != null) {
            sb.append("BaseVector: ").append(this.getBaseVector()).append(",");
        }
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource()).append(",");
        }
        if (this.getAdjustments() != null) {
            sb.append("Adjustments: ").append(this.getAdjustments());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cvss)) {
            return false;
        }
        Cvss other = (Cvss)obj;
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getBaseScore() == null ^ this.getBaseScore() == null) {
            return false;
        }
        if (other.getBaseScore() != null && !other.getBaseScore().equals(this.getBaseScore())) {
            return false;
        }
        if (other.getBaseVector() == null ^ this.getBaseVector() == null) {
            return false;
        }
        if (other.getBaseVector() != null && !other.getBaseVector().equals(this.getBaseVector())) {
            return false;
        }
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getAdjustments() == null ^ this.getAdjustments() == null) {
            return false;
        }
        return other.getAdjustments() == null || other.getAdjustments().equals(this.getAdjustments());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getBaseScore() == null ? 0 : this.getBaseScore().hashCode());
        hashCode = 31 * hashCode + (this.getBaseVector() == null ? 0 : this.getBaseVector().hashCode());
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getAdjustments() == null ? 0 : this.getAdjustments().hashCode());
        return hashCode;
    }

    public Cvss clone() {
        try {
            return (Cvss)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CvssMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

