/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.scheduler;

import javax.annotation.Generated;

import com.amazonaws.services.scheduler.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonScheduler}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonScheduler implements AmazonScheduler {

    protected AbstractAmazonScheduler() {
    }

    @Override
    public CreateScheduleResult createSchedule(CreateScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateScheduleGroupResult createScheduleGroup(CreateScheduleGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteScheduleResult deleteSchedule(DeleteScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteScheduleGroupResult deleteScheduleGroup(DeleteScheduleGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetScheduleResult getSchedule(GetScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetScheduleGroupResult getScheduleGroup(GetScheduleGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListScheduleGroupsResult listScheduleGroups(ListScheduleGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSchedulesResult listSchedules(ListSchedulesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateScheduleResult updateSchedule(UpdateScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
