/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemakergeospatial.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemakergeospatial.model.transform.GeometryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Geometry
implements Serializable,
Cloneable,
StructuredPojo {
    private List<List<List<Double>>> coordinates;
    private String type;

    public List<List<List<Double>>> getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(Collection<List<List<Double>>> coordinates) {
        if (coordinates == null) {
            this.coordinates = null;
            return;
        }
        this.coordinates = new ArrayList<List<List<Double>>>(coordinates);
    }

    public Geometry withCoordinates(List<List<Double>> ... coordinates) {
        if (this.coordinates == null) {
            this.setCoordinates(new ArrayList<List<List<Double>>>(coordinates.length));
        }
        for (List<List<Double>> ele : coordinates) {
            this.coordinates.add(ele);
        }
        return this;
    }

    public Geometry withCoordinates(Collection<List<List<Double>>> coordinates) {
        this.setCoordinates(coordinates);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Geometry withType(String type) {
        this.setType(type);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCoordinates() != null) {
            sb.append("Coordinates: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Geometry)) {
            return false;
        }
        Geometry other = (Geometry)obj;
        if (other.getCoordinates() == null ^ this.getCoordinates() == null) {
            return false;
        }
        if (other.getCoordinates() != null && !other.getCoordinates().equals(this.getCoordinates())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCoordinates() == null ? 0 : this.getCoordinates().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    public Geometry clone() {
        try {
            return (Geometry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GeometryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

