/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemakergeospatial;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.sagemakergeospatial.AmazonSageMakerGeospatialAsync;
import com.amazonaws.services.sagemakergeospatial.AmazonSageMakerGeospatialAsyncClientBuilder;
import com.amazonaws.services.sagemakergeospatial.AmazonSageMakerGeospatialClient;
import com.amazonaws.services.sagemakergeospatial.model.DeleteEarthObservationJobRequest;
import com.amazonaws.services.sagemakergeospatial.model.DeleteEarthObservationJobResult;
import com.amazonaws.services.sagemakergeospatial.model.DeleteVectorEnrichmentJobRequest;
import com.amazonaws.services.sagemakergeospatial.model.DeleteVectorEnrichmentJobResult;
import com.amazonaws.services.sagemakergeospatial.model.ExportEarthObservationJobRequest;
import com.amazonaws.services.sagemakergeospatial.model.ExportEarthObservationJobResult;
import com.amazonaws.services.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest;
import com.amazonaws.services.sagemakergeospatial.model.ExportVectorEnrichmentJobResult;
import com.amazonaws.services.sagemakergeospatial.model.GetEarthObservationJobRequest;
import com.amazonaws.services.sagemakergeospatial.model.GetEarthObservationJobResult;
import com.amazonaws.services.sagemakergeospatial.model.GetRasterDataCollectionRequest;
import com.amazonaws.services.sagemakergeospatial.model.GetRasterDataCollectionResult;
import com.amazonaws.services.sagemakergeospatial.model.GetTileRequest;
import com.amazonaws.services.sagemakergeospatial.model.GetTileResult;
import com.amazonaws.services.sagemakergeospatial.model.GetVectorEnrichmentJobRequest;
import com.amazonaws.services.sagemakergeospatial.model.GetVectorEnrichmentJobResult;
import com.amazonaws.services.sagemakergeospatial.model.ListEarthObservationJobsRequest;
import com.amazonaws.services.sagemakergeospatial.model.ListEarthObservationJobsResult;
import com.amazonaws.services.sagemakergeospatial.model.ListRasterDataCollectionsRequest;
import com.amazonaws.services.sagemakergeospatial.model.ListRasterDataCollectionsResult;
import com.amazonaws.services.sagemakergeospatial.model.ListTagsForResourceRequest;
import com.amazonaws.services.sagemakergeospatial.model.ListTagsForResourceResult;
import com.amazonaws.services.sagemakergeospatial.model.ListVectorEnrichmentJobsRequest;
import com.amazonaws.services.sagemakergeospatial.model.ListVectorEnrichmentJobsResult;
import com.amazonaws.services.sagemakergeospatial.model.SearchRasterDataCollectionRequest;
import com.amazonaws.services.sagemakergeospatial.model.SearchRasterDataCollectionResult;
import com.amazonaws.services.sagemakergeospatial.model.StartEarthObservationJobRequest;
import com.amazonaws.services.sagemakergeospatial.model.StartEarthObservationJobResult;
import com.amazonaws.services.sagemakergeospatial.model.StartVectorEnrichmentJobRequest;
import com.amazonaws.services.sagemakergeospatial.model.StartVectorEnrichmentJobResult;
import com.amazonaws.services.sagemakergeospatial.model.StopEarthObservationJobRequest;
import com.amazonaws.services.sagemakergeospatial.model.StopEarthObservationJobResult;
import com.amazonaws.services.sagemakergeospatial.model.StopVectorEnrichmentJobRequest;
import com.amazonaws.services.sagemakergeospatial.model.StopVectorEnrichmentJobResult;
import com.amazonaws.services.sagemakergeospatial.model.TagResourceRequest;
import com.amazonaws.services.sagemakergeospatial.model.TagResourceResult;
import com.amazonaws.services.sagemakergeospatial.model.UntagResourceRequest;
import com.amazonaws.services.sagemakergeospatial.model.UntagResourceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonSageMakerGeospatialAsyncClient
extends AmazonSageMakerGeospatialClient
implements AmazonSageMakerGeospatialAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonSageMakerGeospatialAsyncClientBuilder asyncBuilder() {
        return AmazonSageMakerGeospatialAsyncClientBuilder.standard();
    }

    AmazonSageMakerGeospatialAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonSageMakerGeospatialAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DeleteEarthObservationJobResult> deleteEarthObservationJobAsync(DeleteEarthObservationJobRequest request) {
        return this.deleteEarthObservationJobAsync(request, null);
    }

    @Override
    public Future<DeleteEarthObservationJobResult> deleteEarthObservationJobAsync(DeleteEarthObservationJobRequest request, final AsyncHandler<DeleteEarthObservationJobRequest, DeleteEarthObservationJobResult> asyncHandler) {
        final DeleteEarthObservationJobRequest finalRequest = (DeleteEarthObservationJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteEarthObservationJobResult>(){

            @Override
            public DeleteEarthObservationJobResult call() throws Exception {
                DeleteEarthObservationJobResult result = null;
                try {
                    result = AmazonSageMakerGeospatialAsyncClient.this.executeDeleteEarthObservationJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteVectorEnrichmentJobResult> deleteVectorEnrichmentJobAsync(DeleteVectorEnrichmentJobRequest request) {
        return this.deleteVectorEnrichmentJobAsync(request, null);
    }

    @Override
    public Future<DeleteVectorEnrichmentJobResult> deleteVectorEnrichmentJobAsync(DeleteVectorEnrichmentJobRequest request, final AsyncHandler<DeleteVectorEnrichmentJobRequest, DeleteVectorEnrichmentJobResult> asyncHandler) {
        final DeleteVectorEnrichmentJobRequest finalRequest = (DeleteVectorEnrichmentJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteVectorEnrichmentJobResult>(){

            @Override
            public DeleteVectorEnrichmentJobResult call() throws Exception {
                DeleteVectorEnrichmentJobResult result = null;
                try {
                    result = AmazonSageMakerGeospatialAsyncClient.this.executeDeleteVectorEnrichmentJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ExportEarthObservationJobResult> exportEarthObservationJobAsync(ExportEarthObservationJobRequest request) {
        return this.exportEarthObservationJobAsync(request, null);
    }

    @Override
    public Future<ExportEarthObservationJobResult> exportEarthObservationJobAsync(ExportEarthObservationJobRequest request, final AsyncHandler<ExportEarthObservationJobRequest, ExportEarthObservationJobResult> asyncHandler) {
        final ExportEarthObservationJobRequest finalRequest = (ExportEarthObservationJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ExportEarthObservationJobResult>(){

            @Override
            public ExportEarthObservationJobResult call() throws Exception {
                ExportEarthObservationJobResult result = null;
                try {
                    result = AmazonSageMakerGeospatialAsyncClient.this.executeExportEarthObservationJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ExportVectorEnrichmentJobResult> exportVectorEnrichmentJobAsync(ExportVectorEnrichmentJobRequest request) {
        return this.exportVectorEnrichmentJobAsync(request, null);
    }

    @Override
    public Future<ExportVectorEnrichmentJobResult> exportVectorEnrichmentJobAsync(ExportVectorEnrichmentJobRequest request, final AsyncHandler<ExportVectorEnrichmentJobRequest, ExportVectorEnrichmentJobResult> asyncHandler) {
        final ExportVectorEnrichmentJobRequest finalRequest = (ExportVectorEnrichmentJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ExportVectorEnrichmentJobResult>(){

            @Override
            public ExportVectorEnrichmentJobResult call() throws Exception {
                ExportVectorEnrichmentJobResult result = null;
                try {
                    result = AmazonSageMakerGeospatialAsyncClient.this.executeExportVectorEnrichmentJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEarthObservationJobResult> getEarthObservationJobAsync(GetEarthObservationJobRequest request) {
        return this.getEarthObservationJobAsync(request, null);
    }

    @Override
    public Future<GetEarthObservationJobResult> getEarthObservationJobAsync(GetEarthObservationJobRequest request, final AsyncHandler<GetEarthObservationJobRequest, GetEarthObservationJobResult> asyncHandler) {
        final GetEarthObservationJobRequest finalRequest = (GetEarthObservationJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEarthObservationJobResult>(){

            @Override
            public GetEarthObservationJobResult call() throws Exception {
                GetEarthObservationJobResult result = null;
                try {
                    result = AmazonSageMakerGeospatialAsyncClient.this.executeGetEarthObservationJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRasterDataCollectionResult> getRasterDataCollectionAsync(GetRasterDataCollectionRequest request) {
        return this.getRasterDataCollectionAsync(request, null);
    }

    @Override
    public Future<GetRasterDataCollectionResult> getRasterDataCollectionAsync(GetRasterDataCollectionRequest request, final AsyncHandler<GetRasterDataCollectionRequest, GetRasterDataCollectionResult> asyncHandler) {
        final GetRasterDataCollectionRequest finalRequest = (GetRasterDataCollectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRasterDataCollectionResult>(){

            @Override
            public GetRasterDataCollectionResult call() throws Exception {
                GetRasterDataCollectionResult result = null;
                try {
                    result = AmazonSageMakerGeospatialAsyncClient.this.executeGetRasterDataCollection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTileResult> getTileAsync(GetTileRequest request) {
        return this.getTileAsync(request, null);
    }

    @Override
    public Future<GetTileResult> getTileAsync(GetTileRequest request, final AsyncHandler<GetTileRequest, GetTileResult> asyncHandler) {
        final GetTileRequest finalRequest = (GetTileRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTileResult>(){

            @Override
            public GetTileResult call() throws Exception {
                GetTileResult result = null;
                try {
                    result = AmazonSageMakerGeospatialAsyncClient.this.executeGetTile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetVectorEnrichmentJobResult> getVectorEnrichmentJobAsync(GetVectorEnrichmentJobRequest request) {
        return this.getVectorEnrichmentJobAsync(request, null);
    }

    @Override
    public Future<GetVectorEnrichmentJobResult> getVectorEnrichmentJobAsync(GetVectorEnrichmentJobRequest request, final AsyncHandler<GetVectorEnrichmentJobRequest, GetVectorEnrichmentJobResult> asyncHandler) {
        final GetVectorEnrichmentJobRequest finalRequest = (GetVectorEnrichmentJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetVectorEnrichmentJobResult>(){

            @Override
            public GetVectorEnrichmentJobResult call() throws Exception {
                GetVectorEnrichmentJobResult result = null;
                try {
                    result = AmazonSageMakerGeospatialAsyncClient.this.executeGetVectorEnrichmentJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEarthObservationJobsResult> listEarthObservationJobsAsync(ListEarthObservationJobsRequest request) {
        return this.listEarthObservationJobsAsync(request, null);
    }

    @Override
    public Future<ListEarthObservationJobsResult> listEarthObservationJobsAsync(ListEarthObservationJobsRequest request, final AsyncHandler<ListEarthObservationJobsRequest, ListEarthObservationJobsResult> asyncHandler) {
        final ListEarthObservationJobsRequest finalRequest = (ListEarthObservationJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEarthObservationJobsResult>(){

            @Override
            public ListEarthObservationJobsResult call() throws Exception {
                ListEarthObservationJobsResult result = null;
                try {
                    result = AmazonSageMakerGeospatialAsyncClient.this.executeListEarthObservationJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRasterDataCollectionsResult> listRasterDataCollectionsAsync(ListRasterDataCollectionsRequest request) {
        return this.listRasterDataCollectionsAsync(request, null);
    }

    @Override
    public Future<ListRasterDataCollectionsResult> listRasterDataCollectionsAsync(ListRasterDataCollectionsRequest request, final AsyncHandler<ListRasterDataCollectionsRequest, ListRasterDataCollectionsResult> asyncHandler) {
        final ListRasterDataCollectionsRequest finalRequest = (ListRasterDataCollectionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRasterDataCollectionsResult>(){

            @Override
            public ListRasterDataCollectionsResult call() throws Exception {
                ListRasterDataCollectionsResult result = null;
                try {
                    result = AmazonSageMakerGeospatialAsyncClient.this.executeListRasterDataCollections(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonSageMakerGeospatialAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListVectorEnrichmentJobsResult> listVectorEnrichmentJobsAsync(ListVectorEnrichmentJobsRequest request) {
        return this.listVectorEnrichmentJobsAsync(request, null);
    }

    @Override
    public Future<ListVectorEnrichmentJobsResult> listVectorEnrichmentJobsAsync(ListVectorEnrichmentJobsRequest request, final AsyncHandler<ListVectorEnrichmentJobsRequest, ListVectorEnrichmentJobsResult> asyncHandler) {
        final ListVectorEnrichmentJobsRequest finalRequest = (ListVectorEnrichmentJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListVectorEnrichmentJobsResult>(){

            @Override
            public ListVectorEnrichmentJobsResult call() throws Exception {
                ListVectorEnrichmentJobsResult result = null;
                try {
                    result = AmazonSageMakerGeospatialAsyncClient.this.executeListVectorEnrichmentJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchRasterDataCollectionResult> searchRasterDataCollectionAsync(SearchRasterDataCollectionRequest request) {
        return this.searchRasterDataCollectionAsync(request, null);
    }

    @Override
    public Future<SearchRasterDataCollectionResult> searchRasterDataCollectionAsync(SearchRasterDataCollectionRequest request, final AsyncHandler<SearchRasterDataCollectionRequest, SearchRasterDataCollectionResult> asyncHandler) {
        final SearchRasterDataCollectionRequest finalRequest = (SearchRasterDataCollectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SearchRasterDataCollectionResult>(){

            @Override
            public SearchRasterDataCollectionResult call() throws Exception {
                SearchRasterDataCollectionResult result = null;
                try {
                    result = AmazonSageMakerGeospatialAsyncClient.this.executeSearchRasterDataCollection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartEarthObservationJobResult> startEarthObservationJobAsync(StartEarthObservationJobRequest request) {
        return this.startEarthObservationJobAsync(request, null);
    }

    @Override
    public Future<StartEarthObservationJobResult> startEarthObservationJobAsync(StartEarthObservationJobRequest request, final AsyncHandler<StartEarthObservationJobRequest, StartEarthObservationJobResult> asyncHandler) {
        final StartEarthObservationJobRequest finalRequest = (StartEarthObservationJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartEarthObservationJobResult>(){

            @Override
            public StartEarthObservationJobResult call() throws Exception {
                StartEarthObservationJobResult result = null;
                try {
                    result = AmazonSageMakerGeospatialAsyncClient.this.executeStartEarthObservationJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartVectorEnrichmentJobResult> startVectorEnrichmentJobAsync(StartVectorEnrichmentJobRequest request) {
        return this.startVectorEnrichmentJobAsync(request, null);
    }

    @Override
    public Future<StartVectorEnrichmentJobResult> startVectorEnrichmentJobAsync(StartVectorEnrichmentJobRequest request, final AsyncHandler<StartVectorEnrichmentJobRequest, StartVectorEnrichmentJobResult> asyncHandler) {
        final StartVectorEnrichmentJobRequest finalRequest = (StartVectorEnrichmentJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartVectorEnrichmentJobResult>(){

            @Override
            public StartVectorEnrichmentJobResult call() throws Exception {
                StartVectorEnrichmentJobResult result = null;
                try {
                    result = AmazonSageMakerGeospatialAsyncClient.this.executeStartVectorEnrichmentJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopEarthObservationJobResult> stopEarthObservationJobAsync(StopEarthObservationJobRequest request) {
        return this.stopEarthObservationJobAsync(request, null);
    }

    @Override
    public Future<StopEarthObservationJobResult> stopEarthObservationJobAsync(StopEarthObservationJobRequest request, final AsyncHandler<StopEarthObservationJobRequest, StopEarthObservationJobResult> asyncHandler) {
        final StopEarthObservationJobRequest finalRequest = (StopEarthObservationJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopEarthObservationJobResult>(){

            @Override
            public StopEarthObservationJobResult call() throws Exception {
                StopEarthObservationJobResult result = null;
                try {
                    result = AmazonSageMakerGeospatialAsyncClient.this.executeStopEarthObservationJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopVectorEnrichmentJobResult> stopVectorEnrichmentJobAsync(StopVectorEnrichmentJobRequest request) {
        return this.stopVectorEnrichmentJobAsync(request, null);
    }

    @Override
    public Future<StopVectorEnrichmentJobResult> stopVectorEnrichmentJobAsync(StopVectorEnrichmentJobRequest request, final AsyncHandler<StopVectorEnrichmentJobRequest, StopVectorEnrichmentJobResult> asyncHandler) {
        final StopVectorEnrichmentJobRequest finalRequest = (StopVectorEnrichmentJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopVectorEnrichmentJobResult>(){

            @Override
            public StopVectorEnrichmentJobResult call() throws Exception {
                StopVectorEnrichmentJobResult result = null;
                try {
                    result = AmazonSageMakerGeospatialAsyncClient.this.executeStopVectorEnrichmentJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonSageMakerGeospatialAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonSageMakerGeospatialAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

