/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemakergeospatial.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemakergeospatial.model.AlgorithmNameResampling;
import com.amazonaws.services.sagemakergeospatial.model.OutputResolutionResamplingInput;
import com.amazonaws.services.sagemakergeospatial.model.transform.ResamplingConfigInputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ResamplingConfigInput
implements Serializable,
Cloneable,
StructuredPojo {
    private String algorithmName;
    private OutputResolutionResamplingInput outputResolution;
    private List<String> targetBands;

    public void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public ResamplingConfigInput withAlgorithmName(String algorithmName) {
        this.setAlgorithmName(algorithmName);
        return this;
    }

    public ResamplingConfigInput withAlgorithmName(AlgorithmNameResampling algorithmName) {
        this.algorithmName = algorithmName.toString();
        return this;
    }

    public void setOutputResolution(OutputResolutionResamplingInput outputResolution) {
        this.outputResolution = outputResolution;
    }

    public OutputResolutionResamplingInput getOutputResolution() {
        return this.outputResolution;
    }

    public ResamplingConfigInput withOutputResolution(OutputResolutionResamplingInput outputResolution) {
        this.setOutputResolution(outputResolution);
        return this;
    }

    public List<String> getTargetBands() {
        return this.targetBands;
    }

    public void setTargetBands(Collection<String> targetBands) {
        if (targetBands == null) {
            this.targetBands = null;
            return;
        }
        this.targetBands = new ArrayList<String>(targetBands);
    }

    public ResamplingConfigInput withTargetBands(String ... targetBands) {
        if (this.targetBands == null) {
            this.setTargetBands(new ArrayList<String>(targetBands.length));
        }
        for (String ele : targetBands) {
            this.targetBands.add(ele);
        }
        return this;
    }

    public ResamplingConfigInput withTargetBands(Collection<String> targetBands) {
        this.setTargetBands(targetBands);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAlgorithmName() != null) {
            sb.append("AlgorithmName: ").append(this.getAlgorithmName()).append(",");
        }
        if (this.getOutputResolution() != null) {
            sb.append("OutputResolution: ").append(this.getOutputResolution()).append(",");
        }
        if (this.getTargetBands() != null) {
            sb.append("TargetBands: ").append(this.getTargetBands());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResamplingConfigInput)) {
            return false;
        }
        ResamplingConfigInput other = (ResamplingConfigInput)obj;
        if (other.getAlgorithmName() == null ^ this.getAlgorithmName() == null) {
            return false;
        }
        if (other.getAlgorithmName() != null && !other.getAlgorithmName().equals(this.getAlgorithmName())) {
            return false;
        }
        if (other.getOutputResolution() == null ^ this.getOutputResolution() == null) {
            return false;
        }
        if (other.getOutputResolution() != null && !other.getOutputResolution().equals(this.getOutputResolution())) {
            return false;
        }
        if (other.getTargetBands() == null ^ this.getTargetBands() == null) {
            return false;
        }
        return other.getTargetBands() == null || other.getTargetBands().equals(this.getTargetBands());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAlgorithmName() == null ? 0 : this.getAlgorithmName().hashCode());
        hashCode = 31 * hashCode + (this.getOutputResolution() == null ? 0 : this.getOutputResolution().hashCode());
        hashCode = 31 * hashCode + (this.getTargetBands() == null ? 0 : this.getTargetBands().hashCode());
        return hashCode;
    }

    public ResamplingConfigInput clone() {
        try {
            return (ResamplingConfigInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResamplingConfigInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

