/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemakergeospatial.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemakergeospatial.model.ZonalStatistics;
import com.amazonaws.services.sagemakergeospatial.model.transform.ZonalStatisticsConfigInputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ZonalStatisticsConfigInput
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> statistics;
    private List<String> targetBands;
    private String zoneS3Path;

    public List<String> getStatistics() {
        return this.statistics;
    }

    public void setStatistics(Collection<String> statistics) {
        if (statistics == null) {
            this.statistics = null;
            return;
        }
        this.statistics = new ArrayList<String>(statistics);
    }

    public ZonalStatisticsConfigInput withStatistics(String ... statistics) {
        if (this.statistics == null) {
            this.setStatistics(new ArrayList<String>(statistics.length));
        }
        for (String ele : statistics) {
            this.statistics.add(ele);
        }
        return this;
    }

    public ZonalStatisticsConfigInput withStatistics(Collection<String> statistics) {
        this.setStatistics(statistics);
        return this;
    }

    public ZonalStatisticsConfigInput withStatistics(ZonalStatistics ... statistics) {
        ArrayList<String> statisticsCopy = new ArrayList<String>(statistics.length);
        for (ZonalStatistics value : statistics) {
            statisticsCopy.add(value.toString());
        }
        if (this.getStatistics() == null) {
            this.setStatistics(statisticsCopy);
        } else {
            this.getStatistics().addAll(statisticsCopy);
        }
        return this;
    }

    public List<String> getTargetBands() {
        return this.targetBands;
    }

    public void setTargetBands(Collection<String> targetBands) {
        if (targetBands == null) {
            this.targetBands = null;
            return;
        }
        this.targetBands = new ArrayList<String>(targetBands);
    }

    public ZonalStatisticsConfigInput withTargetBands(String ... targetBands) {
        if (this.targetBands == null) {
            this.setTargetBands(new ArrayList<String>(targetBands.length));
        }
        for (String ele : targetBands) {
            this.targetBands.add(ele);
        }
        return this;
    }

    public ZonalStatisticsConfigInput withTargetBands(Collection<String> targetBands) {
        this.setTargetBands(targetBands);
        return this;
    }

    public void setZoneS3Path(String zoneS3Path) {
        this.zoneS3Path = zoneS3Path;
    }

    public String getZoneS3Path() {
        return this.zoneS3Path;
    }

    public ZonalStatisticsConfigInput withZoneS3Path(String zoneS3Path) {
        this.setZoneS3Path(zoneS3Path);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStatistics() != null) {
            sb.append("Statistics: ").append(this.getStatistics()).append(",");
        }
        if (this.getTargetBands() != null) {
            sb.append("TargetBands: ").append(this.getTargetBands()).append(",");
        }
        if (this.getZoneS3Path() != null) {
            sb.append("ZoneS3Path: ").append(this.getZoneS3Path());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ZonalStatisticsConfigInput)) {
            return false;
        }
        ZonalStatisticsConfigInput other = (ZonalStatisticsConfigInput)obj;
        if (other.getStatistics() == null ^ this.getStatistics() == null) {
            return false;
        }
        if (other.getStatistics() != null && !other.getStatistics().equals(this.getStatistics())) {
            return false;
        }
        if (other.getTargetBands() == null ^ this.getTargetBands() == null) {
            return false;
        }
        if (other.getTargetBands() != null && !other.getTargetBands().equals(this.getTargetBands())) {
            return false;
        }
        if (other.getZoneS3Path() == null ^ this.getZoneS3Path() == null) {
            return false;
        }
        return other.getZoneS3Path() == null || other.getZoneS3Path().equals(this.getZoneS3Path());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStatistics() == null ? 0 : this.getStatistics().hashCode());
        hashCode = 31 * hashCode + (this.getTargetBands() == null ? 0 : this.getTargetBands().hashCode());
        hashCode = 31 * hashCode + (this.getZoneS3Path() == null ? 0 : this.getZoneS3Path().hashCode());
        return hashCode;
    }

    public ZonalStatisticsConfigInput clone() {
        try {
            return (ZonalStatisticsConfigInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ZonalStatisticsConfigInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

