/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.CustomFileSystemConfig;
import com.amazonaws.services.sagemaker.model.CustomPosixUserConfig;
import com.amazonaws.services.sagemaker.model.DefaultSpaceStorageSettings;
import com.amazonaws.services.sagemaker.model.JupyterLabAppSettings;
import com.amazonaws.services.sagemaker.model.JupyterServerAppSettings;
import com.amazonaws.services.sagemaker.model.KernelGatewayAppSettings;
import com.amazonaws.services.sagemaker.model.transform.DefaultSpaceSettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DefaultSpaceSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private String executionRole;
    private List<String> securityGroups;
    private JupyterServerAppSettings jupyterServerAppSettings;
    private KernelGatewayAppSettings kernelGatewayAppSettings;
    private JupyterLabAppSettings jupyterLabAppSettings;
    private DefaultSpaceStorageSettings spaceStorageSettings;
    private CustomPosixUserConfig customPosixUserConfig;
    private List<CustomFileSystemConfig> customFileSystemConfigs;

    public void setExecutionRole(String executionRole) {
        this.executionRole = executionRole;
    }

    public String getExecutionRole() {
        return this.executionRole;
    }

    public DefaultSpaceSettings withExecutionRole(String executionRole) {
        this.setExecutionRole(executionRole);
        return this;
    }

    public List<String> getSecurityGroups() {
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<String> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        this.securityGroups = new ArrayList<String>(securityGroups);
    }

    public DefaultSpaceSettings withSecurityGroups(String ... securityGroups) {
        if (this.securityGroups == null) {
            this.setSecurityGroups(new ArrayList<String>(securityGroups.length));
        }
        for (String ele : securityGroups) {
            this.securityGroups.add(ele);
        }
        return this;
    }

    public DefaultSpaceSettings withSecurityGroups(Collection<String> securityGroups) {
        this.setSecurityGroups(securityGroups);
        return this;
    }

    public void setJupyterServerAppSettings(JupyterServerAppSettings jupyterServerAppSettings) {
        this.jupyterServerAppSettings = jupyterServerAppSettings;
    }

    public JupyterServerAppSettings getJupyterServerAppSettings() {
        return this.jupyterServerAppSettings;
    }

    public DefaultSpaceSettings withJupyterServerAppSettings(JupyterServerAppSettings jupyterServerAppSettings) {
        this.setJupyterServerAppSettings(jupyterServerAppSettings);
        return this;
    }

    public void setKernelGatewayAppSettings(KernelGatewayAppSettings kernelGatewayAppSettings) {
        this.kernelGatewayAppSettings = kernelGatewayAppSettings;
    }

    public KernelGatewayAppSettings getKernelGatewayAppSettings() {
        return this.kernelGatewayAppSettings;
    }

    public DefaultSpaceSettings withKernelGatewayAppSettings(KernelGatewayAppSettings kernelGatewayAppSettings) {
        this.setKernelGatewayAppSettings(kernelGatewayAppSettings);
        return this;
    }

    public void setJupyterLabAppSettings(JupyterLabAppSettings jupyterLabAppSettings) {
        this.jupyterLabAppSettings = jupyterLabAppSettings;
    }

    public JupyterLabAppSettings getJupyterLabAppSettings() {
        return this.jupyterLabAppSettings;
    }

    public DefaultSpaceSettings withJupyterLabAppSettings(JupyterLabAppSettings jupyterLabAppSettings) {
        this.setJupyterLabAppSettings(jupyterLabAppSettings);
        return this;
    }

    public void setSpaceStorageSettings(DefaultSpaceStorageSettings spaceStorageSettings) {
        this.spaceStorageSettings = spaceStorageSettings;
    }

    public DefaultSpaceStorageSettings getSpaceStorageSettings() {
        return this.spaceStorageSettings;
    }

    public DefaultSpaceSettings withSpaceStorageSettings(DefaultSpaceStorageSettings spaceStorageSettings) {
        this.setSpaceStorageSettings(spaceStorageSettings);
        return this;
    }

    public void setCustomPosixUserConfig(CustomPosixUserConfig customPosixUserConfig) {
        this.customPosixUserConfig = customPosixUserConfig;
    }

    public CustomPosixUserConfig getCustomPosixUserConfig() {
        return this.customPosixUserConfig;
    }

    public DefaultSpaceSettings withCustomPosixUserConfig(CustomPosixUserConfig customPosixUserConfig) {
        this.setCustomPosixUserConfig(customPosixUserConfig);
        return this;
    }

    public List<CustomFileSystemConfig> getCustomFileSystemConfigs() {
        return this.customFileSystemConfigs;
    }

    public void setCustomFileSystemConfigs(Collection<CustomFileSystemConfig> customFileSystemConfigs) {
        if (customFileSystemConfigs == null) {
            this.customFileSystemConfigs = null;
            return;
        }
        this.customFileSystemConfigs = new ArrayList<CustomFileSystemConfig>(customFileSystemConfigs);
    }

    public DefaultSpaceSettings withCustomFileSystemConfigs(CustomFileSystemConfig ... customFileSystemConfigs) {
        if (this.customFileSystemConfigs == null) {
            this.setCustomFileSystemConfigs(new ArrayList<CustomFileSystemConfig>(customFileSystemConfigs.length));
        }
        for (CustomFileSystemConfig ele : customFileSystemConfigs) {
            this.customFileSystemConfigs.add(ele);
        }
        return this;
    }

    public DefaultSpaceSettings withCustomFileSystemConfigs(Collection<CustomFileSystemConfig> customFileSystemConfigs) {
        this.setCustomFileSystemConfigs(customFileSystemConfigs);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getExecutionRole() != null) {
            sb.append("ExecutionRole: ").append(this.getExecutionRole()).append(",");
        }
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.getSecurityGroups()).append(",");
        }
        if (this.getJupyterServerAppSettings() != null) {
            sb.append("JupyterServerAppSettings: ").append(this.getJupyterServerAppSettings()).append(",");
        }
        if (this.getKernelGatewayAppSettings() != null) {
            sb.append("KernelGatewayAppSettings: ").append(this.getKernelGatewayAppSettings()).append(",");
        }
        if (this.getJupyterLabAppSettings() != null) {
            sb.append("JupyterLabAppSettings: ").append(this.getJupyterLabAppSettings()).append(",");
        }
        if (this.getSpaceStorageSettings() != null) {
            sb.append("SpaceStorageSettings: ").append(this.getSpaceStorageSettings()).append(",");
        }
        if (this.getCustomPosixUserConfig() != null) {
            sb.append("CustomPosixUserConfig: ").append(this.getCustomPosixUserConfig()).append(",");
        }
        if (this.getCustomFileSystemConfigs() != null) {
            sb.append("CustomFileSystemConfigs: ").append(this.getCustomFileSystemConfigs());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultSpaceSettings)) {
            return false;
        }
        DefaultSpaceSettings other = (DefaultSpaceSettings)obj;
        if (other.getExecutionRole() == null ^ this.getExecutionRole() == null) {
            return false;
        }
        if (other.getExecutionRole() != null && !other.getExecutionRole().equals(this.getExecutionRole())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        if (other.getSecurityGroups() != null && !other.getSecurityGroups().equals(this.getSecurityGroups())) {
            return false;
        }
        if (other.getJupyterServerAppSettings() == null ^ this.getJupyterServerAppSettings() == null) {
            return false;
        }
        if (other.getJupyterServerAppSettings() != null && !other.getJupyterServerAppSettings().equals(this.getJupyterServerAppSettings())) {
            return false;
        }
        if (other.getKernelGatewayAppSettings() == null ^ this.getKernelGatewayAppSettings() == null) {
            return false;
        }
        if (other.getKernelGatewayAppSettings() != null && !other.getKernelGatewayAppSettings().equals(this.getKernelGatewayAppSettings())) {
            return false;
        }
        if (other.getJupyterLabAppSettings() == null ^ this.getJupyterLabAppSettings() == null) {
            return false;
        }
        if (other.getJupyterLabAppSettings() != null && !other.getJupyterLabAppSettings().equals(this.getJupyterLabAppSettings())) {
            return false;
        }
        if (other.getSpaceStorageSettings() == null ^ this.getSpaceStorageSettings() == null) {
            return false;
        }
        if (other.getSpaceStorageSettings() != null && !other.getSpaceStorageSettings().equals(this.getSpaceStorageSettings())) {
            return false;
        }
        if (other.getCustomPosixUserConfig() == null ^ this.getCustomPosixUserConfig() == null) {
            return false;
        }
        if (other.getCustomPosixUserConfig() != null && !other.getCustomPosixUserConfig().equals(this.getCustomPosixUserConfig())) {
            return false;
        }
        if (other.getCustomFileSystemConfigs() == null ^ this.getCustomFileSystemConfigs() == null) {
            return false;
        }
        return other.getCustomFileSystemConfigs() == null || other.getCustomFileSystemConfigs().equals(this.getCustomFileSystemConfigs());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getExecutionRole() == null ? 0 : this.getExecutionRole().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : this.getSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getJupyterServerAppSettings() == null ? 0 : this.getJupyterServerAppSettings().hashCode());
        hashCode = 31 * hashCode + (this.getKernelGatewayAppSettings() == null ? 0 : this.getKernelGatewayAppSettings().hashCode());
        hashCode = 31 * hashCode + (this.getJupyterLabAppSettings() == null ? 0 : this.getJupyterLabAppSettings().hashCode());
        hashCode = 31 * hashCode + (this.getSpaceStorageSettings() == null ? 0 : this.getSpaceStorageSettings().hashCode());
        hashCode = 31 * hashCode + (this.getCustomPosixUserConfig() == null ? 0 : this.getCustomPosixUserConfig().hashCode());
        hashCode = 31 * hashCode + (this.getCustomFileSystemConfigs() == null ? 0 : this.getCustomFileSystemConfigs().hashCode());
        return hashCode;
    }

    public DefaultSpaceSettings clone() {
        try {
            return (DefaultSpaceSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DefaultSpaceSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

