/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.ProductionVariant;

@SdkInternalApi
public class ProductionVariantMarshaller {
    private static final MarshallingInfo<String> VARIANTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VariantName").build();
    private static final MarshallingInfo<String> MODELNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelName").build();
    private static final MarshallingInfo<Integer> INITIALINSTANCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InitialInstanceCount").build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").build();
    private static final MarshallingInfo<Float> INITIALVARIANTWEIGHT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InitialVariantWeight").build();
    private static final MarshallingInfo<String> ACCELERATORTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AcceleratorType").build();
    private static final MarshallingInfo<StructuredPojo> COREDUMPCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CoreDumpConfig").build();
    private static final MarshallingInfo<StructuredPojo> SERVERLESSCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServerlessConfig").build();
    private static final MarshallingInfo<Integer> VOLUMESIZEINGB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeSizeInGB").build();
    private static final MarshallingInfo<Integer> MODELDATADOWNLOADTIMEOUTINSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelDataDownloadTimeoutInSeconds").build();
    private static final MarshallingInfo<Integer> CONTAINERSTARTUPHEALTHCHECKTIMEOUTINSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContainerStartupHealthCheckTimeoutInSeconds").build();
    private static final MarshallingInfo<Boolean> ENABLESSMACCESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnableSSMAccess").build();
    private static final MarshallingInfo<StructuredPojo> MANAGEDINSTANCESCALING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ManagedInstanceScaling").build();
    private static final MarshallingInfo<StructuredPojo> ROUTINGCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoutingConfig").build();
    private static final MarshallingInfo<String> INFERENCEAMIVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InferenceAmiVersion").build();
    private static final ProductionVariantMarshaller instance = new ProductionVariantMarshaller();

    public static ProductionVariantMarshaller getInstance() {
        return instance;
    }

    public void marshall(ProductionVariant productionVariant, ProtocolMarshaller protocolMarshaller) {
        if (productionVariant == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)productionVariant.getVariantName(), VARIANTNAME_BINDING);
            protocolMarshaller.marshall((Object)productionVariant.getModelName(), MODELNAME_BINDING);
            protocolMarshaller.marshall((Object)productionVariant.getInitialInstanceCount(), INITIALINSTANCECOUNT_BINDING);
            protocolMarshaller.marshall((Object)productionVariant.getInstanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)productionVariant.getInitialVariantWeight(), INITIALVARIANTWEIGHT_BINDING);
            protocolMarshaller.marshall((Object)productionVariant.getAcceleratorType(), ACCELERATORTYPE_BINDING);
            protocolMarshaller.marshall((Object)productionVariant.getCoreDumpConfig(), COREDUMPCONFIG_BINDING);
            protocolMarshaller.marshall((Object)productionVariant.getServerlessConfig(), SERVERLESSCONFIG_BINDING);
            protocolMarshaller.marshall((Object)productionVariant.getVolumeSizeInGB(), VOLUMESIZEINGB_BINDING);
            protocolMarshaller.marshall((Object)productionVariant.getModelDataDownloadTimeoutInSeconds(), MODELDATADOWNLOADTIMEOUTINSECONDS_BINDING);
            protocolMarshaller.marshall((Object)productionVariant.getContainerStartupHealthCheckTimeoutInSeconds(), CONTAINERSTARTUPHEALTHCHECKTIMEOUTINSECONDS_BINDING);
            protocolMarshaller.marshall((Object)productionVariant.getEnableSSMAccess(), ENABLESSMACCESS_BINDING);
            protocolMarshaller.marshall((Object)productionVariant.getManagedInstanceScaling(), MANAGEDINSTANCESCALING_BINDING);
            protocolMarshaller.marshall((Object)productionVariant.getRoutingConfig(), ROUTINGCONFIG_BINDING);
            protocolMarshaller.marshall((Object)productionVariant.getInferenceAmiVersion(), INFERENCEAMIVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

