/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.transform.OidcConfigMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class OidcConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String clientId;
    private String clientSecret;
    private String issuer;
    private String authorizationEndpoint;
    private String tokenEndpoint;
    private String userInfoEndpoint;
    private String logoutEndpoint;
    private String jwksUri;
    private String scope;
    private Map<String, String> authenticationRequestExtraParams;

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public OidcConfig withClientId(String clientId) {
        this.setClientId(clientId);
        return this;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public OidcConfig withClientSecret(String clientSecret) {
        this.setClientSecret(clientSecret);
        return this;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public OidcConfig withIssuer(String issuer) {
        this.setIssuer(issuer);
        return this;
    }

    public void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public OidcConfig withAuthorizationEndpoint(String authorizationEndpoint) {
        this.setAuthorizationEndpoint(authorizationEndpoint);
        return this;
    }

    public void setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public OidcConfig withTokenEndpoint(String tokenEndpoint) {
        this.setTokenEndpoint(tokenEndpoint);
        return this;
    }

    public void setUserInfoEndpoint(String userInfoEndpoint) {
        this.userInfoEndpoint = userInfoEndpoint;
    }

    public String getUserInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    public OidcConfig withUserInfoEndpoint(String userInfoEndpoint) {
        this.setUserInfoEndpoint(userInfoEndpoint);
        return this;
    }

    public void setLogoutEndpoint(String logoutEndpoint) {
        this.logoutEndpoint = logoutEndpoint;
    }

    public String getLogoutEndpoint() {
        return this.logoutEndpoint;
    }

    public OidcConfig withLogoutEndpoint(String logoutEndpoint) {
        this.setLogoutEndpoint(logoutEndpoint);
        return this;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public OidcConfig withJwksUri(String jwksUri) {
        this.setJwksUri(jwksUri);
        return this;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public OidcConfig withScope(String scope) {
        this.setScope(scope);
        return this;
    }

    public Map<String, String> getAuthenticationRequestExtraParams() {
        return this.authenticationRequestExtraParams;
    }

    public void setAuthenticationRequestExtraParams(Map<String, String> authenticationRequestExtraParams) {
        this.authenticationRequestExtraParams = authenticationRequestExtraParams;
    }

    public OidcConfig withAuthenticationRequestExtraParams(Map<String, String> authenticationRequestExtraParams) {
        this.setAuthenticationRequestExtraParams(authenticationRequestExtraParams);
        return this;
    }

    public OidcConfig addAuthenticationRequestExtraParamsEntry(String key, String value) {
        if (null == this.authenticationRequestExtraParams) {
            this.authenticationRequestExtraParams = new HashMap<String, String>();
        }
        if (this.authenticationRequestExtraParams.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.authenticationRequestExtraParams.put(key, value);
        return this;
    }

    public OidcConfig clearAuthenticationRequestExtraParamsEntries() {
        this.authenticationRequestExtraParams = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientId() != null) {
            sb.append("ClientId: ").append(this.getClientId()).append(",");
        }
        if (this.getClientSecret() != null) {
            sb.append("ClientSecret: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getIssuer() != null) {
            sb.append("Issuer: ").append(this.getIssuer()).append(",");
        }
        if (this.getAuthorizationEndpoint() != null) {
            sb.append("AuthorizationEndpoint: ").append(this.getAuthorizationEndpoint()).append(",");
        }
        if (this.getTokenEndpoint() != null) {
            sb.append("TokenEndpoint: ").append(this.getTokenEndpoint()).append(",");
        }
        if (this.getUserInfoEndpoint() != null) {
            sb.append("UserInfoEndpoint: ").append(this.getUserInfoEndpoint()).append(",");
        }
        if (this.getLogoutEndpoint() != null) {
            sb.append("LogoutEndpoint: ").append(this.getLogoutEndpoint()).append(",");
        }
        if (this.getJwksUri() != null) {
            sb.append("JwksUri: ").append(this.getJwksUri()).append(",");
        }
        if (this.getScope() != null) {
            sb.append("Scope: ").append(this.getScope()).append(",");
        }
        if (this.getAuthenticationRequestExtraParams() != null) {
            sb.append("AuthenticationRequestExtraParams: ").append(this.getAuthenticationRequestExtraParams());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OidcConfig)) {
            return false;
        }
        OidcConfig other = (OidcConfig)obj;
        if (other.getClientId() == null ^ this.getClientId() == null) {
            return false;
        }
        if (other.getClientId() != null && !other.getClientId().equals(this.getClientId())) {
            return false;
        }
        if (other.getClientSecret() == null ^ this.getClientSecret() == null) {
            return false;
        }
        if (other.getClientSecret() != null && !other.getClientSecret().equals(this.getClientSecret())) {
            return false;
        }
        if (other.getIssuer() == null ^ this.getIssuer() == null) {
            return false;
        }
        if (other.getIssuer() != null && !other.getIssuer().equals(this.getIssuer())) {
            return false;
        }
        if (other.getAuthorizationEndpoint() == null ^ this.getAuthorizationEndpoint() == null) {
            return false;
        }
        if (other.getAuthorizationEndpoint() != null && !other.getAuthorizationEndpoint().equals(this.getAuthorizationEndpoint())) {
            return false;
        }
        if (other.getTokenEndpoint() == null ^ this.getTokenEndpoint() == null) {
            return false;
        }
        if (other.getTokenEndpoint() != null && !other.getTokenEndpoint().equals(this.getTokenEndpoint())) {
            return false;
        }
        if (other.getUserInfoEndpoint() == null ^ this.getUserInfoEndpoint() == null) {
            return false;
        }
        if (other.getUserInfoEndpoint() != null && !other.getUserInfoEndpoint().equals(this.getUserInfoEndpoint())) {
            return false;
        }
        if (other.getLogoutEndpoint() == null ^ this.getLogoutEndpoint() == null) {
            return false;
        }
        if (other.getLogoutEndpoint() != null && !other.getLogoutEndpoint().equals(this.getLogoutEndpoint())) {
            return false;
        }
        if (other.getJwksUri() == null ^ this.getJwksUri() == null) {
            return false;
        }
        if (other.getJwksUri() != null && !other.getJwksUri().equals(this.getJwksUri())) {
            return false;
        }
        if (other.getScope() == null ^ this.getScope() == null) {
            return false;
        }
        if (other.getScope() != null && !other.getScope().equals(this.getScope())) {
            return false;
        }
        if (other.getAuthenticationRequestExtraParams() == null ^ this.getAuthenticationRequestExtraParams() == null) {
            return false;
        }
        return other.getAuthenticationRequestExtraParams() == null || other.getAuthenticationRequestExtraParams().equals(this.getAuthenticationRequestExtraParams());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientId() == null ? 0 : this.getClientId().hashCode());
        hashCode = 31 * hashCode + (this.getClientSecret() == null ? 0 : this.getClientSecret().hashCode());
        hashCode = 31 * hashCode + (this.getIssuer() == null ? 0 : this.getIssuer().hashCode());
        hashCode = 31 * hashCode + (this.getAuthorizationEndpoint() == null ? 0 : this.getAuthorizationEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getTokenEndpoint() == null ? 0 : this.getTokenEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getUserInfoEndpoint() == null ? 0 : this.getUserInfoEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getLogoutEndpoint() == null ? 0 : this.getLogoutEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getJwksUri() == null ? 0 : this.getJwksUri().hashCode());
        hashCode = 31 * hashCode + (this.getScope() == null ? 0 : this.getScope().hashCode());
        hashCode = 31 * hashCode + (this.getAuthenticationRequestExtraParams() == null ? 0 : this.getAuthenticationRequestExtraParams().hashCode());
        return hashCode;
    }

    public OidcConfig clone() {
        try {
            return (OidcConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OidcConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

