/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemaker.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.sagemaker.model.*;

import com.amazonaws.util.IdempotentUtils;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * CreateImageVersionRequestMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class CreateImageVersionRequestMarshaller {

    private static final MarshallingInfo<String> BASEIMAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("BaseImage").build();
    private static final MarshallingInfo<String> CLIENTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientToken")
            .defaultValueSupplier(com.amazonaws.util.IdempotentUtils.getGenerator()).build();
    private static final MarshallingInfo<String> IMAGENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ImageName").build();
    private static final MarshallingInfo<List> ALIASES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Aliases").build();
    private static final MarshallingInfo<String> VENDORGUIDANCE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VendorGuidance").build();
    private static final MarshallingInfo<String> JOBTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("JobType").build();
    private static final MarshallingInfo<String> MLFRAMEWORK_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MLFramework").build();
    private static final MarshallingInfo<String> PROGRAMMINGLANG_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProgrammingLang").build();
    private static final MarshallingInfo<String> PROCESSOR_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Processor").build();
    private static final MarshallingInfo<Boolean> HOROVOD_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Horovod").build();
    private static final MarshallingInfo<String> RELEASENOTES_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReleaseNotes").build();

    private static final CreateImageVersionRequestMarshaller instance = new CreateImageVersionRequestMarshaller();

    public static CreateImageVersionRequestMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(CreateImageVersionRequest createImageVersionRequest, ProtocolMarshaller protocolMarshaller) {

        if (createImageVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(createImageVersionRequest.getBaseImage(), BASEIMAGE_BINDING);
            protocolMarshaller.marshall(createImageVersionRequest.getClientToken(), CLIENTTOKEN_BINDING);
            protocolMarshaller.marshall(createImageVersionRequest.getImageName(), IMAGENAME_BINDING);
            protocolMarshaller.marshall(createImageVersionRequest.getAliases(), ALIASES_BINDING);
            protocolMarshaller.marshall(createImageVersionRequest.getVendorGuidance(), VENDORGUIDANCE_BINDING);
            protocolMarshaller.marshall(createImageVersionRequest.getJobType(), JOBTYPE_BINDING);
            protocolMarshaller.marshall(createImageVersionRequest.getMLFramework(), MLFRAMEWORK_BINDING);
            protocolMarshaller.marshall(createImageVersionRequest.getProgrammingLang(), PROGRAMMINGLANG_BINDING);
            protocolMarshaller.marshall(createImageVersionRequest.getProcessor(), PROCESSOR_BINDING);
            protocolMarshaller.marshall(createImageVersionRequest.getHorovod(), HOROVOD_BINDING);
            protocolMarshaller.marshall(createImageVersionRequest.getReleaseNotes(), RELEASENOTES_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
