/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemaker.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.sagemaker.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * AutoMLCandidateGenerationConfigMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class AutoMLCandidateGenerationConfigMarshaller {

    private static final MarshallingInfo<String> FEATURESPECIFICATIONS3URI_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FeatureSpecificationS3Uri").build();
    private static final MarshallingInfo<List> ALGORITHMSCONFIG_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AlgorithmsConfig").build();

    private static final AutoMLCandidateGenerationConfigMarshaller instance = new AutoMLCandidateGenerationConfigMarshaller();

    public static AutoMLCandidateGenerationConfigMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(AutoMLCandidateGenerationConfig autoMLCandidateGenerationConfig, ProtocolMarshaller protocolMarshaller) {

        if (autoMLCandidateGenerationConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(autoMLCandidateGenerationConfig.getFeatureSpecificationS3Uri(), FEATURESPECIFICATIONS3URI_BINDING);
            protocolMarshaller.marshall(autoMLCandidateGenerationConfig.getAlgorithmsConfig(), ALGORITHMSCONFIG_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
