/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemaker.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The workspace settings for the SageMaker Canvas application.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/WorkspaceSettings" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class WorkspaceSettings implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The Amazon S3 bucket used to store artifacts generated by Canvas. Updating the Amazon S3 location impacts
     * existing configuration settings, and Canvas users no longer have access to their artifacts. Canvas users must log
     * out and log back in to apply the new location.
     * </p>
     */
    private String s3ArtifactPath;
    /**
     * <p>
     * The Amazon Web Services Key Management Service (KMS) encryption key ID that is used to encrypt artifacts
     * generated by Canvas in the Amazon S3 bucket.
     * </p>
     */
    private String s3KmsKeyId;

    /**
     * <p>
     * The Amazon S3 bucket used to store artifacts generated by Canvas. Updating the Amazon S3 location impacts
     * existing configuration settings, and Canvas users no longer have access to their artifacts. Canvas users must log
     * out and log back in to apply the new location.
     * </p>
     * 
     * @param s3ArtifactPath
     *        The Amazon S3 bucket used to store artifacts generated by Canvas. Updating the Amazon S3 location impacts
     *        existing configuration settings, and Canvas users no longer have access to their artifacts. Canvas users
     *        must log out and log back in to apply the new location.
     */

    public void setS3ArtifactPath(String s3ArtifactPath) {
        this.s3ArtifactPath = s3ArtifactPath;
    }

    /**
     * <p>
     * The Amazon S3 bucket used to store artifacts generated by Canvas. Updating the Amazon S3 location impacts
     * existing configuration settings, and Canvas users no longer have access to their artifacts. Canvas users must log
     * out and log back in to apply the new location.
     * </p>
     * 
     * @return The Amazon S3 bucket used to store artifacts generated by Canvas. Updating the Amazon S3 location impacts
     *         existing configuration settings, and Canvas users no longer have access to their artifacts. Canvas users
     *         must log out and log back in to apply the new location.
     */

    public String getS3ArtifactPath() {
        return this.s3ArtifactPath;
    }

    /**
     * <p>
     * The Amazon S3 bucket used to store artifacts generated by Canvas. Updating the Amazon S3 location impacts
     * existing configuration settings, and Canvas users no longer have access to their artifacts. Canvas users must log
     * out and log back in to apply the new location.
     * </p>
     * 
     * @param s3ArtifactPath
     *        The Amazon S3 bucket used to store artifacts generated by Canvas. Updating the Amazon S3 location impacts
     *        existing configuration settings, and Canvas users no longer have access to their artifacts. Canvas users
     *        must log out and log back in to apply the new location.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public WorkspaceSettings withS3ArtifactPath(String s3ArtifactPath) {
        setS3ArtifactPath(s3ArtifactPath);
        return this;
    }

    /**
     * <p>
     * The Amazon Web Services Key Management Service (KMS) encryption key ID that is used to encrypt artifacts
     * generated by Canvas in the Amazon S3 bucket.
     * </p>
     * 
     * @param s3KmsKeyId
     *        The Amazon Web Services Key Management Service (KMS) encryption key ID that is used to encrypt artifacts
     *        generated by Canvas in the Amazon S3 bucket.
     */

    public void setS3KmsKeyId(String s3KmsKeyId) {
        this.s3KmsKeyId = s3KmsKeyId;
    }

    /**
     * <p>
     * The Amazon Web Services Key Management Service (KMS) encryption key ID that is used to encrypt artifacts
     * generated by Canvas in the Amazon S3 bucket.
     * </p>
     * 
     * @return The Amazon Web Services Key Management Service (KMS) encryption key ID that is used to encrypt artifacts
     *         generated by Canvas in the Amazon S3 bucket.
     */

    public String getS3KmsKeyId() {
        return this.s3KmsKeyId;
    }

    /**
     * <p>
     * The Amazon Web Services Key Management Service (KMS) encryption key ID that is used to encrypt artifacts
     * generated by Canvas in the Amazon S3 bucket.
     * </p>
     * 
     * @param s3KmsKeyId
     *        The Amazon Web Services Key Management Service (KMS) encryption key ID that is used to encrypt artifacts
     *        generated by Canvas in the Amazon S3 bucket.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public WorkspaceSettings withS3KmsKeyId(String s3KmsKeyId) {
        setS3KmsKeyId(s3KmsKeyId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getS3ArtifactPath() != null)
            sb.append("S3ArtifactPath: ").append(getS3ArtifactPath()).append(",");
        if (getS3KmsKeyId() != null)
            sb.append("S3KmsKeyId: ").append(getS3KmsKeyId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof WorkspaceSettings == false)
            return false;
        WorkspaceSettings other = (WorkspaceSettings) obj;
        if (other.getS3ArtifactPath() == null ^ this.getS3ArtifactPath() == null)
            return false;
        if (other.getS3ArtifactPath() != null && other.getS3ArtifactPath().equals(this.getS3ArtifactPath()) == false)
            return false;
        if (other.getS3KmsKeyId() == null ^ this.getS3KmsKeyId() == null)
            return false;
        if (other.getS3KmsKeyId() != null && other.getS3KmsKeyId().equals(this.getS3KmsKeyId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getS3ArtifactPath() == null) ? 0 : getS3ArtifactPath().hashCode());
        hashCode = prime * hashCode + ((getS3KmsKeyId() == null) ? 0 : getS3KmsKeyId().hashCode());
        return hashCode;
    }

    @Override
    public WorkspaceSettings clone() {
        try {
            return (WorkspaceSettings) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.sagemaker.model.transform.WorkspaceSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
