/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemaker.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListInferenceRecommendationsJobSteps"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListInferenceRecommendationsJobStepsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable,
        Cloneable {

    /**
     * <p>
     * A list of all subtask details in Inference Recommender.
     * </p>
     */
    private java.util.List<InferenceRecommendationsJobStep> steps;
    /**
     * <p>
     * A token that you can specify in your next request to return more results from the list.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * A list of all subtask details in Inference Recommender.
     * </p>
     * 
     * @return A list of all subtask details in Inference Recommender.
     */

    public java.util.List<InferenceRecommendationsJobStep> getSteps() {
        return steps;
    }

    /**
     * <p>
     * A list of all subtask details in Inference Recommender.
     * </p>
     * 
     * @param steps
     *        A list of all subtask details in Inference Recommender.
     */

    public void setSteps(java.util.Collection<InferenceRecommendationsJobStep> steps) {
        if (steps == null) {
            this.steps = null;
            return;
        }

        this.steps = new java.util.ArrayList<InferenceRecommendationsJobStep>(steps);
    }

    /**
     * <p>
     * A list of all subtask details in Inference Recommender.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setSteps(java.util.Collection)} or {@link #withSteps(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param steps
     *        A list of all subtask details in Inference Recommender.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListInferenceRecommendationsJobStepsResult withSteps(InferenceRecommendationsJobStep... steps) {
        if (this.steps == null) {
            setSteps(new java.util.ArrayList<InferenceRecommendationsJobStep>(steps.length));
        }
        for (InferenceRecommendationsJobStep ele : steps) {
            this.steps.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of all subtask details in Inference Recommender.
     * </p>
     * 
     * @param steps
     *        A list of all subtask details in Inference Recommender.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListInferenceRecommendationsJobStepsResult withSteps(java.util.Collection<InferenceRecommendationsJobStep> steps) {
        setSteps(steps);
        return this;
    }

    /**
     * <p>
     * A token that you can specify in your next request to return more results from the list.
     * </p>
     * 
     * @param nextToken
     *        A token that you can specify in your next request to return more results from the list.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * A token that you can specify in your next request to return more results from the list.
     * </p>
     * 
     * @return A token that you can specify in your next request to return more results from the list.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * A token that you can specify in your next request to return more results from the list.
     * </p>
     * 
     * @param nextToken
     *        A token that you can specify in your next request to return more results from the list.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListInferenceRecommendationsJobStepsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSteps() != null)
            sb.append("Steps: ").append(getSteps()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListInferenceRecommendationsJobStepsResult == false)
            return false;
        ListInferenceRecommendationsJobStepsResult other = (ListInferenceRecommendationsJobStepsResult) obj;
        if (other.getSteps() == null ^ this.getSteps() == null)
            return false;
        if (other.getSteps() != null && other.getSteps().equals(this.getSteps()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getSteps() == null) ? 0 : getSteps().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListInferenceRecommendationsJobStepsResult clone() {
        try {
            return (ListInferenceRecommendationsJobStepsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
