/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.sagemaker.model.Edge;
import com.amazonaws.services.sagemaker.model.Vertex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class QueryLineageResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Vertex> vertices;
    private List<Edge> edges;
    private String nextToken;

    public List<Vertex> getVertices() {
        return this.vertices;
    }

    public void setVertices(Collection<Vertex> vertices) {
        if (vertices == null) {
            this.vertices = null;
            return;
        }
        this.vertices = new ArrayList<Vertex>(vertices);
    }

    public QueryLineageResult withVertices(Vertex ... vertices) {
        if (this.vertices == null) {
            this.setVertices(new ArrayList<Vertex>(vertices.length));
        }
        for (Vertex ele : vertices) {
            this.vertices.add(ele);
        }
        return this;
    }

    public QueryLineageResult withVertices(Collection<Vertex> vertices) {
        this.setVertices(vertices);
        return this;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public void setEdges(Collection<Edge> edges) {
        if (edges == null) {
            this.edges = null;
            return;
        }
        this.edges = new ArrayList<Edge>(edges);
    }

    public QueryLineageResult withEdges(Edge ... edges) {
        if (this.edges == null) {
            this.setEdges(new ArrayList<Edge>(edges.length));
        }
        for (Edge ele : edges) {
            this.edges.add(ele);
        }
        return this;
    }

    public QueryLineageResult withEdges(Collection<Edge> edges) {
        this.setEdges(edges);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public QueryLineageResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVertices() != null) {
            sb.append("Vertices: ").append(this.getVertices()).append(",");
        }
        if (this.getEdges() != null) {
            sb.append("Edges: ").append(this.getEdges()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryLineageResult)) {
            return false;
        }
        QueryLineageResult other = (QueryLineageResult)obj;
        if (other.getVertices() == null ^ this.getVertices() == null) {
            return false;
        }
        if (other.getVertices() != null && !other.getVertices().equals(this.getVertices())) {
            return false;
        }
        if (other.getEdges() == null ^ this.getEdges() == null) {
            return false;
        }
        if (other.getEdges() != null && !other.getEdges().equals(this.getEdges())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVertices() == null ? 0 : this.getVertices().hashCode());
        hashCode = 31 * hashCode + (this.getEdges() == null ? 0 : this.getEdges().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public QueryLineageResult clone() {
        try {
            return (QueryLineageResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

