/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemaker.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListMonitoringAlertHistory"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListMonitoringAlertHistoryRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The name of a monitoring schedule.
     * </p>
     */
    private String monitoringScheduleName;
    /**
     * <p>
     * The name of a monitoring alert.
     * </p>
     */
    private String monitoringAlertName;
    /**
     * <p>
     * The field used to sort results. The default is <code>CreationTime</code>.
     * </p>
     */
    private String sortBy;
    /**
     * <p>
     * The sort order, whether <code>Ascending</code> or <code>Descending</code>, of the alert history. The default is
     * <code>Descending</code>.
     * </p>
     */
    private String sortOrder;
    /**
     * <p>
     * If the result of the previous <code>ListMonitoringAlertHistory</code> request was truncated, the response
     * includes a <code>NextToken</code>. To retrieve the next set of alerts in the history, use the token in the next
     * request.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * The maximum number of results to display. The default is 100.
     * </p>
     */
    private Integer maxResults;
    /**
     * <p>
     * A filter that returns only alerts created on or before the specified time.
     * </p>
     */
    private java.util.Date creationTimeBefore;
    /**
     * <p>
     * A filter that returns only alerts created on or after the specified time.
     * </p>
     */
    private java.util.Date creationTimeAfter;
    /**
     * <p>
     * A filter that retrieves only alerts with a specific status.
     * </p>
     */
    private String statusEquals;

    /**
     * <p>
     * The name of a monitoring schedule.
     * </p>
     * 
     * @param monitoringScheduleName
     *        The name of a monitoring schedule.
     */

    public void setMonitoringScheduleName(String monitoringScheduleName) {
        this.monitoringScheduleName = monitoringScheduleName;
    }

    /**
     * <p>
     * The name of a monitoring schedule.
     * </p>
     * 
     * @return The name of a monitoring schedule.
     */

    public String getMonitoringScheduleName() {
        return this.monitoringScheduleName;
    }

    /**
     * <p>
     * The name of a monitoring schedule.
     * </p>
     * 
     * @param monitoringScheduleName
     *        The name of a monitoring schedule.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListMonitoringAlertHistoryRequest withMonitoringScheduleName(String monitoringScheduleName) {
        setMonitoringScheduleName(monitoringScheduleName);
        return this;
    }

    /**
     * <p>
     * The name of a monitoring alert.
     * </p>
     * 
     * @param monitoringAlertName
     *        The name of a monitoring alert.
     */

    public void setMonitoringAlertName(String monitoringAlertName) {
        this.monitoringAlertName = monitoringAlertName;
    }

    /**
     * <p>
     * The name of a monitoring alert.
     * </p>
     * 
     * @return The name of a monitoring alert.
     */

    public String getMonitoringAlertName() {
        return this.monitoringAlertName;
    }

    /**
     * <p>
     * The name of a monitoring alert.
     * </p>
     * 
     * @param monitoringAlertName
     *        The name of a monitoring alert.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListMonitoringAlertHistoryRequest withMonitoringAlertName(String monitoringAlertName) {
        setMonitoringAlertName(monitoringAlertName);
        return this;
    }

    /**
     * <p>
     * The field used to sort results. The default is <code>CreationTime</code>.
     * </p>
     * 
     * @param sortBy
     *        The field used to sort results. The default is <code>CreationTime</code>.
     * @see MonitoringAlertHistorySortKey
     */

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    /**
     * <p>
     * The field used to sort results. The default is <code>CreationTime</code>.
     * </p>
     * 
     * @return The field used to sort results. The default is <code>CreationTime</code>.
     * @see MonitoringAlertHistorySortKey
     */

    public String getSortBy() {
        return this.sortBy;
    }

    /**
     * <p>
     * The field used to sort results. The default is <code>CreationTime</code>.
     * </p>
     * 
     * @param sortBy
     *        The field used to sort results. The default is <code>CreationTime</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MonitoringAlertHistorySortKey
     */

    public ListMonitoringAlertHistoryRequest withSortBy(String sortBy) {
        setSortBy(sortBy);
        return this;
    }

    /**
     * <p>
     * The field used to sort results. The default is <code>CreationTime</code>.
     * </p>
     * 
     * @param sortBy
     *        The field used to sort results. The default is <code>CreationTime</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MonitoringAlertHistorySortKey
     */

    public ListMonitoringAlertHistoryRequest withSortBy(MonitoringAlertHistorySortKey sortBy) {
        this.sortBy = sortBy.toString();
        return this;
    }

    /**
     * <p>
     * The sort order, whether <code>Ascending</code> or <code>Descending</code>, of the alert history. The default is
     * <code>Descending</code>.
     * </p>
     * 
     * @param sortOrder
     *        The sort order, whether <code>Ascending</code> or <code>Descending</code>, of the alert history. The
     *        default is <code>Descending</code>.
     * @see SortOrder
     */

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    /**
     * <p>
     * The sort order, whether <code>Ascending</code> or <code>Descending</code>, of the alert history. The default is
     * <code>Descending</code>.
     * </p>
     * 
     * @return The sort order, whether <code>Ascending</code> or <code>Descending</code>, of the alert history. The
     *         default is <code>Descending</code>.
     * @see SortOrder
     */

    public String getSortOrder() {
        return this.sortOrder;
    }

    /**
     * <p>
     * The sort order, whether <code>Ascending</code> or <code>Descending</code>, of the alert history. The default is
     * <code>Descending</code>.
     * </p>
     * 
     * @param sortOrder
     *        The sort order, whether <code>Ascending</code> or <code>Descending</code>, of the alert history. The
     *        default is <code>Descending</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SortOrder
     */

    public ListMonitoringAlertHistoryRequest withSortOrder(String sortOrder) {
        setSortOrder(sortOrder);
        return this;
    }

    /**
     * <p>
     * The sort order, whether <code>Ascending</code> or <code>Descending</code>, of the alert history. The default is
     * <code>Descending</code>.
     * </p>
     * 
     * @param sortOrder
     *        The sort order, whether <code>Ascending</code> or <code>Descending</code>, of the alert history. The
     *        default is <code>Descending</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SortOrder
     */

    public ListMonitoringAlertHistoryRequest withSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder.toString();
        return this;
    }

    /**
     * <p>
     * If the result of the previous <code>ListMonitoringAlertHistory</code> request was truncated, the response
     * includes a <code>NextToken</code>. To retrieve the next set of alerts in the history, use the token in the next
     * request.
     * </p>
     * 
     * @param nextToken
     *        If the result of the previous <code>ListMonitoringAlertHistory</code> request was truncated, the response
     *        includes a <code>NextToken</code>. To retrieve the next set of alerts in the history, use the token in the
     *        next request.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * If the result of the previous <code>ListMonitoringAlertHistory</code> request was truncated, the response
     * includes a <code>NextToken</code>. To retrieve the next set of alerts in the history, use the token in the next
     * request.
     * </p>
     * 
     * @return If the result of the previous <code>ListMonitoringAlertHistory</code> request was truncated, the response
     *         includes a <code>NextToken</code>. To retrieve the next set of alerts in the history, use the token in
     *         the next request.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * If the result of the previous <code>ListMonitoringAlertHistory</code> request was truncated, the response
     * includes a <code>NextToken</code>. To retrieve the next set of alerts in the history, use the token in the next
     * request.
     * </p>
     * 
     * @param nextToken
     *        If the result of the previous <code>ListMonitoringAlertHistory</code> request was truncated, the response
     *        includes a <code>NextToken</code>. To retrieve the next set of alerts in the history, use the token in the
     *        next request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListMonitoringAlertHistoryRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * The maximum number of results to display. The default is 100.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results to display. The default is 100.
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * The maximum number of results to display. The default is 100.
     * </p>
     * 
     * @return The maximum number of results to display. The default is 100.
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * <p>
     * The maximum number of results to display. The default is 100.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results to display. The default is 100.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListMonitoringAlertHistoryRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * <p>
     * A filter that returns only alerts created on or before the specified time.
     * </p>
     * 
     * @param creationTimeBefore
     *        A filter that returns only alerts created on or before the specified time.
     */

    public void setCreationTimeBefore(java.util.Date creationTimeBefore) {
        this.creationTimeBefore = creationTimeBefore;
    }

    /**
     * <p>
     * A filter that returns only alerts created on or before the specified time.
     * </p>
     * 
     * @return A filter that returns only alerts created on or before the specified time.
     */

    public java.util.Date getCreationTimeBefore() {
        return this.creationTimeBefore;
    }

    /**
     * <p>
     * A filter that returns only alerts created on or before the specified time.
     * </p>
     * 
     * @param creationTimeBefore
     *        A filter that returns only alerts created on or before the specified time.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListMonitoringAlertHistoryRequest withCreationTimeBefore(java.util.Date creationTimeBefore) {
        setCreationTimeBefore(creationTimeBefore);
        return this;
    }

    /**
     * <p>
     * A filter that returns only alerts created on or after the specified time.
     * </p>
     * 
     * @param creationTimeAfter
     *        A filter that returns only alerts created on or after the specified time.
     */

    public void setCreationTimeAfter(java.util.Date creationTimeAfter) {
        this.creationTimeAfter = creationTimeAfter;
    }

    /**
     * <p>
     * A filter that returns only alerts created on or after the specified time.
     * </p>
     * 
     * @return A filter that returns only alerts created on or after the specified time.
     */

    public java.util.Date getCreationTimeAfter() {
        return this.creationTimeAfter;
    }

    /**
     * <p>
     * A filter that returns only alerts created on or after the specified time.
     * </p>
     * 
     * @param creationTimeAfter
     *        A filter that returns only alerts created on or after the specified time.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListMonitoringAlertHistoryRequest withCreationTimeAfter(java.util.Date creationTimeAfter) {
        setCreationTimeAfter(creationTimeAfter);
        return this;
    }

    /**
     * <p>
     * A filter that retrieves only alerts with a specific status.
     * </p>
     * 
     * @param statusEquals
     *        A filter that retrieves only alerts with a specific status.
     * @see MonitoringAlertStatus
     */

    public void setStatusEquals(String statusEquals) {
        this.statusEquals = statusEquals;
    }

    /**
     * <p>
     * A filter that retrieves only alerts with a specific status.
     * </p>
     * 
     * @return A filter that retrieves only alerts with a specific status.
     * @see MonitoringAlertStatus
     */

    public String getStatusEquals() {
        return this.statusEquals;
    }

    /**
     * <p>
     * A filter that retrieves only alerts with a specific status.
     * </p>
     * 
     * @param statusEquals
     *        A filter that retrieves only alerts with a specific status.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MonitoringAlertStatus
     */

    public ListMonitoringAlertHistoryRequest withStatusEquals(String statusEquals) {
        setStatusEquals(statusEquals);
        return this;
    }

    /**
     * <p>
     * A filter that retrieves only alerts with a specific status.
     * </p>
     * 
     * @param statusEquals
     *        A filter that retrieves only alerts with a specific status.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MonitoringAlertStatus
     */

    public ListMonitoringAlertHistoryRequest withStatusEquals(MonitoringAlertStatus statusEquals) {
        this.statusEquals = statusEquals.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getMonitoringScheduleName() != null)
            sb.append("MonitoringScheduleName: ").append(getMonitoringScheduleName()).append(",");
        if (getMonitoringAlertName() != null)
            sb.append("MonitoringAlertName: ").append(getMonitoringAlertName()).append(",");
        if (getSortBy() != null)
            sb.append("SortBy: ").append(getSortBy()).append(",");
        if (getSortOrder() != null)
            sb.append("SortOrder: ").append(getSortOrder()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults()).append(",");
        if (getCreationTimeBefore() != null)
            sb.append("CreationTimeBefore: ").append(getCreationTimeBefore()).append(",");
        if (getCreationTimeAfter() != null)
            sb.append("CreationTimeAfter: ").append(getCreationTimeAfter()).append(",");
        if (getStatusEquals() != null)
            sb.append("StatusEquals: ").append(getStatusEquals());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListMonitoringAlertHistoryRequest == false)
            return false;
        ListMonitoringAlertHistoryRequest other = (ListMonitoringAlertHistoryRequest) obj;
        if (other.getMonitoringScheduleName() == null ^ this.getMonitoringScheduleName() == null)
            return false;
        if (other.getMonitoringScheduleName() != null && other.getMonitoringScheduleName().equals(this.getMonitoringScheduleName()) == false)
            return false;
        if (other.getMonitoringAlertName() == null ^ this.getMonitoringAlertName() == null)
            return false;
        if (other.getMonitoringAlertName() != null && other.getMonitoringAlertName().equals(this.getMonitoringAlertName()) == false)
            return false;
        if (other.getSortBy() == null ^ this.getSortBy() == null)
            return false;
        if (other.getSortBy() != null && other.getSortBy().equals(this.getSortBy()) == false)
            return false;
        if (other.getSortOrder() == null ^ this.getSortOrder() == null)
            return false;
        if (other.getSortOrder() != null && other.getSortOrder().equals(this.getSortOrder()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        if (other.getCreationTimeBefore() == null ^ this.getCreationTimeBefore() == null)
            return false;
        if (other.getCreationTimeBefore() != null && other.getCreationTimeBefore().equals(this.getCreationTimeBefore()) == false)
            return false;
        if (other.getCreationTimeAfter() == null ^ this.getCreationTimeAfter() == null)
            return false;
        if (other.getCreationTimeAfter() != null && other.getCreationTimeAfter().equals(this.getCreationTimeAfter()) == false)
            return false;
        if (other.getStatusEquals() == null ^ this.getStatusEquals() == null)
            return false;
        if (other.getStatusEquals() != null && other.getStatusEquals().equals(this.getStatusEquals()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getMonitoringScheduleName() == null) ? 0 : getMonitoringScheduleName().hashCode());
        hashCode = prime * hashCode + ((getMonitoringAlertName() == null) ? 0 : getMonitoringAlertName().hashCode());
        hashCode = prime * hashCode + ((getSortBy() == null) ? 0 : getSortBy().hashCode());
        hashCode = prime * hashCode + ((getSortOrder() == null) ? 0 : getSortOrder().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        hashCode = prime * hashCode + ((getCreationTimeBefore() == null) ? 0 : getCreationTimeBefore().hashCode());
        hashCode = prime * hashCode + ((getCreationTimeAfter() == null) ? 0 : getCreationTimeAfter().hashCode());
        hashCode = prime * hashCode + ((getStatusEquals() == null) ? 0 : getStatusEquals().hashCode());
        return hashCode;
    }

    @Override
    public ListMonitoringAlertHistoryRequest clone() {
        return (ListMonitoringAlertHistoryRequest) super.clone();
    }

}
