/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sagemaker.model.DeploymentConfig;
import com.amazonaws.services.sagemaker.model.VariantProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateEndpointRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String endpointName;
    private String endpointConfigName;
    private Boolean retainAllVariantProperties;
    private List<VariantProperty> excludeRetainedVariantProperties;
    private DeploymentConfig deploymentConfig;

    public void setEndpointName(String endpointName) {
        this.endpointName = endpointName;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public UpdateEndpointRequest withEndpointName(String endpointName) {
        this.setEndpointName(endpointName);
        return this;
    }

    public void setEndpointConfigName(String endpointConfigName) {
        this.endpointConfigName = endpointConfigName;
    }

    public String getEndpointConfigName() {
        return this.endpointConfigName;
    }

    public UpdateEndpointRequest withEndpointConfigName(String endpointConfigName) {
        this.setEndpointConfigName(endpointConfigName);
        return this;
    }

    public void setRetainAllVariantProperties(Boolean retainAllVariantProperties) {
        this.retainAllVariantProperties = retainAllVariantProperties;
    }

    public Boolean getRetainAllVariantProperties() {
        return this.retainAllVariantProperties;
    }

    public UpdateEndpointRequest withRetainAllVariantProperties(Boolean retainAllVariantProperties) {
        this.setRetainAllVariantProperties(retainAllVariantProperties);
        return this;
    }

    public Boolean isRetainAllVariantProperties() {
        return this.retainAllVariantProperties;
    }

    public List<VariantProperty> getExcludeRetainedVariantProperties() {
        return this.excludeRetainedVariantProperties;
    }

    public void setExcludeRetainedVariantProperties(Collection<VariantProperty> excludeRetainedVariantProperties) {
        if (excludeRetainedVariantProperties == null) {
            this.excludeRetainedVariantProperties = null;
            return;
        }
        this.excludeRetainedVariantProperties = new ArrayList<VariantProperty>(excludeRetainedVariantProperties);
    }

    public UpdateEndpointRequest withExcludeRetainedVariantProperties(VariantProperty ... excludeRetainedVariantProperties) {
        if (this.excludeRetainedVariantProperties == null) {
            this.setExcludeRetainedVariantProperties(new ArrayList<VariantProperty>(excludeRetainedVariantProperties.length));
        }
        for (VariantProperty ele : excludeRetainedVariantProperties) {
            this.excludeRetainedVariantProperties.add(ele);
        }
        return this;
    }

    public UpdateEndpointRequest withExcludeRetainedVariantProperties(Collection<VariantProperty> excludeRetainedVariantProperties) {
        this.setExcludeRetainedVariantProperties(excludeRetainedVariantProperties);
        return this;
    }

    public void setDeploymentConfig(DeploymentConfig deploymentConfig) {
        this.deploymentConfig = deploymentConfig;
    }

    public DeploymentConfig getDeploymentConfig() {
        return this.deploymentConfig;
    }

    public UpdateEndpointRequest withDeploymentConfig(DeploymentConfig deploymentConfig) {
        this.setDeploymentConfig(deploymentConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEndpointName() != null) {
            sb.append("EndpointName: ").append(this.getEndpointName()).append(",");
        }
        if (this.getEndpointConfigName() != null) {
            sb.append("EndpointConfigName: ").append(this.getEndpointConfigName()).append(",");
        }
        if (this.getRetainAllVariantProperties() != null) {
            sb.append("RetainAllVariantProperties: ").append(this.getRetainAllVariantProperties()).append(",");
        }
        if (this.getExcludeRetainedVariantProperties() != null) {
            sb.append("ExcludeRetainedVariantProperties: ").append(this.getExcludeRetainedVariantProperties()).append(",");
        }
        if (this.getDeploymentConfig() != null) {
            sb.append("DeploymentConfig: ").append(this.getDeploymentConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEndpointRequest)) {
            return false;
        }
        UpdateEndpointRequest other = (UpdateEndpointRequest)obj;
        if (other.getEndpointName() == null ^ this.getEndpointName() == null) {
            return false;
        }
        if (other.getEndpointName() != null && !other.getEndpointName().equals(this.getEndpointName())) {
            return false;
        }
        if (other.getEndpointConfigName() == null ^ this.getEndpointConfigName() == null) {
            return false;
        }
        if (other.getEndpointConfigName() != null && !other.getEndpointConfigName().equals(this.getEndpointConfigName())) {
            return false;
        }
        if (other.getRetainAllVariantProperties() == null ^ this.getRetainAllVariantProperties() == null) {
            return false;
        }
        if (other.getRetainAllVariantProperties() != null && !other.getRetainAllVariantProperties().equals(this.getRetainAllVariantProperties())) {
            return false;
        }
        if (other.getExcludeRetainedVariantProperties() == null ^ this.getExcludeRetainedVariantProperties() == null) {
            return false;
        }
        if (other.getExcludeRetainedVariantProperties() != null && !other.getExcludeRetainedVariantProperties().equals(this.getExcludeRetainedVariantProperties())) {
            return false;
        }
        if (other.getDeploymentConfig() == null ^ this.getDeploymentConfig() == null) {
            return false;
        }
        return other.getDeploymentConfig() == null || other.getDeploymentConfig().equals(this.getDeploymentConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEndpointName() == null ? 0 : this.getEndpointName().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointConfigName() == null ? 0 : this.getEndpointConfigName().hashCode());
        hashCode = 31 * hashCode + (this.getRetainAllVariantProperties() == null ? 0 : this.getRetainAllVariantProperties().hashCode());
        hashCode = 31 * hashCode + (this.getExcludeRetainedVariantProperties() == null ? 0 : this.getExcludeRetainedVariantProperties().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentConfig() == null ? 0 : this.getDeploymentConfig().hashCode());
        return hashCode;
    }

    public UpdateEndpointRequest clone() {
        return (UpdateEndpointRequest)super.clone();
    }
}

