/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.AutoMLDataSource;
import com.amazonaws.services.sagemaker.model.CompressionType;
import com.amazonaws.services.sagemaker.model.transform.AutoMLChannelMarshaller;
import java.io.Serializable;

public class AutoMLChannel
implements Serializable,
Cloneable,
StructuredPojo {
    private AutoMLDataSource dataSource;
    private String compressionType;
    private String targetAttributeName;

    public void setDataSource(AutoMLDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public AutoMLDataSource getDataSource() {
        return this.dataSource;
    }

    public AutoMLChannel withDataSource(AutoMLDataSource dataSource) {
        this.setDataSource(dataSource);
        return this;
    }

    public void setCompressionType(String compressionType) {
        this.compressionType = compressionType;
    }

    public String getCompressionType() {
        return this.compressionType;
    }

    public AutoMLChannel withCompressionType(String compressionType) {
        this.setCompressionType(compressionType);
        return this;
    }

    public AutoMLChannel withCompressionType(CompressionType compressionType) {
        this.compressionType = compressionType.toString();
        return this;
    }

    public void setTargetAttributeName(String targetAttributeName) {
        this.targetAttributeName = targetAttributeName;
    }

    public String getTargetAttributeName() {
        return this.targetAttributeName;
    }

    public AutoMLChannel withTargetAttributeName(String targetAttributeName) {
        this.setTargetAttributeName(targetAttributeName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDataSource() != null) {
            sb.append("DataSource: ").append(this.getDataSource()).append(",");
        }
        if (this.getCompressionType() != null) {
            sb.append("CompressionType: ").append(this.getCompressionType()).append(",");
        }
        if (this.getTargetAttributeName() != null) {
            sb.append("TargetAttributeName: ").append(this.getTargetAttributeName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLChannel)) {
            return false;
        }
        AutoMLChannel other = (AutoMLChannel)obj;
        if (other.getDataSource() == null ^ this.getDataSource() == null) {
            return false;
        }
        if (other.getDataSource() != null && !other.getDataSource().equals(this.getDataSource())) {
            return false;
        }
        if (other.getCompressionType() == null ^ this.getCompressionType() == null) {
            return false;
        }
        if (other.getCompressionType() != null && !other.getCompressionType().equals(this.getCompressionType())) {
            return false;
        }
        if (other.getTargetAttributeName() == null ^ this.getTargetAttributeName() == null) {
            return false;
        }
        return other.getTargetAttributeName() == null || other.getTargetAttributeName().equals(this.getTargetAttributeName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDataSource() == null ? 0 : this.getDataSource().hashCode());
        hashCode = 31 * hashCode + (this.getCompressionType() == null ? 0 : this.getCompressionType().hashCode());
        hashCode = 31 * hashCode + (this.getTargetAttributeName() == null ? 0 : this.getTargetAttributeName().hashCode());
        return hashCode;
    }

    public AutoMLChannel clone() {
        try {
            return (AutoMLChannel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoMLChannelMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

