/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sagemaker.model.AppType;
import com.amazonaws.services.sagemaker.model.ResourceSpec;
import com.amazonaws.services.sagemaker.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateAppRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String domainId;
    private String userProfileName;
    private String appType;
    private String appName;
    private List<Tag> tags;
    private ResourceSpec resourceSpec;
    private String spaceName;

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public CreateAppRequest withDomainId(String domainId) {
        this.setDomainId(domainId);
        return this;
    }

    public void setUserProfileName(String userProfileName) {
        this.userProfileName = userProfileName;
    }

    public String getUserProfileName() {
        return this.userProfileName;
    }

    public CreateAppRequest withUserProfileName(String userProfileName) {
        this.setUserProfileName(userProfileName);
        return this;
    }

    public void setAppType(String appType) {
        this.appType = appType;
    }

    public String getAppType() {
        return this.appType;
    }

    public CreateAppRequest withAppType(String appType) {
        this.setAppType(appType);
        return this;
    }

    public CreateAppRequest withAppType(AppType appType) {
        this.appType = appType.toString();
        return this;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppName() {
        return this.appName;
    }

    public CreateAppRequest withAppName(String appName) {
        this.setAppName(appName);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateAppRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateAppRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setResourceSpec(ResourceSpec resourceSpec) {
        this.resourceSpec = resourceSpec;
    }

    public ResourceSpec getResourceSpec() {
        return this.resourceSpec;
    }

    public CreateAppRequest withResourceSpec(ResourceSpec resourceSpec) {
        this.setResourceSpec(resourceSpec);
        return this;
    }

    public void setSpaceName(String spaceName) {
        this.spaceName = spaceName;
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    public CreateAppRequest withSpaceName(String spaceName) {
        this.setSpaceName(spaceName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomainId() != null) {
            sb.append("DomainId: ").append(this.getDomainId()).append(",");
        }
        if (this.getUserProfileName() != null) {
            sb.append("UserProfileName: ").append(this.getUserProfileName()).append(",");
        }
        if (this.getAppType() != null) {
            sb.append("AppType: ").append(this.getAppType()).append(",");
        }
        if (this.getAppName() != null) {
            sb.append("AppName: ").append(this.getAppName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getResourceSpec() != null) {
            sb.append("ResourceSpec: ").append(this.getResourceSpec()).append(",");
        }
        if (this.getSpaceName() != null) {
            sb.append("SpaceName: ").append(this.getSpaceName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppRequest)) {
            return false;
        }
        CreateAppRequest other = (CreateAppRequest)obj;
        if (other.getDomainId() == null ^ this.getDomainId() == null) {
            return false;
        }
        if (other.getDomainId() != null && !other.getDomainId().equals(this.getDomainId())) {
            return false;
        }
        if (other.getUserProfileName() == null ^ this.getUserProfileName() == null) {
            return false;
        }
        if (other.getUserProfileName() != null && !other.getUserProfileName().equals(this.getUserProfileName())) {
            return false;
        }
        if (other.getAppType() == null ^ this.getAppType() == null) {
            return false;
        }
        if (other.getAppType() != null && !other.getAppType().equals(this.getAppType())) {
            return false;
        }
        if (other.getAppName() == null ^ this.getAppName() == null) {
            return false;
        }
        if (other.getAppName() != null && !other.getAppName().equals(this.getAppName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getResourceSpec() == null ^ this.getResourceSpec() == null) {
            return false;
        }
        if (other.getResourceSpec() != null && !other.getResourceSpec().equals(this.getResourceSpec())) {
            return false;
        }
        if (other.getSpaceName() == null ^ this.getSpaceName() == null) {
            return false;
        }
        return other.getSpaceName() == null || other.getSpaceName().equals(this.getSpaceName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomainId() == null ? 0 : this.getDomainId().hashCode());
        hashCode = 31 * hashCode + (this.getUserProfileName() == null ? 0 : this.getUserProfileName().hashCode());
        hashCode = 31 * hashCode + (this.getAppType() == null ? 0 : this.getAppType().hashCode());
        hashCode = 31 * hashCode + (this.getAppName() == null ? 0 : this.getAppName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getResourceSpec() == null ? 0 : this.getResourceSpec().hashCode());
        hashCode = 31 * hashCode + (this.getSpaceName() == null ? 0 : this.getSpaceName().hashCode());
        return hashCode;
    }

    public CreateAppRequest clone() {
        return (CreateAppRequest)super.clone();
    }
}

