/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemaker.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.sagemaker.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * TuningJobCompletionCriteriaMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class TuningJobCompletionCriteriaMarshaller {

    private static final MarshallingInfo<Float> TARGETOBJECTIVEMETRICVALUE_BINDING = MarshallingInfo.builder(MarshallingType.FLOAT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetObjectiveMetricValue").build();
    private static final MarshallingInfo<StructuredPojo> BESTOBJECTIVENOTIMPROVING_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BestObjectiveNotImproving").build();
    private static final MarshallingInfo<StructuredPojo> CONVERGENCEDETECTED_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConvergenceDetected").build();

    private static final TuningJobCompletionCriteriaMarshaller instance = new TuningJobCompletionCriteriaMarshaller();

    public static TuningJobCompletionCriteriaMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(TuningJobCompletionCriteria tuningJobCompletionCriteria, ProtocolMarshaller protocolMarshaller) {

        if (tuningJobCompletionCriteria == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(tuningJobCompletionCriteria.getTargetObjectiveMetricValue(), TARGETOBJECTIVEMETRICVALUE_BINDING);
            protocolMarshaller.marshall(tuningJobCompletionCriteria.getBestObjectiveNotImproving(), BESTOBJECTIVENOTIMPROVING_BINDING);
            protocolMarshaller.marshall(tuningJobCompletionCriteria.getConvergenceDetected(), CONVERGENCEDETECTED_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
