/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sagemaker.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateTrialRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String trialName;
    private String displayName;
    private String experimentName;
    private List<Tag> tags;

    public void setTrialName(String trialName) {
        this.trialName = trialName;
    }

    public String getTrialName() {
        return this.trialName;
    }

    public CreateTrialRequest withTrialName(String trialName) {
        this.setTrialName(trialName);
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public CreateTrialRequest withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public void setExperimentName(String experimentName) {
        this.experimentName = experimentName;
    }

    public String getExperimentName() {
        return this.experimentName;
    }

    public CreateTrialRequest withExperimentName(String experimentName) {
        this.setExperimentName(experimentName);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateTrialRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateTrialRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTrialName() != null) {
            sb.append("TrialName: ").append(this.getTrialName()).append(",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append(this.getDisplayName()).append(",");
        }
        if (this.getExperimentName() != null) {
            sb.append("ExperimentName: ").append(this.getExperimentName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrialRequest)) {
            return false;
        }
        CreateTrialRequest other = (CreateTrialRequest)obj;
        if (other.getTrialName() == null ^ this.getTrialName() == null) {
            return false;
        }
        if (other.getTrialName() != null && !other.getTrialName().equals(this.getTrialName())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getExperimentName() == null ^ this.getExperimentName() == null) {
            return false;
        }
        if (other.getExperimentName() != null && !other.getExperimentName().equals(this.getExperimentName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTrialName() == null ? 0 : this.getTrialName().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getExperimentName() == null ? 0 : this.getExperimentName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateTrialRequest clone() {
        return (CreateTrialRequest)super.clone();
    }
}

