/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.ProcessingOutput;

@SdkInternalApi
public class ProcessingOutputMarshaller {
    private static final MarshallingInfo<String> OUTPUTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputName").build();
    private static final MarshallingInfo<StructuredPojo> S3OUTPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Output").build();
    private static final ProcessingOutputMarshaller instance = new ProcessingOutputMarshaller();

    public static ProcessingOutputMarshaller getInstance() {
        return instance;
    }

    public void marshall(ProcessingOutput processingOutput, ProtocolMarshaller protocolMarshaller) {
        if (processingOutput == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)processingOutput.getOutputName(), OUTPUTNAME_BINDING);
            protocolMarshaller.marshall((Object)processingOutput.getS3Output(), S3OUTPUT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

