/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3outposts;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.s3outposts.AmazonS3OutpostsAsync;
import com.amazonaws.services.s3outposts.AmazonS3OutpostsAsyncClientBuilder;
import com.amazonaws.services.s3outposts.AmazonS3OutpostsClient;
import com.amazonaws.services.s3outposts.model.CreateEndpointRequest;
import com.amazonaws.services.s3outposts.model.CreateEndpointResult;
import com.amazonaws.services.s3outposts.model.DeleteEndpointRequest;
import com.amazonaws.services.s3outposts.model.DeleteEndpointResult;
import com.amazonaws.services.s3outposts.model.ListEndpointsRequest;
import com.amazonaws.services.s3outposts.model.ListEndpointsResult;
import com.amazonaws.services.s3outposts.model.ListSharedEndpointsRequest;
import com.amazonaws.services.s3outposts.model.ListSharedEndpointsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonS3OutpostsAsyncClient
extends AmazonS3OutpostsClient
implements AmazonS3OutpostsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonS3OutpostsAsyncClientBuilder asyncBuilder() {
        return AmazonS3OutpostsAsyncClientBuilder.standard();
    }

    AmazonS3OutpostsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonS3OutpostsAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateEndpointResult> createEndpointAsync(CreateEndpointRequest request) {
        return this.createEndpointAsync(request, null);
    }

    @Override
    public Future<CreateEndpointResult> createEndpointAsync(CreateEndpointRequest request, final AsyncHandler<CreateEndpointRequest, CreateEndpointResult> asyncHandler) {
        final CreateEndpointRequest finalRequest = (CreateEndpointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateEndpointResult>(){

            @Override
            public CreateEndpointResult call() throws Exception {
                CreateEndpointResult result = null;
                try {
                    result = AmazonS3OutpostsAsyncClient.this.executeCreateEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteEndpointResult> deleteEndpointAsync(DeleteEndpointRequest request) {
        return this.deleteEndpointAsync(request, null);
    }

    @Override
    public Future<DeleteEndpointResult> deleteEndpointAsync(DeleteEndpointRequest request, final AsyncHandler<DeleteEndpointRequest, DeleteEndpointResult> asyncHandler) {
        final DeleteEndpointRequest finalRequest = (DeleteEndpointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteEndpointResult>(){

            @Override
            public DeleteEndpointResult call() throws Exception {
                DeleteEndpointResult result = null;
                try {
                    result = AmazonS3OutpostsAsyncClient.this.executeDeleteEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEndpointsResult> listEndpointsAsync(ListEndpointsRequest request) {
        return this.listEndpointsAsync(request, null);
    }

    @Override
    public Future<ListEndpointsResult> listEndpointsAsync(ListEndpointsRequest request, final AsyncHandler<ListEndpointsRequest, ListEndpointsResult> asyncHandler) {
        final ListEndpointsRequest finalRequest = (ListEndpointsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEndpointsResult>(){

            @Override
            public ListEndpointsResult call() throws Exception {
                ListEndpointsResult result = null;
                try {
                    result = AmazonS3OutpostsAsyncClient.this.executeListEndpoints(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSharedEndpointsResult> listSharedEndpointsAsync(ListSharedEndpointsRequest request) {
        return this.listSharedEndpointsAsync(request, null);
    }

    @Override
    public Future<ListSharedEndpointsResult> listSharedEndpointsAsync(ListSharedEndpointsRequest request, final AsyncHandler<ListSharedEndpointsRequest, ListSharedEndpointsResult> asyncHandler) {
        final ListSharedEndpointsRequest finalRequest = (ListSharedEndpointsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSharedEndpointsResult>(){

            @Override
            public ListSharedEndpointsResult call() throws Exception {
                ListSharedEndpointsResult result = null;
                try {
                    result = AmazonS3OutpostsAsyncClient.this.executeListSharedEndpoints(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

