/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3outposts.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.s3outposts.model.EndpointAccessType;
import com.amazonaws.services.s3outposts.model.EndpointStatus;
import com.amazonaws.services.s3outposts.model.NetworkInterface;
import com.amazonaws.services.s3outposts.model.transform.EndpointMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Endpoint
implements Serializable,
Cloneable,
StructuredPojo {
    private String endpointArn;
    private String outpostsId;
    private String cidrBlock;
    private String status;
    private Date creationTime;
    private List<NetworkInterface> networkInterfaces;
    private String vpcId;
    private String subnetId;
    private String securityGroupId;
    private String accessType;
    private String customerOwnedIpv4Pool;

    public void setEndpointArn(String endpointArn) {
        this.endpointArn = endpointArn;
    }

    public String getEndpointArn() {
        return this.endpointArn;
    }

    public Endpoint withEndpointArn(String endpointArn) {
        this.setEndpointArn(endpointArn);
        return this;
    }

    public void setOutpostsId(String outpostsId) {
        this.outpostsId = outpostsId;
    }

    public String getOutpostsId() {
        return this.outpostsId;
    }

    public Endpoint withOutpostsId(String outpostsId) {
        this.setOutpostsId(outpostsId);
        return this;
    }

    public void setCidrBlock(String cidrBlock) {
        this.cidrBlock = cidrBlock;
    }

    public String getCidrBlock() {
        return this.cidrBlock;
    }

    public Endpoint withCidrBlock(String cidrBlock) {
        this.setCidrBlock(cidrBlock);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Endpoint withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Endpoint withStatus(EndpointStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Endpoint withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public List<NetworkInterface> getNetworkInterfaces() {
        return this.networkInterfaces;
    }

    public void setNetworkInterfaces(Collection<NetworkInterface> networkInterfaces) {
        if (networkInterfaces == null) {
            this.networkInterfaces = null;
            return;
        }
        this.networkInterfaces = new ArrayList<NetworkInterface>(networkInterfaces);
    }

    public Endpoint withNetworkInterfaces(NetworkInterface ... networkInterfaces) {
        if (this.networkInterfaces == null) {
            this.setNetworkInterfaces(new ArrayList<NetworkInterface>(networkInterfaces.length));
        }
        for (NetworkInterface ele : networkInterfaces) {
            this.networkInterfaces.add(ele);
        }
        return this;
    }

    public Endpoint withNetworkInterfaces(Collection<NetworkInterface> networkInterfaces) {
        this.setNetworkInterfaces(networkInterfaces);
        return this;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public Endpoint withVpcId(String vpcId) {
        this.setVpcId(vpcId);
        return this;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public Endpoint withSubnetId(String subnetId) {
        this.setSubnetId(subnetId);
        return this;
    }

    public void setSecurityGroupId(String securityGroupId) {
        this.securityGroupId = securityGroupId;
    }

    public String getSecurityGroupId() {
        return this.securityGroupId;
    }

    public Endpoint withSecurityGroupId(String securityGroupId) {
        this.setSecurityGroupId(securityGroupId);
        return this;
    }

    public void setAccessType(String accessType) {
        this.accessType = accessType;
    }

    public String getAccessType() {
        return this.accessType;
    }

    public Endpoint withAccessType(String accessType) {
        this.setAccessType(accessType);
        return this;
    }

    public Endpoint withAccessType(EndpointAccessType accessType) {
        this.accessType = accessType.toString();
        return this;
    }

    public void setCustomerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
        this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
    }

    public String getCustomerOwnedIpv4Pool() {
        return this.customerOwnedIpv4Pool;
    }

    public Endpoint withCustomerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
        this.setCustomerOwnedIpv4Pool(customerOwnedIpv4Pool);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEndpointArn() != null) {
            sb.append("EndpointArn: ").append(this.getEndpointArn()).append(",");
        }
        if (this.getOutpostsId() != null) {
            sb.append("OutpostsId: ").append(this.getOutpostsId()).append(",");
        }
        if (this.getCidrBlock() != null) {
            sb.append("CidrBlock: ").append(this.getCidrBlock()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getNetworkInterfaces() != null) {
            sb.append("NetworkInterfaces: ").append(this.getNetworkInterfaces()).append(",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: ").append(this.getVpcId()).append(",");
        }
        if (this.getSubnetId() != null) {
            sb.append("SubnetId: ").append(this.getSubnetId()).append(",");
        }
        if (this.getSecurityGroupId() != null) {
            sb.append("SecurityGroupId: ").append(this.getSecurityGroupId()).append(",");
        }
        if (this.getAccessType() != null) {
            sb.append("AccessType: ").append(this.getAccessType()).append(",");
        }
        if (this.getCustomerOwnedIpv4Pool() != null) {
            sb.append("CustomerOwnedIpv4Pool: ").append(this.getCustomerOwnedIpv4Pool());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        if (other.getEndpointArn() == null ^ this.getEndpointArn() == null) {
            return false;
        }
        if (other.getEndpointArn() != null && !other.getEndpointArn().equals(this.getEndpointArn())) {
            return false;
        }
        if (other.getOutpostsId() == null ^ this.getOutpostsId() == null) {
            return false;
        }
        if (other.getOutpostsId() != null && !other.getOutpostsId().equals(this.getOutpostsId())) {
            return false;
        }
        if (other.getCidrBlock() == null ^ this.getCidrBlock() == null) {
            return false;
        }
        if (other.getCidrBlock() != null && !other.getCidrBlock().equals(this.getCidrBlock())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getNetworkInterfaces() == null ^ this.getNetworkInterfaces() == null) {
            return false;
        }
        if (other.getNetworkInterfaces() != null && !other.getNetworkInterfaces().equals(this.getNetworkInterfaces())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getSecurityGroupId() == null ^ this.getSecurityGroupId() == null) {
            return false;
        }
        if (other.getSecurityGroupId() != null && !other.getSecurityGroupId().equals(this.getSecurityGroupId())) {
            return false;
        }
        if (other.getAccessType() == null ^ this.getAccessType() == null) {
            return false;
        }
        if (other.getAccessType() != null && !other.getAccessType().equals(this.getAccessType())) {
            return false;
        }
        if (other.getCustomerOwnedIpv4Pool() == null ^ this.getCustomerOwnedIpv4Pool() == null) {
            return false;
        }
        return other.getCustomerOwnedIpv4Pool() == null || other.getCustomerOwnedIpv4Pool().equals(this.getCustomerOwnedIpv4Pool());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEndpointArn() == null ? 0 : this.getEndpointArn().hashCode());
        hashCode = 31 * hashCode + (this.getOutpostsId() == null ? 0 : this.getOutpostsId().hashCode());
        hashCode = 31 * hashCode + (this.getCidrBlock() == null ? 0 : this.getCidrBlock().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkInterfaces() == null ? 0 : this.getNetworkInterfaces().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroupId() == null ? 0 : this.getSecurityGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getAccessType() == null ? 0 : this.getAccessType().hashCode());
        hashCode = 31 * hashCode + (this.getCustomerOwnedIpv4Pool() == null ? 0 : this.getCustomerOwnedIpv4Pool().hashCode());
        return hashCode;
    }

    public Endpoint clone() {
        try {
            return (Endpoint)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

