/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3outposts.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.s3outposts.model.Endpoint;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class EndpointMarshaller {
    private static final MarshallingInfo<String> ENDPOINTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointArn").build();
    private static final MarshallingInfo<String> OUTPOSTSID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutpostsId").build();
    private static final MarshallingInfo<String> CIDRBLOCK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CidrBlock").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<List> NETWORKINTERFACES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NetworkInterfaces").build();
    private static final EndpointMarshaller instance = new EndpointMarshaller();

    public static EndpointMarshaller getInstance() {
        return instance;
    }

    public void marshall(Endpoint endpoint, ProtocolMarshaller protocolMarshaller) {
        if (endpoint == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)endpoint.getEndpointArn(), ENDPOINTARN_BINDING);
            protocolMarshaller.marshall((Object)endpoint.getOutpostsId(), OUTPOSTSID_BINDING);
            protocolMarshaller.marshall((Object)endpoint.getCidrBlock(), CIDRBLOCK_BINDING);
            protocolMarshaller.marshall((Object)endpoint.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)endpoint.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall(endpoint.getNetworkInterfaces(), NETWORKINTERFACES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

