/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3outposts.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.s3outposts.model.EndpointStatus;
import com.amazonaws.services.s3outposts.model.NetworkInterface;
import com.amazonaws.services.s3outposts.model.transform.EndpointMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Endpoint
implements Serializable,
Cloneable,
StructuredPojo {
    private String endpointArn;
    private String outpostsId;
    private String cidrBlock;
    private String status;
    private Date creationTime;
    private List<NetworkInterface> networkInterfaces;

    public void setEndpointArn(String endpointArn) {
        this.endpointArn = endpointArn;
    }

    public String getEndpointArn() {
        return this.endpointArn;
    }

    public Endpoint withEndpointArn(String endpointArn) {
        this.setEndpointArn(endpointArn);
        return this;
    }

    public void setOutpostsId(String outpostsId) {
        this.outpostsId = outpostsId;
    }

    public String getOutpostsId() {
        return this.outpostsId;
    }

    public Endpoint withOutpostsId(String outpostsId) {
        this.setOutpostsId(outpostsId);
        return this;
    }

    public void setCidrBlock(String cidrBlock) {
        this.cidrBlock = cidrBlock;
    }

    public String getCidrBlock() {
        return this.cidrBlock;
    }

    public Endpoint withCidrBlock(String cidrBlock) {
        this.setCidrBlock(cidrBlock);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Endpoint withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Endpoint withStatus(EndpointStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Endpoint withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public List<NetworkInterface> getNetworkInterfaces() {
        return this.networkInterfaces;
    }

    public void setNetworkInterfaces(Collection<NetworkInterface> networkInterfaces) {
        if (networkInterfaces == null) {
            this.networkInterfaces = null;
            return;
        }
        this.networkInterfaces = new ArrayList<NetworkInterface>(networkInterfaces);
    }

    public Endpoint withNetworkInterfaces(NetworkInterface ... networkInterfaces) {
        if (this.networkInterfaces == null) {
            this.setNetworkInterfaces(new ArrayList<NetworkInterface>(networkInterfaces.length));
        }
        for (NetworkInterface ele : networkInterfaces) {
            this.networkInterfaces.add(ele);
        }
        return this;
    }

    public Endpoint withNetworkInterfaces(Collection<NetworkInterface> networkInterfaces) {
        this.setNetworkInterfaces(networkInterfaces);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEndpointArn() != null) {
            sb.append("EndpointArn: ").append(this.getEndpointArn()).append(",");
        }
        if (this.getOutpostsId() != null) {
            sb.append("OutpostsId: ").append(this.getOutpostsId()).append(",");
        }
        if (this.getCidrBlock() != null) {
            sb.append("CidrBlock: ").append(this.getCidrBlock()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getNetworkInterfaces() != null) {
            sb.append("NetworkInterfaces: ").append(this.getNetworkInterfaces());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        if (other.getEndpointArn() == null ^ this.getEndpointArn() == null) {
            return false;
        }
        if (other.getEndpointArn() != null && !other.getEndpointArn().equals(this.getEndpointArn())) {
            return false;
        }
        if (other.getOutpostsId() == null ^ this.getOutpostsId() == null) {
            return false;
        }
        if (other.getOutpostsId() != null && !other.getOutpostsId().equals(this.getOutpostsId())) {
            return false;
        }
        if (other.getCidrBlock() == null ^ this.getCidrBlock() == null) {
            return false;
        }
        if (other.getCidrBlock() != null && !other.getCidrBlock().equals(this.getCidrBlock())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getNetworkInterfaces() == null ^ this.getNetworkInterfaces() == null) {
            return false;
        }
        return other.getNetworkInterfaces() == null || other.getNetworkInterfaces().equals(this.getNetworkInterfaces());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEndpointArn() == null ? 0 : this.getEndpointArn().hashCode());
        hashCode = 31 * hashCode + (this.getOutpostsId() == null ? 0 : this.getOutpostsId().hashCode());
        hashCode = 31 * hashCode + (this.getCidrBlock() == null ? 0 : this.getCidrBlock().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkInterfaces() == null ? 0 : this.getNetworkInterfaces().hashCode());
        return hashCode;
    }

    public Endpoint clone() {
        try {
            return (Endpoint)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

