/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.AccessControlTranslation;
import com.amazonaws.services.s3control.model.DeleteMarkerReplication;
import com.amazonaws.services.s3control.model.Destination;
import com.amazonaws.services.s3control.model.EncryptionConfiguration;
import com.amazonaws.services.s3control.model.ExistingObjectReplication;
import com.amazonaws.services.s3control.model.Metrics;
import com.amazonaws.services.s3control.model.PutBucketReplicationRequest;
import com.amazonaws.services.s3control.model.ReplicaModifications;
import com.amazonaws.services.s3control.model.ReplicationConfiguration;
import com.amazonaws.services.s3control.model.ReplicationRule;
import com.amazonaws.services.s3control.model.ReplicationRuleAndOperator;
import com.amazonaws.services.s3control.model.ReplicationRuleFilter;
import com.amazonaws.services.s3control.model.ReplicationTime;
import com.amazonaws.services.s3control.model.ReplicationTimeValue;
import com.amazonaws.services.s3control.model.S3Tag;
import com.amazonaws.services.s3control.model.SourceSelectionCriteria;
import com.amazonaws.services.s3control.model.SseKmsEncryptedObjects;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class PutBucketReplicationRequestMarshaller
implements Marshaller<Request<PutBucketReplicationRequest>, PutBucketReplicationRequest> {
    public Request<PutBucketReplicationRequest> marshall(PutBucketReplicationRequest putBucketReplicationRequest) {
        if (putBucketReplicationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putBucketReplicationRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putBucketReplicationRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)putBucketReplicationRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/bucket/{name}/replication";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "name", putBucketReplicationRequest.getBucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://awss3control.amazonaws.com/doc/2018-08-20/");
            ReplicationConfiguration replicationConfiguration = putBucketReplicationRequest.getReplicationConfiguration();
            if (replicationConfiguration != null) {
                List<ReplicationRule> replicationConfigurationRulesList;
                xmlWriter.startElement("ReplicationConfiguration");
                if (replicationConfiguration.getRole() != null) {
                    xmlWriter.startElement("Role").value(replicationConfiguration.getRole()).endElement();
                }
                if ((replicationConfigurationRulesList = replicationConfiguration.getRules()) != null) {
                    xmlWriter.startElement("Rules");
                    for (ReplicationRule replicationConfigurationRulesListValue : replicationConfigurationRulesList) {
                        DeleteMarkerReplication deleteMarkerReplication;
                        Destination destination;
                        ExistingObjectReplication existingObjectReplication;
                        SourceSelectionCriteria sourceSelectionCriteria;
                        ReplicationRuleFilter filter;
                        xmlWriter.startElement("Rule");
                        if (replicationConfigurationRulesListValue.getID() != null) {
                            xmlWriter.startElement("ID").value(replicationConfigurationRulesListValue.getID()).endElement();
                        }
                        if (replicationConfigurationRulesListValue.getPriority() != null) {
                            xmlWriter.startElement("Priority").value((Object)replicationConfigurationRulesListValue.getPriority()).endElement();
                        }
                        if (replicationConfigurationRulesListValue.getPrefix() != null) {
                            xmlWriter.startElement("Prefix").value(replicationConfigurationRulesListValue.getPrefix()).endElement();
                        }
                        if ((filter = replicationConfigurationRulesListValue.getFilter()) != null) {
                            ReplicationRuleAndOperator and;
                            S3Tag tag;
                            xmlWriter.startElement("Filter");
                            if (filter.getPrefix() != null) {
                                xmlWriter.startElement("Prefix").value(filter.getPrefix()).endElement();
                            }
                            if ((tag = filter.getTag()) != null) {
                                xmlWriter.startElement("Tag");
                                if (tag.getKey() != null) {
                                    xmlWriter.startElement("Key").value(tag.getKey()).endElement();
                                }
                                if (tag.getValue() != null) {
                                    xmlWriter.startElement("Value").value(tag.getValue()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((and = filter.getAnd()) != null) {
                                List<S3Tag> replicationRuleAndOperatorTagsList;
                                xmlWriter.startElement("And");
                                if (and.getPrefix() != null) {
                                    xmlWriter.startElement("Prefix").value(and.getPrefix()).endElement();
                                }
                                if ((replicationRuleAndOperatorTagsList = and.getTags()) != null) {
                                    xmlWriter.startElement("Tags");
                                    for (S3Tag replicationRuleAndOperatorTagsListValue : replicationRuleAndOperatorTagsList) {
                                        xmlWriter.startElement("member");
                                        if (replicationRuleAndOperatorTagsListValue.getKey() != null) {
                                            xmlWriter.startElement("Key").value(replicationRuleAndOperatorTagsListValue.getKey()).endElement();
                                        }
                                        if (replicationRuleAndOperatorTagsListValue.getValue() != null) {
                                            xmlWriter.startElement("Value").value(replicationRuleAndOperatorTagsListValue.getValue()).endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if (replicationConfigurationRulesListValue.getStatus() != null) {
                            xmlWriter.startElement("Status").value(replicationConfigurationRulesListValue.getStatus()).endElement();
                        }
                        if ((sourceSelectionCriteria = replicationConfigurationRulesListValue.getSourceSelectionCriteria()) != null) {
                            ReplicaModifications replicaModifications;
                            xmlWriter.startElement("SourceSelectionCriteria");
                            SseKmsEncryptedObjects sseKmsEncryptedObjects = sourceSelectionCriteria.getSseKmsEncryptedObjects();
                            if (sseKmsEncryptedObjects != null) {
                                xmlWriter.startElement("SseKmsEncryptedObjects");
                                if (sseKmsEncryptedObjects.getStatus() != null) {
                                    xmlWriter.startElement("Status").value(sseKmsEncryptedObjects.getStatus()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((replicaModifications = sourceSelectionCriteria.getReplicaModifications()) != null) {
                                xmlWriter.startElement("ReplicaModifications");
                                if (replicaModifications.getStatus() != null) {
                                    xmlWriter.startElement("Status").value(replicaModifications.getStatus()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((existingObjectReplication = replicationConfigurationRulesListValue.getExistingObjectReplication()) != null) {
                            xmlWriter.startElement("ExistingObjectReplication");
                            if (existingObjectReplication.getStatus() != null) {
                                xmlWriter.startElement("Status").value(existingObjectReplication.getStatus()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((destination = replicationConfigurationRulesListValue.getDestination()) != null) {
                            Metrics metrics;
                            EncryptionConfiguration encryptionConfiguration;
                            AccessControlTranslation accessControlTranslation;
                            ReplicationTime replicationTime;
                            xmlWriter.startElement("Destination");
                            if (destination.getAccount() != null) {
                                xmlWriter.startElement("Account").value(destination.getAccount()).endElement();
                            }
                            if (destination.getBucket() != null) {
                                xmlWriter.startElement("Bucket").value(destination.getBucket()).endElement();
                            }
                            if ((replicationTime = destination.getReplicationTime()) != null) {
                                ReplicationTimeValue time;
                                xmlWriter.startElement("ReplicationTime");
                                if (replicationTime.getStatus() != null) {
                                    xmlWriter.startElement("Status").value(replicationTime.getStatus()).endElement();
                                }
                                if ((time = replicationTime.getTime()) != null) {
                                    xmlWriter.startElement("Time");
                                    if (time.getMinutes() != null) {
                                        xmlWriter.startElement("Minutes").value((Object)time.getMinutes()).endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((accessControlTranslation = destination.getAccessControlTranslation()) != null) {
                                xmlWriter.startElement("AccessControlTranslation");
                                if (accessControlTranslation.getOwner() != null) {
                                    xmlWriter.startElement("Owner").value(accessControlTranslation.getOwner()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((encryptionConfiguration = destination.getEncryptionConfiguration()) != null) {
                                xmlWriter.startElement("EncryptionConfiguration");
                                if (encryptionConfiguration.getReplicaKmsKeyID() != null) {
                                    xmlWriter.startElement("ReplicaKmsKeyID").value(encryptionConfiguration.getReplicaKmsKeyID()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((metrics = destination.getMetrics()) != null) {
                                ReplicationTimeValue eventThreshold;
                                xmlWriter.startElement("Metrics");
                                if (metrics.getStatus() != null) {
                                    xmlWriter.startElement("Status").value(metrics.getStatus()).endElement();
                                }
                                if ((eventThreshold = metrics.getEventThreshold()) != null) {
                                    xmlWriter.startElement("EventThreshold");
                                    if (eventThreshold.getMinutes() != null) {
                                        xmlWriter.startElement("Minutes").value((Object)eventThreshold.getMinutes()).endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if (destination.getStorageClass() != null) {
                                xmlWriter.startElement("StorageClass").value(destination.getStorageClass()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((deleteMarkerReplication = replicationConfigurationRulesListValue.getDeleteMarkerReplication()) != null) {
                            xmlWriter.startElement("DeleteMarkerReplication");
                            if (deleteMarkerReplication.getStatus() != null) {
                                xmlWriter.startElement("Status").value(deleteMarkerReplication.getStatus()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if (replicationConfigurationRulesListValue.getBucket() != null) {
                            xmlWriter.startElement("Bucket").value(replicationConfigurationRulesListValue.getBucket()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

