/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.DeleteBucketPolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;

public class DeleteBucketPolicyRequestMarshaller
implements Marshaller<Request<DeleteBucketPolicyRequest>, DeleteBucketPolicyRequest> {
    public Request<DeleteBucketPolicyRequest> marshall(DeleteBucketPolicyRequest deleteBucketPolicyRequest) {
        if (deleteBucketPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteBucketPolicyRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (deleteBucketPolicyRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)deleteBucketPolicyRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/bucket/{name}/policy";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "name", deleteBucketPolicyRequest.getBucket());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

